/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.format;

import com.soywiz.korim.bitmap.Bitmap;
import com.soywiz.korim.bitmap.Bitmap32;
import com.soywiz.korim.bitmap.Bitmap8;
import com.soywiz.korim.color.ColorFormat;
import com.soywiz.korim.color.RGB;
import com.soywiz.korim.color.RGBA;
import com.soywiz.korim.format.ImageData;
import com.soywiz.korim.format.ImageDecodingProps;
import com.soywiz.korim.format.ImageEncodingProps;
import com.soywiz.korim.format.ImageFormat;
import com.soywiz.korim.format.ImageFrame;
import com.soywiz.korim.format.ImageInfo;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncOutputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/soywiz/korim/format/TGA;", "Lcom/soywiz/korim/format/ImageFormat;", "()V", "decodeHeader", "Lcom/soywiz/korim/format/ImageInfo;", "s", "Lcom/soywiz/korio/stream/SyncStream;", "props", "Lcom/soywiz/korim/format/ImageDecodingProps;", "readHeader", "Lcom/soywiz/korim/format/TGA$Info;", "readImage", "Lcom/soywiz/korim/format/ImageData;", "writeImage", "", "image", "Lcom/soywiz/korim/format/ImageEncodingProps;", "Info", "korim_debug"})
public final class TGA
extends ImageFormat {
    public static final TGA INSTANCE;

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        try {
            ImageInfo imageInfo;
            object = Result.Companion;
            boolean bl = false;
            ImageInfo $receiver = imageInfo = new ImageInfo();
            boolean bl2 = false;
            Info h = INSTANCE.readHeader(s);
            $receiver.setWidth(h.getWidth());
            $receiver.setHeight(h.getHeight());
            $receiver.setBitsPerPixel(h.getBitsPerPixel());
            ImageInfo imageInfo2 = imageInfo;
            object = Result.constructor-impl((Object)imageInfo2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (ImageInfo)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public final Info readHeader(@NotNull SyncStream s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        int idLength = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        int colorMapType = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        int imageType = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        switch (imageType) {
            case 1: {
                String string = "Unsupported indexed";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            case 2: {
                break;
            }
            case 9: 
            case 10: {
                String string = "Unsupported RLE";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                String string = "Unknown TGA";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        int firstIndexEntry = SyncStreamKt.readU16LE((SyncInputStream)((SyncInputStream)s));
        int colorMapLength = SyncStreamKt.readU16LE((SyncInputStream)((SyncInputStream)s));
        int colorMapEntrySize = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        SyncStream syncStream = s;
        syncStream.setPosition(syncStream.getPosition() + (long)(colorMapLength * colorMapEntrySize));
        int xorig = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int yorig = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int width = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int height = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int pixelDepth = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        switch (pixelDepth) {
            case 24: 
            case 32: {
                break;
            }
            default: {
                String string = "Not a RGBA tga";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        int imageDescriptor = SyncStreamKt.readU8((SyncInputStream)((SyncInputStream)s));
        boolean flipY = (imageDescriptor >>> 5 & 1) == 0;
        int storage = imageDescriptor >>> 6 & 3;
        SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)s), (int)idLength);
        return new Info(width, height, flipY, pixelDepth);
    }

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ColorFormat colorFormat;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        Info info = this.readHeader(s);
        switch (info.getBitsPerPixel()) {
            case 24: {
                colorFormat = RGB.Companion;
                break;
            }
            case 32: {
                colorFormat = RGBA.Companion;
                break;
            }
            default: {
                String string = "Not a RGBA tga";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        ColorFormat format = colorFormat;
        Bitmap32 out = Bitmap32.writeDecoded$default(new Bitmap32(info.getWidth(), info.getHeight(), null, false, 12, null), format, SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)s), (int)(info.getArea() * info.getBytes())), 0, false, 12, null);
        if (info.getFlipY()) {
            out.flipY();
        }
        return new ImageData(CollectionsKt.listOf((Object)new ImageFrame(out, 0L, 0, 0, false, 30, null)));
    }

    @Override
    public void writeImage(@NotNull ImageData image, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        Bitmap bitmap2 = bitmap = image.getMainBitmap();
        if (bitmap2 instanceof Bitmap8) {
            String string = "Not implemented encoding TGA Bitmap8";
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        Bitmap32 bmp2 = bitmap.toBMP32();
        byte[] data = new byte[bmp2.getArea() * 4];
        int m = 0;
        for (int c : bmp2.getData()) {
            data[m++] = (byte)RGBA.getB-impl(c);
            data[m++] = (byte)RGBA.getG-impl(c);
            data[m++] = (byte)RGBA.getR-impl(c);
            data[m++] = (byte)RGBA.getA-impl(c);
        }
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)2);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)bmp2.getWidth());
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)bmp2.getHeight());
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)32);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)32);
        SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)s), (byte[])data);
    }

    private TGA() {
        super("tga");
    }

    static {
        TGA tGA;
        INSTANCE = tGA = new TGA();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/soywiz/korim/format/TGA$Info;", "", "width", "", "height", "flipY", "", "bitsPerPixel", "(IIZI)V", "area", "getArea", "()I", "getBitsPerPixel", "bytes", "getBytes", "getFlipY", "()Z", "getHeight", "getWidth", "korim_debug"})
    public static final class Info {
        private final int area;
        private final int bytes;
        private final int width;
        private final int height;
        private final boolean flipY;
        private final int bitsPerPixel;

        public final int getArea() {
            return this.area;
        }

        public final int getBytes() {
            return this.bytes;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final boolean getFlipY() {
            return this.flipY;
        }

        public final int getBitsPerPixel() {
            return this.bitsPerPixel;
        }

        public Info(int width, int height, boolean flipY, int bitsPerPixel) {
            this.width = width;
            this.height = height;
            this.flipY = flipY;
            this.bitsPerPixel = bitsPerPixel;
            this.area = this.width * this.height;
            this.bytes = this.bitsPerPixel / 8;
        }
    }
}

