/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.format;

import com.soywiz.korim.bitmap.Bitmap32;
import com.soywiz.korim.color.RGBA;
import com.soywiz.korim.format.ImageData;
import com.soywiz.korim.format.ImageDecodingProps;
import com.soywiz.korim.format.ImageFormat;
import com.soywiz.korim.format.ImageFrame;
import com.soywiz.korim.format.ImageInfo;
import com.soywiz.korio.lang.ExceptionsKt;
import com.soywiz.korio.stream.FastByteArrayInputStream;
import com.soywiz.korio.stream.FastByteArrayInputStreamKt;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\u0014\u001a\u00020\n*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/soywiz/korim/format/PSD;", "Lcom/soywiz/korim/format/ImageFormat;", "()V", "decodeHeader", "Lcom/soywiz/korim/format/PSD$PsdImageInfo;", "s", "Lcom/soywiz/korio/stream/SyncStream;", "props", "Lcom/soywiz/korim/format/ImageDecodingProps;", "packChannels", "Lcom/soywiz/korim/bitmap/Bitmap32;", "width", "", "height", "channels", "", "", "(II[[B)Lcom/soywiz/korim/bitmap/Bitmap32;", "readImage", "Lcom/soywiz/korim/format/ImageData;", "readImageData", "Lcom/soywiz/korio/stream/FastByteArrayInputStream;", "header", "PsdImageInfo", "korim_debug"})
public final class PSD
extends ImageFormat {
    public static final PSD INSTANCE;

    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        SyncStream syncStream;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        SyncStream $receiver = syncStream = s;
        boolean bl = false;
        PsdImageInfo psdImageInfo = INSTANCE.decodeHeader($receiver, props);
        if (psdImageInfo == null) {
            Void void_ = ExceptionsKt.invalidOp((String)"Not a PSD file");
            throw null;
        }
        PsdImageInfo header = psdImageInfo;
        SyncStream colorMode = SyncStreamKt.readStream((SyncStream)$receiver, (int)SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)$receiver)));
        SyncStream imageResources = SyncStreamKt.readStream((SyncStream)$receiver, (int)SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)$receiver)));
        SyncStream layerAndMask = SyncStreamKt.readStream((SyncStream)$receiver, (int)SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)$receiver)));
        Bitmap32 imageData = INSTANCE.readImageData(FastByteArrayInputStreamKt.openFastStream$default((byte[])SyncStreamKt.readAvailable((SyncStream)$receiver), (int)0, (int)1, null), header);
        return new ImageData(CollectionsKt.listOf((Object)new ImageFrame(imageData, 0L, 0, 0, false, 30, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap32 packChannels(int width, int height, byte[][] channels) {
        byte[] byArray;
        byte[] bchannel;
        byte[] byArray2;
        byte[] gchannel;
        byte[] byArray3;
        byte[] rchannel;
        int pos = 0;
        Bitmap32 out = new Bitmap32(width, height, null, false, 12, null);
        int size$iv = width * height;
        byte[] result$iv = new byte[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            int n3;
            void i$iv;
            void var11_13 = i$iv;
            void var22_16 = i$iv++;
            byte[] byArray4 = result$iv;
            boolean bl = false;
            byArray4[var22_16] = n3 = -1;
        }
        byte[] dummyChannel = result$iv;
        byte[] byArray5 = (byte[])ArraysKt.getOrNull((Object[])((Object[])channels), (int)0);
        if (byArray5 == null) {
            byArray5 = rchannel = dummyChannel;
        }
        if ((byArray3 = (byte[])ArraysKt.getOrNull((Object[])((Object[])channels), (int)1)) == null) {
            byArray3 = gchannel = dummyChannel;
        }
        if ((byArray2 = (byte[])ArraysKt.getOrNull((Object[])((Object[])channels), (int)2)) == null) {
            byArray2 = bchannel = dummyChannel;
        }
        if ((byArray = (byte[])ArraysKt.getOrNull((Object[])((Object[])channels), (int)3)) == null) {
            byArray = dummyChannel;
        }
        byte[] achannel = byArray;
        int it = 0;
        int n4 = height;
        while (it < n4) {
            void y;
            int $i$f$ByteArray = 0;
            int n5 = width;
            while ($i$f$ByteArray < n5) {
                void x;
                byte $receiver$iv = rchannel[pos];
                boolean $i$f$getUnsigned = false;
                int r = $receiver$iv & 0xFF;
                byte $receiver$iv2 = gchannel[pos];
                boolean $i$f$getUnsigned2 = false;
                int g = $receiver$iv2 & 0xFF;
                byte $receiver$iv3 = bchannel[pos];
                boolean $i$f$getUnsigned3 = false;
                int b = $receiver$iv3 & 0xFF;
                byte $receiver$iv4 = achannel[pos];
                boolean $i$f$getUnsigned4 = false;
                int a = $receiver$iv4 & 0xFF;
                out.getData()[pos] = RGBA.Companion.packFast(r, g, b, a);
                ++pos;
                ++x;
            }
            ++y;
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap32 readImageData(@NotNull FastByteArrayInputStream $receiver, PsdImageInfo header) {
        Object object;
        int i$iv;
        int compressionMethod = $receiver.readU16BE();
        int width = header.getWidth();
        int height = header.getHeight();
        int cchannels = header.getChannels();
        byte[][] result$iv2 = new byte[cchannels][];
        int n = 0;
        int n2 = result$iv2.length;
        while (n < n2) {
            void var11_15 = i$iv;
            int n3 = i$iv++;
            object = result$iv2;
            boolean bl = false;
            byte[] byArray = new byte[width * height];
            object[n3] = byArray;
        }
        byte[][] channels = result$iv2;
        switch (compressionMethod) {
            case 0: {
                int result$iv2 = 0;
                i$iv = cchannels;
                while (result$iv2 < i$iv) {
                    void n4;
                    channels[n4] = $receiver.readBytes(width * height);
                    ++n4;
                }
                break;
            }
            case 1: {
                void $receiver$iv$iv;
                Iterable $receiver$iv22;
                Iterable iterable = $receiver$iv22 = (Iterable)RangesKt.until((int)0, (int)cchannels);
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
                Iterator bl = $receiver$iv$iv.iterator();
                while (bl.hasNext()) {
                    int item$iv$iv;
                    int n5 = item$iv$iv = ((IntIterator)bl).nextInt();
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    short[] sArray = $receiver.readShortArrayBE(height);
                    object.add(sArray);
                }
                List sizes = (List)destination$iv$iv;
                int $receiver$iv22 = 0;
                int n6 = cchannels;
                while ($receiver$iv22 < n6) {
                    void cindex;
                    byte[] carray = channels[cindex];
                    int cpos = 0;
                    for (short size : (short[])sizes.get((int)cindex)) {
                        int end = $receiver.getOffset() + size;
                        block9: while ($receiver.getOffset() < end) {
                            int n7;
                            int n8;
                            int len = $receiver.readU8();
                            if (len >= 128) {
                                n8 = $receiver.readU8();
                                n7 = 0;
                                int n9 = 256 - len;
                                if (n7 > n9) continue;
                                while (true) {
                                    void j;
                                    carray[cpos++] = (byte)n8;
                                    if (j == n9) continue block9;
                                    ++j;
                                }
                            }
                            n8 = 0;
                            n7 = len;
                            if (n8 > n7) continue;
                            while (true) {
                                void j;
                                carray[cpos++] = (byte)$receiver.readU8();
                                if (j == n7) continue block9;
                                ++j;
                            }
                        }
                    }
                    ++cindex;
                }
                break;
            }
            default: {
                Void void_ = ExceptionsKt.invalidOp((String)("Unsupported compression method " + compressionMethod));
                throw null;
            }
        }
        return this.packChannels(width, height, channels);
    }

    @Override
    @Nullable
    public PsdImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        PsdImageInfo psdImageInfo;
        SyncStream syncStream;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        SyncStream $receiver = syncStream = s;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)$receiver), (int)4, null, (int)2, null), (Object)"8BPS") ^ true) {
            return null;
        }
        int version = SyncStreamKt.readU16BE((SyncInputStream)((SyncInputStream)$receiver));
        switch (version) {
            case 1: {
                break;
            }
            case 2: {
                return null;
            }
            default: {
                return null;
            }
        }
        byte[] reserved = SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)$receiver), (int)6);
        int channels = SyncStreamKt.readU16BE((SyncInputStream)((SyncInputStream)$receiver));
        int height = SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)$receiver));
        int width = SyncStreamKt.readS32BE((SyncInputStream)((SyncInputStream)$receiver));
        int bitsPerChannel = SyncStreamKt.readU16BE((SyncInputStream)((SyncInputStream)$receiver));
        int colorMode = SyncStreamKt.readU16BE((SyncInputStream)((SyncInputStream)$receiver));
        PsdImageInfo $receiver2 = psdImageInfo = new PsdImageInfo();
        boolean bl2 = false;
        $receiver2.setWidth(width);
        $receiver2.setHeight(height);
        $receiver2.setBitsPerPixel(bitsPerChannel * channels);
        $receiver2.setChannels(channels);
        $receiver2.setBitsPerChannel(bitsPerChannel);
        $receiver2.setColorMode(colorMode);
        return psdImageInfo;
    }

    private PSD() {
        super("psd");
    }

    static {
        PSD pSD;
        INSTANCE = pSD = new PSD();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/soywiz/korim/format/PSD$PsdImageInfo;", "Lcom/soywiz/korim/format/ImageInfo;", "()V", "bitsPerChannel", "", "getBitsPerChannel", "()I", "setBitsPerChannel", "(I)V", "channels", "getChannels", "setChannels", "colorMode", "getColorMode", "setColorMode", "korim_debug"})
    public static final class PsdImageInfo
    extends ImageInfo {
        private int channels;
        private int bitsPerChannel;
        private int colorMode;

        public final int getChannels() {
            return this.channels;
        }

        public final void setChannels(int n) {
            this.channels = n;
        }

        public final int getBitsPerChannel() {
            return this.bitsPerChannel;
        }

        public final void setBitsPerChannel(int n) {
            this.bitsPerChannel = n;
        }

        public final int getColorMode() {
            return this.colorMode;
        }

        public final void setColorMode(int n) {
            this.colorMode = n;
        }
    }
}

