/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.bitmap;

import com.soywiz.korim.bitmap.Bitmap;
import com.soywiz.korim.color.ColorFormat;
import com.soywiz.korim.color.RGBA_4444;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ@\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0019\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J!\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0086\u0002J \u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J \u0010!\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/soywiz/korim/bitmap/Bitmap16;", "Lcom/soywiz/korim/bitmap/Bitmap;", "width", "", "height", "data", "", "format", "Lcom/soywiz/korim/color/ColorFormat;", "premult", "", "(II[SLcom/soywiz/korim/color/ColorFormat;Z)V", "getData", "()[S", "getFormat", "()Lcom/soywiz/korim/color/ColorFormat;", "copy", "", "srcX", "srcY", "dst", "dstX", "dstY", "createWithThisFormat", "get", "x", "y", "get32Int", "getInt", "set", "color", "set32Int", "v", "setInt", "toString", "", "korim_debug"})
public final class Bitmap16
extends Bitmap {
    @NotNull
    private final short[] data;
    @NotNull
    private final ColorFormat format;

    @Override
    @NotNull
    public Bitmap createWithThisFormat(int width, int height) {
        return new Bitmap16(width, height, null, this.format, this.getPremult(), 4, null);
    }

    public final void set(int x, int y, int color) {
        this.setInt(x, y, color);
    }

    public final int get(int x, int y) {
        return this.getInt(x, y);
    }

    @Override
    public void setInt(int x, int y, int color) {
        Unit unit;
        Unit $receiver = unit = Unit.INSTANCE;
        boolean bl = false;
        this.data[this.index((int)x, (int)y)] = (short)color;
    }

    @Override
    public int getInt(int x, int y) {
        return this.data[this.index(x, y)] & 0xFFFF;
    }

    @Override
    public void set32Int(int x, int y, int v) {
        Unit unit;
        Unit $receiver = unit = Unit.INSTANCE;
        boolean bl = false;
        this.data[this.index((int)x, (int)y)] = (short)this.format.packRGBAInt(v);
    }

    @Override
    public int get32Int(int x, int y) {
        return this.format.unpackToRGBAInt(this.data[this.index(x, y)]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copy(int srcX, int srcY, @NotNull Bitmap dst, int dstX, int dstY, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        Bitmap16 src = this;
        short[] srcArray = src.data;
        int srcIndex = src.index(srcX, srcY);
        int srcAdd = src.getWidth();
        short[] dstArray = ((Bitmap16)dst).data;
        int dstIndex = dst.index(dstX, dstY);
        int dstAdd = dst.getWidth();
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void y;
            boolean $i$f$arraycopy = false;
            boolean bl = false;
            ArraysKt.copyInto((short[])srcArray, (short[])dstArray, (int)dstIndex, (int)srcIndex, (int)(srcIndex + width));
            srcIndex += srcAdd;
            dstIndex += dstAdd;
            ++y;
        }
    }

    @NotNull
    public String toString() {
        return "Bitmap16(" + this.getWidth() + ", " + this.getHeight() + ", format=" + this.format + ')';
    }

    @NotNull
    public final short[] getData() {
        return this.data;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    public Bitmap16(int width, int height, @NotNull short[] data, @NotNull ColorFormat format, boolean premult) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        super(width, height, 16, premult, data);
        this.data = data;
        this.format = format;
    }

    public /* synthetic */ Bitmap16(int n, int n2, short[] sArray, ColorFormat colorFormat, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            sArray = new short[n * n2];
        }
        if ((n3 & 8) != 0) {
            colorFormat = RGBA_4444.INSTANCE;
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, sArray, colorFormat, bl);
    }
}

