/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import com.soundcloud.android.crop.R;

public class HighlightView {
    public static final int GROW_NONE = 1;
    public static final int GROW_LEFT_EDGE = 2;
    public static final int GROW_RIGHT_EDGE = 4;
    public static final int GROW_TOP_EDGE = 8;
    public static final int GROW_BOTTOM_EDGE = 16;
    public static final int MOVE = 32;
    public static final int DEFAULT_HIGHLIGHT_COLOR = -13388315;
    private static final float HANDLE_RADIUS_DP = 12.0f;
    private static final float OUTLINE_DP = 2.0f;
    RectF cropRect;
    Rect drawRect;
    Matrix matrix;
    private RectF imageRect;
    private final Paint outsidePaint = new Paint();
    private final Paint outlinePaint = new Paint();
    private final Paint handlePaint = new Paint();
    private View viewContext;
    private boolean showThirds;
    private boolean showCircle;
    private int highlightColor;
    private ModifyMode modifyMode = ModifyMode.None;
    private HandleMode handleMode = HandleMode.Changing;
    private boolean maintainAspectRatio;
    private float initialAspectRatio;
    private float handleRadius;
    private float outlineWidth;
    private boolean isFocused;

    public HighlightView(View context) {
        this.viewContext = context;
        this.initStyles(context.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStyles(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.cropImageStyle, outValue, true);
        TypedArray attributes = context.obtainStyledAttributes(outValue.resourceId, R.styleable.CropImageView);
        try {
            this.showThirds = attributes.getBoolean(R.styleable.CropImageView_showThirds, false);
            this.showCircle = attributes.getBoolean(R.styleable.CropImageView_showCircle, false);
            this.highlightColor = attributes.getColor(R.styleable.CropImageView_highlightColor, -13388315);
            this.handleMode = HandleMode.values()[attributes.getInt(R.styleable.CropImageView_showHandles, 1)];
        }
        finally {
            attributes.recycle();
        }
    }

    public void setup(Matrix m, Rect imageRect, RectF cropRect, boolean maintainAspectRatio) {
        this.matrix = new Matrix(m);
        this.cropRect = cropRect;
        this.imageRect = new RectF(imageRect);
        this.maintainAspectRatio = maintainAspectRatio;
        this.initialAspectRatio = this.cropRect.width() / this.cropRect.height();
        this.drawRect = this.computeLayout();
        this.outsidePaint.setARGB(125, 50, 50, 50);
        this.outlinePaint.setStyle(Paint.Style.STROKE);
        this.outlinePaint.setAntiAlias(true);
        this.outlineWidth = this.dpToPx(2.0f);
        this.handlePaint.setColor(this.highlightColor);
        this.handlePaint.setStyle(Paint.Style.FILL);
        this.handlePaint.setAntiAlias(true);
        this.handleRadius = this.dpToPx(12.0f);
        this.modifyMode = ModifyMode.None;
    }

    private float dpToPx(float dp) {
        return dp * this.viewContext.getResources().getDisplayMetrics().density;
    }

    protected void draw(Canvas canvas) {
        canvas.save();
        Path path = new Path();
        this.outlinePaint.setStrokeWidth(this.outlineWidth);
        if (!this.hasFocus()) {
            this.outlinePaint.setColor(-16777216);
            canvas.drawRect(this.drawRect, this.outlinePaint);
        } else {
            Rect viewDrawingRect = new Rect();
            this.viewContext.getDrawingRect(viewDrawingRect);
            path.addRect(new RectF(this.drawRect), Path.Direction.CW);
            this.outlinePaint.setColor(this.highlightColor);
            if (this.isClipPathSupported(canvas)) {
                canvas.clipPath(path, Region.Op.DIFFERENCE);
                canvas.drawRect(viewDrawingRect, this.outsidePaint);
            } else {
                this.drawOutsideFallback(canvas);
            }
            canvas.restore();
            canvas.drawPath(path, this.outlinePaint);
            if (this.showThirds) {
                this.drawThirds(canvas);
            }
            if (this.showCircle) {
                this.drawCircle(canvas);
            }
            if (this.handleMode == HandleMode.Always || this.handleMode == HandleMode.Changing && this.modifyMode == ModifyMode.Grow) {
                this.drawHandles(canvas);
            }
        }
    }

    private void drawOutsideFallback(Canvas canvas) {
        canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)this.drawRect.top, this.outsidePaint);
        canvas.drawRect(0.0f, (float)this.drawRect.bottom, (float)canvas.getWidth(), (float)canvas.getHeight(), this.outsidePaint);
        canvas.drawRect(0.0f, (float)this.drawRect.top, (float)this.drawRect.left, (float)this.drawRect.bottom, this.outsidePaint);
        canvas.drawRect((float)this.drawRect.right, (float)this.drawRect.top, (float)canvas.getWidth(), (float)this.drawRect.bottom, this.outsidePaint);
    }

    @SuppressLint(value={"NewApi"})
    private boolean isClipPathSupported(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 17) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14 || Build.VERSION.SDK_INT > 15) {
            return true;
        }
        return !canvas.isHardwareAccelerated();
    }

    private void drawHandles(Canvas canvas) {
        int xMiddle = this.drawRect.left + (this.drawRect.right - this.drawRect.left) / 2;
        int yMiddle = this.drawRect.top + (this.drawRect.bottom - this.drawRect.top) / 2;
        canvas.drawCircle((float)this.drawRect.left, (float)yMiddle, this.handleRadius, this.handlePaint);
        canvas.drawCircle((float)xMiddle, (float)this.drawRect.top, this.handleRadius, this.handlePaint);
        canvas.drawCircle((float)this.drawRect.right, (float)yMiddle, this.handleRadius, this.handlePaint);
        canvas.drawCircle((float)xMiddle, (float)this.drawRect.bottom, this.handleRadius, this.handlePaint);
    }

    private void drawThirds(Canvas canvas) {
        this.outlinePaint.setStrokeWidth(1.0f);
        float xThird = (this.drawRect.right - this.drawRect.left) / 3;
        float yThird = (this.drawRect.bottom - this.drawRect.top) / 3;
        canvas.drawLine((float)this.drawRect.left + xThird, (float)this.drawRect.top, (float)this.drawRect.left + xThird, (float)this.drawRect.bottom, this.outlinePaint);
        canvas.drawLine((float)this.drawRect.left + xThird * 2.0f, (float)this.drawRect.top, (float)this.drawRect.left + xThird * 2.0f, (float)this.drawRect.bottom, this.outlinePaint);
        canvas.drawLine((float)this.drawRect.left, (float)this.drawRect.top + yThird, (float)this.drawRect.right, (float)this.drawRect.top + yThird, this.outlinePaint);
        canvas.drawLine((float)this.drawRect.left, (float)this.drawRect.top + yThird * 2.0f, (float)this.drawRect.right, (float)this.drawRect.top + yThird * 2.0f, this.outlinePaint);
    }

    private void drawCircle(Canvas canvas) {
        this.outlinePaint.setStrokeWidth(1.0f);
        canvas.drawOval(new RectF(this.drawRect), this.outlinePaint);
    }

    public void setMode(ModifyMode mode) {
        if (mode != this.modifyMode) {
            this.modifyMode = mode;
            this.viewContext.invalidate();
        }
    }

    public void setColor(int color) {
        this.highlightColor = color;
    }

    public void setShowThirds(boolean show) {
        this.showThirds = show;
    }

    public void setShowCircle(boolean show) {
        this.showCircle = show;
    }

    public void setHandleMode(HandleMode mode) {
        this.handleMode = mode;
    }

    public int getHit(float x, float y) {
        boolean horizCheck;
        Rect r = this.computeLayout();
        float hysteresis = 20.0f;
        int retval = 1;
        boolean verticalCheck = y >= (float)r.top - 20.0f && y < (float)r.bottom + 20.0f;
        boolean bl = horizCheck = x >= (float)r.left - 20.0f && x < (float)r.right + 20.0f;
        if (Math.abs((float)r.left - x) < 20.0f && verticalCheck) {
            retval |= 2;
        }
        if (Math.abs((float)r.right - x) < 20.0f && verticalCheck) {
            retval |= 4;
        }
        if (Math.abs((float)r.top - y) < 20.0f && horizCheck) {
            retval |= 8;
        }
        if (Math.abs((float)r.bottom - y) < 20.0f && horizCheck) {
            retval |= 0x10;
        }
        if (retval == 1 && r.contains((int)x, (int)y)) {
            retval = 32;
        }
        return retval;
    }

    void handleMotion(int edge, float dx, float dy) {
        Rect r = this.computeLayout();
        if (edge == 32) {
            this.moveBy(dx * (this.cropRect.width() / (float)r.width()), dy * (this.cropRect.height() / (float)r.height()));
        } else {
            if ((6 & edge) == 0) {
                dx = 0.0f;
            }
            if ((0x18 & edge) == 0) {
                dy = 0.0f;
            }
            float xDelta = dx * (this.cropRect.width() / (float)r.width());
            float yDelta = dy * (this.cropRect.height() / (float)r.height());
            this.growBy((float)((edge & 2) != 0 ? -1 : 1) * xDelta, (float)((edge & 8) != 0 ? -1 : 1) * yDelta);
        }
    }

    void moveBy(float dx, float dy) {
        Rect invalRect = new Rect(this.drawRect);
        this.cropRect.offset(dx, dy);
        this.cropRect.offset(Math.max(0.0f, this.imageRect.left - this.cropRect.left), Math.max(0.0f, this.imageRect.top - this.cropRect.top));
        this.cropRect.offset(Math.min(0.0f, this.imageRect.right - this.cropRect.right), Math.min(0.0f, this.imageRect.bottom - this.cropRect.bottom));
        this.drawRect = this.computeLayout();
        invalRect.union(this.drawRect);
        invalRect.inset(-((int)this.handleRadius), -((int)this.handleRadius));
        this.viewContext.invalidate(invalRect);
    }

    void growBy(float dx, float dy) {
        float heightCap;
        if (this.maintainAspectRatio) {
            if (dx != 0.0f) {
                dy = dx / this.initialAspectRatio;
            } else if (dy != 0.0f) {
                dx = dy * this.initialAspectRatio;
            }
        }
        RectF r = new RectF(this.cropRect);
        if (dx > 0.0f && r.width() + 2.0f * dx > this.imageRect.width()) {
            dx = (this.imageRect.width() - r.width()) / 2.0f;
            if (this.maintainAspectRatio) {
                dy = dx / this.initialAspectRatio;
            }
        }
        if (dy > 0.0f && r.height() + 2.0f * dy > this.imageRect.height()) {
            dy = (this.imageRect.height() - r.height()) / 2.0f;
            if (this.maintainAspectRatio) {
                dx = dy * this.initialAspectRatio;
            }
        }
        r.inset(-dx, -dy);
        float widthCap = 25.0f;
        if (r.width() < 25.0f) {
            r.inset(-(25.0f - r.width()) / 2.0f, 0.0f);
        }
        float f = heightCap = this.maintainAspectRatio ? 25.0f / this.initialAspectRatio : 25.0f;
        if (r.height() < heightCap) {
            r.inset(0.0f, -(heightCap - r.height()) / 2.0f);
        }
        if (r.left < this.imageRect.left) {
            r.offset(this.imageRect.left - r.left, 0.0f);
        } else if (r.right > this.imageRect.right) {
            r.offset(-(r.right - this.imageRect.right), 0.0f);
        }
        if (r.top < this.imageRect.top) {
            r.offset(0.0f, this.imageRect.top - r.top);
        } else if (r.bottom > this.imageRect.bottom) {
            r.offset(0.0f, -(r.bottom - this.imageRect.bottom));
        }
        this.cropRect.set(r);
        this.drawRect = this.computeLayout();
        this.viewContext.invalidate();
    }

    public Rect getScaledCropRect(float scale) {
        return new Rect((int)(this.cropRect.left * scale), (int)(this.cropRect.top * scale), (int)(this.cropRect.right * scale), (int)(this.cropRect.bottom * scale));
    }

    private Rect computeLayout() {
        RectF r = new RectF(this.cropRect.left, this.cropRect.top, this.cropRect.right, this.cropRect.bottom);
        this.matrix.mapRect(r);
        return new Rect(Math.round(r.left), Math.round(r.top), Math.round(r.right), Math.round(r.bottom));
    }

    public void invalidate() {
        this.drawRect = this.computeLayout();
    }

    public boolean hasFocus() {
        return this.isFocused;
    }

    public void setFocus(boolean isFocused) {
        this.isFocused = isFocused;
    }

    public static enum HandleMode {
        Changing,
        Always,
        Never;

    }

    static enum ModifyMode {
        None,
        Move,
        Grow;

    }
}

