/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.widget.Toast;
import com.soundcloud.android.crop.CropImageActivity;
import com.soundcloud.android.crop.HighlightView;
import com.soundcloud.android.crop.R;
import java.io.Serializable;

public class Crop {
    public static final int REQUEST_CROP = 6709;
    public static final int REQUEST_PICK = 9162;
    public static final int RESULT_ERROR = 404;
    private Intent cropIntent = new Intent();

    public static Crop of(Uri source, Uri destination) {
        return new Crop(source, destination);
    }

    private Crop(Uri source, Uri destination) {
        this.cropIntent.setData(source);
        this.cropIntent.putExtra("output", (Parcelable)destination);
    }

    public Crop withAspect(int x, int y) {
        this.cropIntent.putExtra("aspect_x", x);
        this.cropIntent.putExtra("aspect_y", y);
        return this;
    }

    public Crop asSquare() {
        this.cropIntent.putExtra("aspect_x", 1);
        this.cropIntent.putExtra("aspect_y", 1);
        return this;
    }

    public Crop withMaxSize(int width, int height) {
        this.cropIntent.putExtra("max_x", width);
        this.cropIntent.putExtra("max_y", height);
        return this;
    }

    public Crop asPng(boolean asPng) {
        this.cropIntent.putExtra("as_png", asPng);
        return this;
    }

    public Crop showThird(boolean show) {
        this.cropIntent.putExtra("show_third", show);
        return this;
    }

    public Crop showCircle(boolean show) {
        this.cropIntent.putExtra("show_circle", show);
        return this;
    }

    public Crop highlightHandleMode(HighlightView.HandleMode handleMode) {
        this.cropIntent.putExtra("highlight_handle_mode", (Serializable)((Object)handleMode));
        return this;
    }

    public Crop highlightHandleColor(int color) {
        this.cropIntent.putExtra("highlight_color", color);
        return this;
    }

    public void start(Activity activity) {
        this.start(activity, 6709);
    }

    public void start(Activity activity, int requestCode) {
        activity.startActivityForResult(this.getIntent((Context)activity), requestCode);
    }

    public void start(Context context, Fragment fragment) {
        this.start(context, fragment, 6709);
    }

    public void start(Context context, android.support.v4.app.Fragment fragment) {
        this.start(context, fragment, 6709);
    }

    @TargetApi(value=11)
    public void start(Context context, Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public void start(Context context, android.support.v4.app.Fragment fragment, int requestCode) {
        fragment.startActivityForResult(this.getIntent(context), requestCode);
    }

    public Intent getIntent(Context context) {
        this.cropIntent.setClass(context, CropImageActivity.class);
        return this.cropIntent;
    }

    public static Uri getOutput(Intent result) {
        return (Uri)result.getParcelableExtra("output");
    }

    public static Throwable getError(Intent result) {
        return (Throwable)result.getSerializableExtra("error");
    }

    public static void pickImage(Activity activity) {
        Crop.pickImage(activity, 9162);
    }

    public static void pickImage(Context context, Fragment fragment) {
        Crop.pickImage(context, fragment, 9162);
    }

    public static void pickImage(Context context, android.support.v4.app.Fragment fragment) {
        Crop.pickImage(context, fragment, 9162);
    }

    public static void pickImage(Activity activity, int requestCode) {
        try {
            activity.startActivityForResult(Crop.getImagePicker(), requestCode);
        }
        catch (ActivityNotFoundException e) {
            Crop.showImagePickerError((Context)activity);
        }
    }

    @TargetApi(value=11)
    public static void pickImage(Context context, Fragment fragment, int requestCode) {
        try {
            fragment.startActivityForResult(Crop.getImagePicker(), requestCode);
        }
        catch (ActivityNotFoundException e) {
            Crop.showImagePickerError(context);
        }
    }

    public static void pickImage(Context context, android.support.v4.app.Fragment fragment, int requestCode) {
        try {
            fragment.startActivityForResult(Crop.getImagePicker(), requestCode);
        }
        catch (ActivityNotFoundException e) {
            Crop.showImagePickerError(context);
        }
    }

    private static Intent getImagePicker() {
        return new Intent("android.intent.action.GET_CONTENT").setType("image/*");
    }

    private static void showImagePickerError(Context context) {
        Toast.makeText((Context)context.getApplicationContext(), (int)R.string.crop__pick_error, (int)0).show();
    }

    static interface Extra {
        public static final String ASPECT_X = "aspect_x";
        public static final String ASPECT_Y = "aspect_y";
        public static final String MAX_X = "max_x";
        public static final String MAX_Y = "max_y";
        public static final String AS_PNG = "as_png";
        public static final String ERROR = "error";
        public static final String SHOW_CIRCLE = "show_circle";
        public static final String HIGHLIGHT_COLOR = "highlight_color";
        public static final String HIGHLIGHT_HANLE_MODE = "highlight_handle_mode";
        public static final String SHOW_THIRD = "show_third";
    }
}

