/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.android.crop;

import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import com.soundcloud.android.crop.MonitoredActivity;
import com.soundcloud.android.crop.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

class CropUtil {
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_CONTENT = "content";

    CropUtil() {
    }

    public static void closeSilently(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getExifRotation(File imageFile) {
        if (imageFile == null) {
            return 0;
        }
        try {
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            switch (exif.getAttributeInt("Orientation", 0)) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (IOException e) {
            Log.e("Error getting Exif data", e);
            return 0;
        }
    }

    public static boolean copyExifRotation(File sourceFile, File destFile) {
        if (sourceFile == null || destFile == null) {
            return false;
        }
        try {
            ExifInterface exifSource = new ExifInterface(sourceFile.getAbsolutePath());
            ExifInterface exifDest = new ExifInterface(destFile.getAbsolutePath());
            exifDest.setAttribute("Orientation", exifSource.getAttribute("Orientation"));
            exifDest.saveAttributes();
            return true;
        }
        catch (IOException e) {
            Log.e("Error copying Exif data", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFromMediaUri(ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_FILE.equals(uri.getScheme())) {
            return new File(uri.getPath());
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            String[] filePathColumn = new String[]{"_data", "_display_name"};
            Cursor cursor = null;
            try {
                cursor = resolver.query(uri, filePathColumn, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    String filePath;
                    int columnIndex;
                    int n = columnIndex = uri.toString().startsWith("content://com.google.android.gallery3d") ? cursor.getColumnIndex("_display_name") : cursor.getColumnIndex("_data");
                    if (columnIndex != -1 && !TextUtils.isEmpty((CharSequence)(filePath = cursor.getString(columnIndex)))) {
                        File file = new File(filePath);
                        return file;
                    }
                }
            }
            catch (SecurityException ignored) {
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return null;
    }

    public static void startBackgroundJob(MonitoredActivity activity, String title, String message, Runnable job, Handler handler) {
        ProgressDialog dialog = ProgressDialog.show((Context)activity, (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)false);
        new Thread(new BackgroundJob(activity, job, dialog, handler)).start();
    }

    private static class BackgroundJob
    extends MonitoredActivity.LifeCycleAdapter
    implements Runnable {
        private final MonitoredActivity mActivity;
        private final ProgressDialog mDialog;
        private final Runnable mJob;
        private final Handler mHandler;
        private final Runnable mCleanupRunner = new Runnable(){

            @Override
            public void run() {
                BackgroundJob.this.mActivity.removeLifeCycleListener(BackgroundJob.this);
                if (BackgroundJob.this.mDialog.getWindow() != null) {
                    BackgroundJob.this.mDialog.dismiss();
                }
            }
        };

        public BackgroundJob(MonitoredActivity activity, Runnable job, ProgressDialog dialog, Handler handler) {
            this.mActivity = activity;
            this.mDialog = dialog;
            this.mJob = job;
            this.mActivity.addLifeCycleListener(this);
            this.mHandler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mJob.run();
            }
            finally {
                this.mHandler.post(this.mCleanupRunner);
            }
        }

        @Override
        public void onActivityDestroyed(MonitoredActivity activity) {
            this.mCleanupRunner.run();
            this.mHandler.removeCallbacks(this.mCleanupRunner);
        }

        @Override
        public void onActivityStopped(MonitoredActivity activity) {
            this.mDialog.hide();
        }

        @Override
        public void onActivityStarted(MonitoredActivity activity) {
            this.mDialog.show();
        }
    }
}

