/*
 * Decompiled with CFR 0.152.
 */
package com.sotwtm.util;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import com.sotwtm.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002J\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sotwtm/util/ECLogcatUtil;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "clearLogcat", "", "createProcessParams", "", "", "logcatPath", "sharedPreferences", "Landroid/content/SharedPreferences;", "deleteOldLog", "", "resetLogcat", "setFilterLogTag", "filterLogTag", "setLogcatDest", "file", "Ljava/io/File;", "setLogcatFileMaxSize", "logcatFileMaxSize", "", "setLogcatFormat", "logFormat", "Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "setMaxLogFile", "maxLogFile", "startLogcat", "clearPreviousLog", "stopLogcat", "Companion", "LogFormat", "ec-log_release"})
public final class ECLogcatUtil {
    private final Application application;
    @NotNull
    public static final String LOG_TAG = "ECLogcatUtil";
    @NotNull
    public static final String SHARED_PREF_FILE_KEY = "LogcatPref";
    @NotNull
    private static final LogFormat DEFAULT_LOGCAT_FORMAT;
    public static final int DEFAULT_LOGCAT_FILE_SIZE = 256;
    public static final int DEFAULT_LOGCAT_MAX_NO_OF_LOG_FILES = 1;
    private static final String COMMAND_PS = "ps";
    private static final String COMMAND_LOGCAT = "logcat";
    private static final String COMMAND_SEPARATOR = "\n\r";
    private static final String PREF_KEY_APP_LINUX_USER_NAME = "AppLinuxUserName";
    private static final String PREF_KEY_LOGCAT_SINCE = "LogcatSince";
    private static final String PREF_KEY_LOGCAT_FILE_MAX_SIZE = "LogcatFileMaxSize";
    private static final String PREF_KEY_LOGCAT_FORMAT = "LogcatFormat";
    private static final String PREF_KEY_LOGCAT_MAX_LOG_FILE = "LogcatMaxLogFile";
    private static final String PREF_KEY_LOGCAT_FILTER_LOG_TAG = "LogcatFilterLogTag";
    private static final String PREF_KEY_LOGCAT_PATH = "LogcatPath";
    @NotNull
    private static final SimpleDateFormat LOGCAT_SINCE_FORMAT;
    private static final String REGEX_COLUMN_SEPARATOR = "(\\s+[A-Z]?\\s+|\\s+)";
    private static final String PS_COL_USER = "USER";
    private static final String PS_COL_PID = "PID";
    private static final String PS_COL_NAME = "NAME";
    private static volatile ECLogcatUtil instance;
    public static final Companion Companion;

    public final synchronized boolean startLogcat() {
        return this.startLogcat(true);
    }

    public final synchronized boolean startLogcat(boolean clearPreviousLog) {
        boolean bl;
        String string = Companion.getAppRunByUser((Context)this.application);
        if (string == null) {
            ECLogcatUtil eCLogcatUtil = this;
            boolean bl2 = false;
            boolean bl3 = false;
            ECLogcatUtil $this$run = eCLogcatUtil;
            boolean bl4 = false;
            Log.w$default(LOG_TAG, "Cannot start logcat due to app user is unknown.", null, 4, null);
            return false;
        }
        String username = string;
        Log.v$default(LOG_TAG, "App running by : " + username, null, 4, null);
        if (Companion.isLogcatRunningBy(username)) {
            Log.v$default(LOG_TAG, "logcat running already", null, 4, null);
            return true;
        }
        SharedPreferences sharedPreferences = ECLogcatUtil.Companion.getSharedPreferences((Context)this.application);
        String string2 = sharedPreferences.getString(PREF_KEY_LOGCAT_PATH, null);
        if (string2 == null) {
            ECLogcatUtil eCLogcatUtil = this;
            boolean $this$run = false;
            boolean bl5 = false;
            ECLogcatUtil $this$run2 = eCLogcatUtil;
            boolean bl6 = false;
            throw (Throwable)new NullPointerException("Logcat path is not set yet!");
        }
        String logcatPath = string2;
        if (clearPreviousLog) {
            this.deleteOldLog(logcatPath);
        }
        List<String> processParams = this.createProcessParams(logcatPath, sharedPreferences);
        ProcessBuilder processBuilder = new ProcessBuilder(processParams);
        processBuilder.redirectErrorStream(true);
        try {
            processBuilder.start();
            Log.v$default(LOG_TAG, "Started logcat", null, 4, null);
            bl = Companion.isLogcatRunningBy(username);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on starting logcat", e);
            bl = false;
        }
        return bl;
    }

    public final boolean stopLogcat() {
        String username = Companion.getAppRunByUser((Context)this.application);
        if (username == null) {
            Log.e$default(LOG_TAG, "Cannot get ps user!", null, 4, null);
            return false;
        }
        String string = Companion.getLogcatPIDRunBy(username);
        if (string == null) {
            return true;
        }
        String pid = string;
        ProcessBuilder processBuilder = new ProcessBuilder("kill", pid);
        List<String> list = processBuilder.command();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"processBuilder.command()");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Log.d$default(Arrays.toString(objectArray), null, 2, null);
        try {
            Process process = processBuilder.start();
            process.waitFor();
            int exitCode = process.exitValue();
            Log.v$default(LOG_TAG, "Stopped logcat exit code : " + exitCode, null, 4, null);
            return true;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on kill logcat", e);
            return false;
        }
    }

    public final boolean resetLogcat() {
        boolean logcatStopped = this.stopLogcat();
        Log.d$default("Logcat stopped : " + logcatStopped, null, 2, null);
        ECLogcatUtil.Companion.getEditor((Context)this.application).remove(PREF_KEY_LOGCAT_SINCE).apply();
        Log.d$default("Reset logcat", null, 2, null);
        return this.startLogcat();
    }

    public final boolean clearLogcat() {
        String logcatSince = LOGCAT_SINCE_FORMAT.format(new Date());
        boolean logcatStopped = this.stopLogcat();
        Log.d$default("Logcat stopped : " + logcatStopped, null, 2, null);
        ECLogcatUtil.Companion.getEditor((Context)this.application).putString(PREF_KEY_LOGCAT_SINCE, logcatSince).apply();
        Log.d$default("Clear logcat since : " + logcatSince, null, 2, null);
        return this.startLogcat();
    }

    public final void setLogcatFileMaxSize(int logcatFileMaxSize) {
        ECLogcatUtil.Companion.getEditor((Context)this.application).putInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, logcatFileMaxSize).apply();
    }

    public final void setLogcatFormat(@NotNull LogFormat logFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)logFormat), (String)"logFormat");
        ECLogcatUtil.Companion.getEditor((Context)this.application).putString(PREF_KEY_LOGCAT_FORMAT, logFormat.toString()).apply();
    }

    public final void setMaxLogFile(int maxLogFile) {
        ECLogcatUtil.Companion.getEditor((Context)this.application).putInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, maxLogFile).apply();
    }

    /*
     * Unable to fully structure code
     */
    public final void setFilterLogTag(@Nullable String filterLogTag) {
        editor = com.sotwtm.util.ECLogcatUtil$Companion.access$getEditor(ECLogcatUtil.Companion, (Context)this.application);
        v0 = filterLogTag;
        if (v0 == null) ** GOTO lbl-1000
        var3_3 = v0;
        var4_4 = false;
        if (var3_3.length() == 0) {
            editor.remove("LogcatFilterLogTag");
        } else lbl-1000:
        // 2 sources

        {
            editor.putString("LogcatFilterLogTag", filterLogTag);
        }
        editor.apply();
    }

    public final void setLogcatDest(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ECLogcatUtil.Companion.getEditor((Context)this.application).putString(PREF_KEY_LOGCAT_PATH, file.getAbsolutePath()).apply();
    }

    private final List<String> createProcessParams(String logcatPath, SharedPreferences sharedPreferences) {
        List list;
        String filterTag;
        StringBuilder commandBuilder = new StringBuilder(COMMAND_LOGCAT);
        commandBuilder.append(COMMAND_SEPARATOR).append("-f").append(COMMAND_SEPARATOR).append(logcatPath).append(COMMAND_SEPARATOR).append("-r").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, 256)).append(COMMAND_SEPARATOR).append("-n").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, 1)).append(COMMAND_SEPARATOR).append("-v").append(COMMAND_SEPARATOR).append(sharedPreferences.getString(PREF_KEY_LOGCAT_FORMAT, DEFAULT_LOGCAT_FORMAT.toString()));
        String logcatSince = sharedPreferences.getString(PREF_KEY_LOGCAT_SINCE, null);
        if (logcatSince != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("-T").append(COMMAND_SEPARATOR).append("0");
        }
        if ((filterTag = sharedPreferences.getString(PREF_KEY_LOGCAT_FILTER_LOG_TAG, null)) != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("*:S").append(COMMAND_SEPARATOR).append(filterTag);
        }
        String string = commandBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandBuilder.toString()");
        CharSequence charSequence = string;
        String string2 = COMMAND_SEPARATOR;
        int n = 0;
        string2 = new Regex(string2);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string2.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.toList((Iterable)list);
    }

    private final void deleteOldLog(String logcatPath) {
        boolean deletedOldLog;
        File oldLog = new File(logcatPath);
        boolean bl = deletedOldLog = !oldLog.isFile() || oldLog.delete();
        if (deletedOldLog) {
            Log.d$default(LOG_TAG, "Deleted old log.", null, 4, null);
        } else {
            Log.e$default(LOG_TAG, "Error on delete old log.", null, 4, null);
        }
    }

    private ECLogcatUtil(Application application) {
        this.application = application;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_LOGCAT_FORMAT = LogFormat.Time;
        LOGCAT_SINCE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    }

    public /* synthetic */ ECLogcatUtil(Application application, DefaultConstructorMarker $constructor_marker) {
        this(application);
    }

    @NotNull
    public static final LogFormat getDEFAULT_LOGCAT_FORMAT() {
        Companion companion = Companion;
        return DEFAULT_LOGCAT_FORMAT;
    }

    @NotNull
    public static final SimpleDateFormat getLOGCAT_SINCE_FORMAT$ec_log_release() {
        Companion companion = Companion;
        return LOGCAT_SINCE_FORMAT;
    }

    @JvmStatic
    @NotNull
    public static final synchronized ECLogcatUtil getInstance(@NotNull Application application) {
        return Companion.getInstance(application);
    }

    @JvmStatic
    @Nullable
    public static final String getAppRunByUser(@NotNull Context context) {
        return Companion.getAppRunByUser(context);
    }

    @JvmStatic
    @Nullable
    public static final String getLogcatPIDRunBy(@NotNull String user) {
        return Companion.getLogcatPIDRunBy(user);
    }

    @JvmStatic
    public static final boolean isLogcatRunningBy(@NotNull String user) {
        return Companion.isLogcatRunningBy(user);
    }

    @JvmStatic
    private static final SharedPreferences.Editor getEditor(Context context) {
        return ECLogcatUtil.Companion.getEditor(context);
    }

    @JvmStatic
    private static final SharedPreferences getSharedPreferences(Context context) {
        return ECLogcatUtil.Companion.getSharedPreferences(context);
    }

    @JvmStatic
    private static final String findAppRunByUser(Context context) {
        return ECLogcatUtil.Companion.findAppRunByUser(context);
    }

    @JvmStatic
    private static final Process runPSCommand() {
        return ECLogcatUtil.Companion.runPSCommand();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "", "(Ljava/lang/String;I)V", "toString", "", "Brief", "Process", "Tag", "Thread", "Raw", "Time", "ThreadTime", "Long", "ec-log_release"})
    public static final class LogFormat
    extends Enum<LogFormat> {
        public static final /* enum */ LogFormat Brief;
        public static final /* enum */ LogFormat Process;
        public static final /* enum */ LogFormat Tag;
        public static final /* enum */ LogFormat Thread;
        public static final /* enum */ LogFormat Raw;
        public static final /* enum */ LogFormat Time;
        public static final /* enum */ LogFormat ThreadTime;
        public static final /* enum */ LogFormat Long;
        private static final /* synthetic */ LogFormat[] $VALUES;

        static {
            LogFormat[] logFormatArray = new LogFormat[8];
            LogFormat[] logFormatArray2 = logFormatArray;
            logFormatArray[0] = Brief = new LogFormat();
            logFormatArray[1] = Process = new LogFormat();
            logFormatArray[2] = Tag = new LogFormat();
            logFormatArray[3] = Thread = new LogFormat();
            logFormatArray[4] = Raw = new LogFormat();
            logFormatArray[5] = Time = new LogFormat();
            logFormatArray[6] = ThreadTime = new LogFormat();
            logFormatArray[7] = Long = new LogFormat();
            $VALUES = logFormatArray;
        }

        @NotNull
        public String toString() {
            String string = this.name();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return string3;
        }

        public static LogFormat[] values() {
            return (LogFormat[])$VALUES.clone();
        }

        public static LogFormat valueOf(String string) {
            return Enum.valueOf(LogFormat.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0003J\u0012\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0003J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0007J\u0012\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010.\u001a\u00020\u0004H\u0007J\u0010\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&H\u0003J\u0010\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020\u0004H\u0007J\n\u00103\u001a\u0004\u0018\u000104H\u0003J\u001c\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0018\u000106*\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b#\u0010\u0002\u00a8\u00067"}, d2={"Lcom/sotwtm/util/ECLogcatUtil$Companion;", "", "()V", "COMMAND_LOGCAT", "", "COMMAND_PS", "COMMAND_SEPARATOR", "DEFAULT_LOGCAT_FILE_SIZE", "", "DEFAULT_LOGCAT_FORMAT", "Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "DEFAULT_LOGCAT_FORMAT$annotations", "getDEFAULT_LOGCAT_FORMAT", "()Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "DEFAULT_LOGCAT_MAX_NO_OF_LOG_FILES", "LOGCAT_SINCE_FORMAT", "Ljava/text/SimpleDateFormat;", "LOGCAT_SINCE_FORMAT$annotations", "getLOGCAT_SINCE_FORMAT$ec_log_release", "()Ljava/text/SimpleDateFormat;", "LOG_TAG", "PREF_KEY_APP_LINUX_USER_NAME", "PREF_KEY_LOGCAT_FILE_MAX_SIZE", "PREF_KEY_LOGCAT_FILTER_LOG_TAG", "PREF_KEY_LOGCAT_FORMAT", "PREF_KEY_LOGCAT_MAX_LOG_FILE", "PREF_KEY_LOGCAT_PATH", "PREF_KEY_LOGCAT_SINCE", "PS_COL_NAME", "PS_COL_PID", "PS_COL_USER", "REGEX_COLUMN_SEPARATOR", "SHARED_PREF_FILE_KEY", "instance", "Lcom/sotwtm/util/ECLogcatUtil;", "instance$annotations", "findAppRunByUser", "context", "Landroid/content/Context;", "getAppRunByUser", "getEditor", "Landroid/content/SharedPreferences$Editor;", "getInstance", "application", "Landroid/app/Application;", "getLogcatPIDRunBy", "user", "getSharedPreferences", "Landroid/content/SharedPreferences;", "isLogcatRunningBy", "", "runPSCommand", "Ljava/lang/Process;", "toColumnIndexMap", "", "ec-log_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void DEFAULT_LOGCAT_FORMAT$annotations() {
        }

        @NotNull
        public final LogFormat getDEFAULT_LOGCAT_FORMAT() {
            return DEFAULT_LOGCAT_FORMAT;
        }

        @JvmStatic
        public static /* synthetic */ void LOGCAT_SINCE_FORMAT$annotations() {
        }

        @NotNull
        public final SimpleDateFormat getLOGCAT_SINCE_FORMAT$ec_log_release() {
            return LOGCAT_SINCE_FORMAT;
        }

        @JvmStatic
        private static /* synthetic */ void instance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final synchronized ECLogcatUtil getInstance(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            ECLogcatUtil eCLogcatUtil = instance;
            if (eCLogcatUtil == null) {
                ECLogcatUtil eCLogcatUtil2 = new ECLogcatUtil(application, null);
                boolean bl = false;
                boolean bl2 = false;
                ECLogcatUtil $this$apply = eCLogcatUtil2;
                boolean bl3 = false;
                instance = $this$apply;
                eCLogcatUtil = eCLogcatUtil2;
            }
            return eCLogcatUtil;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final String getAppRunByUser(@NotNull Context context) {
            block4: {
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    v0 = this.getSharedPreferences(context).getString("AppLinuxUserName", null);
                    if (v0 == null) break block3;
                    var2_2 = v0;
                    var3_3 = false;
                    var4_4 = false;
                    it = var2_2;
                    $i$a$-takeIf-ECLogcatUtil$Companion$getAppRunByUser$1 = false;
                    var7_7 = it;
                    var8_8 = false;
                    v0 = var7_7.length() == 0 == false != false ? var2_2 : null;
                    if (v0 != null) break block4;
                }
                if ((v1 = this.findAppRunByUser(context)) == null) ** GOTO lbl-1000
                var2_2 = v1;
                var3_3 = false;
                var4_4 = false;
                it = var2_2;
                $i$a$-takeIf-ECLogcatUtil$Companion$getAppRunByUser$2 = false;
                var7_7 = it;
                var8_8 = false;
                v1 = var7_7.length() == 0 == false != false ? var2_2 : null;
                if (v1 != null) {
                    var2_2 = v1;
                    var3_3 = false;
                    var4_4 = false;
                    $this$apply = var2_2;
                    $i$a$-apply-ECLogcatUtil$Companion$getAppRunByUser$3 = false;
                    ECLogcatUtil.Companion.getEditor(context).putString("AppLinuxUserName", (String)$this$apply).apply();
                    v0 = var2_2;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = v2 = null;
                }
            }
            if (v0 == null) {
                var2_2 = this;
                var3_3 = false;
                var4_4 = false;
                $this$run = (Companion)var2_2;
                $i$a$-run-ECLogcatUtil$Companion$getAppRunByUser$4 = false;
                Log.e$default("ECLogcatUtil", "Cannot find the owner of current app...", null, 4, null);
                v2 = null;
            }
            return v2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final String getLogcatPIDRunBy(@NotNull String user) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            Process process = this.runPSCommand();
            if (process == null) {
                return null;
            }
            Process ps = process;
            InputStream inputStream = ps.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream));
            try {
                Integer nameColumn;
                Map<String, Integer> columnIndexMap;
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` look for logcat output start======", null, 4, null);
                String line = bf.readLine();
                Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                String string = line;
                Map<String, Integer> map = columnIndexMap = string != null ? this.toColumnIndexMap(string) : null;
                Integer userColumn = map != null ? map.get(ECLogcatUtil.PS_COL_USER) : null;
                Map<String, Integer> map2 = columnIndexMap;
                Integer pidColumn = map2 != null ? map2.get(ECLogcatUtil.PS_COL_PID) : null;
                Map<String, Integer> map3 = columnIndexMap;
                Integer n = nameColumn = map3 != null ? map3.get(ECLogcatUtil.PS_COL_NAME) : null;
                if (userColumn == null || pidColumn == null || nameColumn == null) {
                    Log.e$default(ECLogcatUtil.LOG_TAG, "Some column cannot be found from output.", null, 4, null);
                    String string2 = null;
                    return string2;
                }
                while (bf.readLine() != null) {
                    List columns;
                    List list;
                    Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                    CharSequence e = line;
                    String string3 = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                    int n2 = 0;
                    string3 = new Regex(string3);
                    n2 = 0;
                    boolean bl = false;
                    List $this$dropLastWhile$iv = string3.split(e, n2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            CharSequence charSequence = it;
                            boolean bl3 = false;
                            if (charSequence.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = columns = CollectionsKt.emptyList();
                    }
                    if (!StringsKt.contains((CharSequence)((CharSequence)columns.get(nameColumn)), (CharSequence)ECLogcatUtil.COMMAND_LOGCAT, (boolean)true) || !Intrinsics.areEqual((Object)user, (Object)((String)columns.get(userColumn)))) continue;
                    Object object = columns.get(pidColumn);
                    $i$f$dropLastWhile = false;
                    boolean bl4 = false;
                    String $this$apply = (String)object;
                    boolean bl5 = false;
                    Log.v$default(ECLogcatUtil.LOG_TAG, "Logcat is running by user [" + user + "] pid : " + $this$apply, null, 4, null);
                    object = (String)object;
                    return object;
                }
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` look for logcat output end======", null, 4, null);
            }
            catch (IOException e) {
                Log.e(ECLogcatUtil.LOG_TAG, "Error on reading output from 'ps'", e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
                try {
                    ps.waitFor();
                    ps.exitValue();
                }
                catch (Exception e) {
                    Log.e(ECLogcatUtil.LOG_TAG, "Error on destroy ps", e);
                }
            }
            return null;
        }

        @JvmStatic
        public final boolean isLogcatRunningBy(@NotNull String user) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            return this.getLogcatPIDRunBy(user) != null;
        }

        @JvmStatic
        private final SharedPreferences.Editor getEditor(Context context) {
            SharedPreferences sharedPref = context.getSharedPreferences(ECLogcatUtil.SHARED_PREF_FILE_KEY, 0);
            SharedPreferences.Editor editor = sharedPref.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"sharedPref.edit()");
            return editor;
        }

        @JvmStatic
        private final SharedPreferences getSharedPreferences(Context context) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(ECLogcatUtil.SHARED_PREF_FILE_KEY, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EY, Context.MODE_PRIVATE)");
            return sharedPreferences;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        private final String findAppRunByUser(Context context) {
            String packageName = context.getPackageName();
            Log.d$default(ECLogcatUtil.LOG_TAG, "Retrieving application username. ApplicationPackage = " + packageName, null, 4, null);
            Process process = this.runPSCommand();
            if (process == null) {
                return null;
            }
            Process ps = process;
            InputStream inputStream = ps.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream));
            try {
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` output start======", null, 4, null);
                String line = bf.readLine();
                Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                Map<String, Integer> columnIndexMap = this.toColumnIndexMap(line);
                Map<String, Integer> map = columnIndexMap;
                if (map == null || (map = map.get(ECLogcatUtil.PS_COL_USER)) == null) {
                    Object object = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    Companion $this$run = object;
                    boolean bl3 = false;
                    Log.e$default(ECLogcatUtil.LOG_TAG, "USER cannot be found from output.", null, 4, null);
                    object = null;
                    return object;
                }
                int userColumn = (Integer)((Object)map);
                Integer n = columnIndexMap.get(ECLogcatUtil.PS_COL_NAME);
                if (n == null) {
                    Object e = this;
                    boolean bl = false;
                    boolean $this$run = false;
                    Companion $this$run2 = e;
                    boolean bl4 = false;
                    Log.e$default(ECLogcatUtil.LOG_TAG, "NAME cannot be found from output.", null, 4, null);
                    e = null;
                    return e;
                }
                int nameColumn = n;
                while (bf.readLine() != null) {
                    String string;
                    String string2;
                    List columns;
                    List list;
                    Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                    CharSequence e = line;
                    String $this$run = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                    int $this$run2 = 0;
                    $this$run = new Regex($this$run);
                    $this$run2 = 0;
                    boolean bl4 = false;
                    List $this$dropLastWhile$iv = $this$run.split(e, $this$run2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            CharSequence charSequence = it;
                            boolean bl5 = false;
                            if (charSequence.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = columns = CollectionsKt.emptyList();
                    }
                    if (!Intrinsics.areEqual((Object)packageName, (Object)((String)CollectionsKt.getOrNull((List)columns, (int)nameColumn)))) continue;
                    String string3 = (String)CollectionsKt.getOrNull((List)columns, (int)userColumn);
                    if (string3 != null) {
                        string2 = string3;
                        $i$f$dropLastWhile = false;
                        boolean bl = false;
                        String $this$apply = string2;
                        boolean bl6 = false;
                        Log.i$default(ECLogcatUtil.LOG_TAG, "Application executed by user : " + $this$apply, null, 4, null);
                        string = string2;
                    } else {
                        string = null;
                    }
                    string2 = string;
                    return string2;
                }
            }
            catch (IOException e) {
                Log.e(ECLogcatUtil.LOG_TAG, "Error on reading output from 'ps'", e);
            }
            finally {
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` output end======", null, 4, null);
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
                try {
                    ps.waitFor();
                    ps.exitValue();
                }
                catch (Exception e) {
                    Log.e(ECLogcatUtil.LOG_TAG, "Error on destroy ps", e);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Map<String, Integer> toColumnIndexMap(@Nullable String $this$toColumnIndexMap) {
            List list;
            int i = 0;
            String string = $this$toColumnIndexMap;
            Object object = string;
            if (string == null) return null;
            CharSequence charSequence = (CharSequence)object;
            String string2 = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List list2 = string2.split(charSequence, n);
            object = list2;
            if (list2 == null) return null;
            Object $this$dropLastWhile$iv = object;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            object = list;
            if (list == null) return null;
            Iterable $this$associateWith$iv = (Iterable)object;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string3 = (String)element$iv$iv;
                Object e = element$iv$iv;
                Map map = result$iv;
                boolean bl4 = false;
                int n2 = i;
                i = n2 + 1;
                Integer n3 = n2;
                map.put(e, n3);
            }
            Map map = result$iv;
            return map;
        }

        @JvmStatic
        private final Process runPSCommand() {
            Process process;
            try {
                process = new ProcessBuilder(ECLogcatUtil.COMMAND_PS).start();
            }
            catch (IOException e) {
                Log.e(ECLogcatUtil.LOG_TAG, "Not able to run command on this device!", e);
                process = null;
            }
            return process;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

