/*
 * Decompiled with CFR 0.152.
 */
package com.sotwtm.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.sotwtm.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sotwtm/util/ECLogcatUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mContextRef", "Ljava/lang/ref/WeakReference;", "clearLogcat", "", "resetLogcat", "setFilterLogTag", "", "filterLogTag", "", "setLogcatDest", "file", "Ljava/io/File;", "setLogcatFileMaxSize", "logcatFileMaxSize", "", "setLogcatFormat", "logFormat", "Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "setMaxLogFile", "maxLogFile", "startLogcat", "clearPreviousLog", "stopLogcat", "Companion", "LogFormat", "ec-log_release"})
public final class ECLogcatUtil {
    private final WeakReference<Context> mContextRef;
    @NotNull
    public static final String LOG_TAG = "ECLogcatUtil";
    @NotNull
    public static final String SHARED_PREF_FILE_KEY = "LogcatPref";
    @NotNull
    private static final LogFormat DEFAULT_LOGCAT_FORMAT;
    public static final int DEFAULT_LOGCAT_FILE_SIZE = 256;
    public static final int DEFAULT_LOGCAT_MAX_NO_OF_LOG_FILES = 1;
    private static final String COMMAND_PS = "ps";
    private static final String COMMAND_LOGCAT = "logcat";
    private static final String COMMAND_SEPARATOR = "\n\r";
    private static final String PREF_KEY_APP_LINUX_USER_NAME = "AppLinuxUserName";
    private static final String PREF_KEY_LOGCAT_SINCE = "LogcatSince";
    private static final String PREF_KEY_LOGCAT_FILE_MAX_SIZE = "LogcatFileMaxSize";
    private static final String PREF_KEY_LOGCAT_FORMAT = "LogcatFormat";
    private static final String PREF_KEY_LOGCAT_MAX_LOG_FILE = "LogcatMaxLogFile";
    private static final String PREF_KEY_LOGCAT_FILTER_LOG_TAG = "LogcatFilterLogTag";
    private static final String PREF_KEY_LOGCAT_PATH = "LogcatPath";
    @NotNull
    private static final SimpleDateFormat LOGCAT_SINCE_FORMAT;
    private static final String REGEX_COLUMN_SEPARATOR = "(\\s+[A-Z]?\\s+|\\s+)";
    private static final String PS_COL_USER = "USER";
    private static final String PS_COL_PID = "PID";
    private static final String PS_COL_NAME = "NAME";
    private static volatile ECLogcatUtil instance;
    public static final Companion Companion;

    public final synchronized boolean startLogcat() {
        return this.startLogcat(true);
    }

    public final synchronized boolean startLogcat(boolean clearPreviousLog) {
        List list;
        Collection $receiver$iv;
        String filterTag;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e$default("No Context!", null, 2, null);
            return false;
        }
        String username = Companion.getAppRunByUser(context);
        if (username == null) {
            Log.w$default(LOG_TAG, "Cannot start logcat due to app user is unknown.", null, 4, null);
            return false;
        }
        Log.v$default(LOG_TAG, "App running by : " + username, null, 4, null);
        if (Companion.isLogcatRunningBy(username)) {
            Log.v$default(LOG_TAG, "logcat running already", null, 4, null);
            return true;
        }
        SharedPreferences sharedPreferences = ECLogcatUtil.Companion.getSharedPreferences(context);
        String logcatPath = sharedPreferences.getString(PREF_KEY_LOGCAT_PATH, null);
        if (TextUtils.isEmpty((CharSequence)logcatPath)) {
            throw (Throwable)new NullPointerException("Logcat path is not set yet!");
        }
        if (clearPreviousLog) {
            boolean deletedOldLog;
            File oldLog = new File(logcatPath);
            boolean bl = deletedOldLog = !oldLog.isFile() || oldLog.delete();
            if (deletedOldLog) {
                Log.d$default(LOG_TAG, "Deleted old log.", null, 4, null);
            } else {
                Log.e$default(LOG_TAG, "Error on delete old log.", null, 4, null);
            }
        }
        StringBuilder commandBuilder = new StringBuilder(COMMAND_LOGCAT);
        commandBuilder.append(COMMAND_SEPARATOR).append("-f").append(COMMAND_SEPARATOR).append(logcatPath).append(COMMAND_SEPARATOR).append("-r").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, 256)).append(COMMAND_SEPARATOR).append("-n").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, 1)).append(COMMAND_SEPARATOR).append("-v").append(COMMAND_SEPARATOR).append(sharedPreferences.getString(PREF_KEY_LOGCAT_FORMAT, DEFAULT_LOGCAT_FORMAT.toString()));
        String logcatSince = sharedPreferences.getString(PREF_KEY_LOGCAT_SINCE, null);
        if (logcatSince != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("-T").append(COMMAND_SEPARATOR).append("0");
        }
        if ((filterTag = sharedPreferences.getString(PREF_KEY_LOGCAT_FILTER_LOG_TAG, null)) != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("*:S").append(COMMAND_SEPARATOR).append(filterTag);
        }
        String string = commandBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandBuilder.toString()");
        Object object = string;
        String string2 = COMMAND_SEPARATOR;
        string2 = new Regex(string2);
        int n = 0;
        object = string2.split((CharSequence)object, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $receiver$iv = list;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] processParams = stringArray;
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.copyOf(processParams, processParams.length));
        processBuilder.redirectErrorStream(true);
        try {
            processBuilder.start();
            Log.v$default(LOG_TAG, "Started logcat", null, 4, null);
            return Companion.isLogcatRunningBy(username);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on starting logcat", e);
            return false;
        }
    }

    public final boolean stopLogcat() {
        Collection $receiver$iv;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e$default("No Context!", null, 2, null);
            return false;
        }
        String username = Companion.getAppRunByUser(context);
        if (username == null) {
            Log.e$default(LOG_TAG, "Cannot get ps user!", null, 4, null);
            return false;
        }
        String string = Companion.getLogcatPIDRunningBy(username);
        if (string == null) {
            return true;
        }
        String pid = string;
        ProcessBuilder processBuilder = new ProcessBuilder("kill", pid);
        List<String> list = processBuilder.command();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"processBuilder.command()");
        Collection collection = $receiver$iv = (Collection)list;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Log.d$default(Arrays.toString(objectArray), null, 2, null);
        try {
            Process process = processBuilder.start();
            process.waitFor();
            int exitCode = process.exitValue();
            Log.v$default(LOG_TAG, "Stopped logcat exit code : " + exitCode, null, 4, null);
            return true;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on kill logcat", e);
            return false;
        }
    }

    public final boolean resetLogcat() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e$default("No Context!", null, 2, null);
            return false;
        }
        boolean logcatStopped = this.stopLogcat();
        Log.d$default("Logcat stopped : " + logcatStopped, null, 2, null);
        ECLogcatUtil.Companion.getEditor(context).remove(PREF_KEY_LOGCAT_SINCE).apply();
        Log.d$default("Reset logcat", null, 2, null);
        return this.startLogcat();
    }

    public final boolean clearLogcat() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e$default("No Context!", null, 2, null);
            return false;
        }
        String logcatSince = LOGCAT_SINCE_FORMAT.format(new Date());
        boolean logcatStopped = this.stopLogcat();
        Log.d$default("Logcat stopped : " + logcatStopped, null, 2, null);
        ECLogcatUtil.Companion.getEditor(context).putString(PREF_KEY_LOGCAT_SINCE, logcatSince).apply();
        Log.d$default("Clear logcat since : " + logcatSince, null, 2, null);
        return this.startLogcat();
    }

    public final void setLogcatFileMaxSize(int logcatFileMaxSize) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContextRef.get() ?: return");
        Context context2 = context;
        ECLogcatUtil.Companion.getEditor(context2).putInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, logcatFileMaxSize).apply();
    }

    public final void setLogcatFormat(@NotNull LogFormat logFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)logFormat), (String)"logFormat");
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContextRef.get() ?: return");
        Context context2 = context;
        ECLogcatUtil.Companion.getEditor(context2).putString(PREF_KEY_LOGCAT_FORMAT, logFormat.toString()).apply();
    }

    public final void setMaxLogFile(int maxLogFile) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContextRef.get() ?: return");
        Context context2 = context;
        ECLogcatUtil.Companion.getEditor(context2).putInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, maxLogFile).apply();
    }

    public final void setFilterLogTag(@Nullable String filterLogTag) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContextRef.get() ?: return");
        Context context2 = context;
        SharedPreferences.Editor editor = ECLogcatUtil.Companion.getEditor(context2);
        if (TextUtils.isEmpty((CharSequence)filterLogTag)) {
            editor.remove(PREF_KEY_LOGCAT_FILTER_LOG_TAG);
        } else {
            editor.putString(PREF_KEY_LOGCAT_FILTER_LOG_TAG, filterLogTag);
        }
        editor.apply();
    }

    public final void setLogcatDest(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContextRef.get() ?: return");
        Context context2 = context;
        ECLogcatUtil.Companion.getEditor(context2).putString(PREF_KEY_LOGCAT_PATH, file.getAbsolutePath()).apply();
    }

    private ECLogcatUtil(Context context) {
        this.mContextRef = new WeakReference<Context>(context.getApplicationContext());
    }

    static {
        Companion = new Companion(null);
        DEFAULT_LOGCAT_FORMAT = LogFormat.Time;
        LOGCAT_SINCE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    }

    public /* synthetic */ ECLogcatUtil(@NotNull Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @NotNull
    public static final LogFormat getDEFAULT_LOGCAT_FORMAT() {
        Companion companion = Companion;
        return DEFAULT_LOGCAT_FORMAT;
    }

    @NotNull
    public static final SimpleDateFormat getLOGCAT_SINCE_FORMAT$ec_log_release() {
        Companion companion = Companion;
        return LOGCAT_SINCE_FORMAT;
    }

    @JvmStatic
    @NotNull
    public static final synchronized ECLogcatUtil getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    @JvmStatic
    @Nullable
    public static final String getAppRunByUser(@NotNull Context context) {
        return Companion.getAppRunByUser(context);
    }

    @JvmStatic
    @Nullable
    public static final String getLogcatPIDRunningBy(@NotNull String user) {
        return Companion.getLogcatPIDRunningBy(user);
    }

    @JvmStatic
    public static final boolean isLogcatRunningBy(@NotNull String user) {
        return Companion.isLogcatRunningBy(user);
    }

    @JvmStatic
    private static final SharedPreferences.Editor getEditor(Context context) {
        return ECLogcatUtil.Companion.getEditor(context);
    }

    @JvmStatic
    private static final SharedPreferences getSharedPreferences(Context context) {
        return ECLogcatUtil.Companion.getSharedPreferences(context);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "", "(Ljava/lang/String;I)V", "toString", "", "Brief", "Process", "Tag", "Thread", "Raw", "Time", "ThreadTime", "Long", "ec-log_release"})
    public static final class LogFormat
    extends Enum<LogFormat> {
        public static final /* enum */ LogFormat Brief;
        public static final /* enum */ LogFormat Process;
        public static final /* enum */ LogFormat Tag;
        public static final /* enum */ LogFormat Thread;
        public static final /* enum */ LogFormat Raw;
        public static final /* enum */ LogFormat Time;
        public static final /* enum */ LogFormat ThreadTime;
        public static final /* enum */ LogFormat Long;
        private static final /* synthetic */ LogFormat[] $VALUES;

        static {
            LogFormat[] logFormatArray = new LogFormat[8];
            LogFormat[] logFormatArray2 = logFormatArray;
            logFormatArray[0] = Brief = new LogFormat();
            logFormatArray[1] = Process = new LogFormat();
            logFormatArray[2] = Tag = new LogFormat();
            logFormatArray[3] = Thread = new LogFormat();
            logFormatArray[4] = Raw = new LogFormat();
            logFormatArray[5] = Time = new LogFormat();
            logFormatArray[6] = ThreadTime = new LogFormat();
            logFormatArray[7] = Long = new LogFormat();
            $VALUES = logFormatArray;
        }

        @NotNull
        public String toString() {
            String string;
            String string2 = string = this.name();
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return string3;
        }

        public static LogFormat[] values() {
            return (LogFormat[])$VALUES.clone();
        }

        public static LogFormat valueOf(String string) {
            return Enum.valueOf(LogFormat.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0003J\u0010\u0010)\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0003J\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b#\u0010\u0002\u00a8\u00060"}, d2={"Lcom/sotwtm/util/ECLogcatUtil$Companion;", "", "()V", "COMMAND_LOGCAT", "", "COMMAND_PS", "COMMAND_SEPARATOR", "DEFAULT_LOGCAT_FILE_SIZE", "", "DEFAULT_LOGCAT_FORMAT", "Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "DEFAULT_LOGCAT_FORMAT$annotations", "getDEFAULT_LOGCAT_FORMAT", "()Lcom/sotwtm/util/ECLogcatUtil$LogFormat;", "DEFAULT_LOGCAT_MAX_NO_OF_LOG_FILES", "LOGCAT_SINCE_FORMAT", "Ljava/text/SimpleDateFormat;", "LOGCAT_SINCE_FORMAT$annotations", "getLOGCAT_SINCE_FORMAT$ec_log_release", "()Ljava/text/SimpleDateFormat;", "LOG_TAG", "PREF_KEY_APP_LINUX_USER_NAME", "PREF_KEY_LOGCAT_FILE_MAX_SIZE", "PREF_KEY_LOGCAT_FILTER_LOG_TAG", "PREF_KEY_LOGCAT_FORMAT", "PREF_KEY_LOGCAT_MAX_LOG_FILE", "PREF_KEY_LOGCAT_PATH", "PREF_KEY_LOGCAT_SINCE", "PS_COL_NAME", "PS_COL_PID", "PS_COL_USER", "REGEX_COLUMN_SEPARATOR", "SHARED_PREF_FILE_KEY", "instance", "Lcom/sotwtm/util/ECLogcatUtil;", "instance$annotations", "getAppRunByUser", "context", "Landroid/content/Context;", "getEditor", "Landroid/content/SharedPreferences$Editor;", "getInstance", "getLogcatPIDRunningBy", "user", "getSharedPreferences", "Landroid/content/SharedPreferences;", "isLogcatRunningBy", "", "ec-log_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void DEFAULT_LOGCAT_FORMAT$annotations() {
        }

        @NotNull
        public final LogFormat getDEFAULT_LOGCAT_FORMAT() {
            return DEFAULT_LOGCAT_FORMAT;
        }

        @JvmStatic
        public static /* synthetic */ void LOGCAT_SINCE_FORMAT$annotations() {
        }

        @NotNull
        public final SimpleDateFormat getLOGCAT_SINCE_FORMAT$ec_log_release() {
            return LOGCAT_SINCE_FORMAT;
        }

        @JvmStatic
        private static /* synthetic */ void instance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final synchronized ECLogcatUtil getInstance(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            ECLogcatUtil localInstance = instance;
            Object object = localInstance;
            if ((object != null && (object = ((ECLogcatUtil)object).mContextRef) != null ? (Context)((Reference)object).get() : null) == null) {
                localInstance = new ECLogcatUtil(context, null);
                instance = localInstance;
            }
            return localInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final String getAppRunByUser(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            SharedPreferences sharedPreferences = this.getSharedPreferences(context);
            String myUserName = sharedPreferences.getString(ECLogcatUtil.PREF_KEY_APP_LINUX_USER_NAME, null);
            if (TextUtils.isEmpty((CharSequence)myUserName)) {
                Process ps;
                String packageName = context.getPackageName();
                Log.d$default(ECLogcatUtil.LOG_TAG, "Retrieving application username. ApplicationPackage = " + packageName, null, 4, null);
                ProcessBuilder psBuilder = new ProcessBuilder(ECLogcatUtil.COMMAND_PS);
                try {
                    Process process = psBuilder.start();
                    Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"psBuilder.start()");
                    ps = process;
                }
                catch (IOException e) {
                    Log.e(ECLogcatUtil.LOG_TAG, "Not able to run command on this device!", e);
                    return null;
                }
                InputStream is = ps.getInputStream();
                BufferedReader bf = new BufferedReader(new InputStreamReader(is));
                try {
                    List list;
                    Collection $receiver$iv;
                    Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` output start======", null, 4, null);
                    String line = bf.readLine();
                    if (line == null) {
                        Log.e$default(ECLogcatUtil.LOG_TAG, "'ps' no output?!", null, 4, null);
                        String string = null;
                        return string;
                    }
                    Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                    Object e = line;
                    String string = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                    string = new Regex(string);
                    int n = 0;
                    e = string.split((CharSequence)e, n);
                    if (!$receiver$iv.isEmpty()) {
                        ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            CharSequence charSequence = it;
                            if (charSequence.length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $receiver$iv = list;
                    Collection collection = $receiver$iv;
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] columns = stringArray;
                    int userColumn = -1;
                    int nameColumn = -1;
                    int $i$f$toTypedArray = 0;
                    int n2 = columns.length;
                    while ($i$f$toTypedArray < n2) {
                        void i;
                        if (StringsKt.equals((String)ECLogcatUtil.PS_COL_USER, (String)columns[i], (boolean)true)) {
                            userColumn = i;
                        } else if (StringsKt.equals((String)ECLogcatUtil.PS_COL_NAME, (String)columns[i], (boolean)true)) {
                            nameColumn = i;
                        }
                        ++i;
                    }
                    if (userColumn == -1 || nameColumn == -1) {
                        Log.e$default(ECLogcatUtil.LOG_TAG, "Some column cannot be found from output.", null, 4, null);
                        String i = null;
                        return i;
                    }
                    line = bf.readLine();
                    while (line != null) {
                        Collection thisCollection$iv2;
                        List list2;
                        Collection $receiver$iv2;
                        Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                        Object i = line;
                        String e2 = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                        e2 = new Regex(e2);
                        int $i$a$1$dropLastWhile = 0;
                        i = e2.split((CharSequence)i, $i$a$1$dropLastWhile);
                        if (!$receiver$iv2.isEmpty()) {
                            ListIterator iterator$iv = $receiver$iv2.listIterator($receiver$iv2.size());
                            while (iterator$iv.hasPrevious()) {
                                String it = (String)iterator$iv.previous();
                                CharSequence charSequence = it;
                                if (charSequence.length() == 0) continue;
                                list2 = CollectionsKt.take((Iterable)$receiver$iv2, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        $receiver$iv2 = list2;
                        if ($receiver$iv2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        if (thisCollection$iv2.toArray(new String[0]) == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        if (Intrinsics.areEqual((Object)packageName, (Object)columns[nameColumn])) {
                            myUserName = columns[userColumn];
                            Log.d$default(ECLogcatUtil.LOG_TAG, "Application executed by user : " + myUserName, null, 4, null);
                            break;
                        }
                        line = bf.readLine();
                    }
                    Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` output end======", null, 4, null);
                    if (TextUtils.isEmpty((CharSequence)myUserName)) {
                        Log.e$default(ECLogcatUtil.LOG_TAG, "Cannot find the owner of current app...", null, 4, null);
                    } else {
                        this.getEditor(context).putString(ECLogcatUtil.PREF_KEY_APP_LINUX_USER_NAME, myUserName).apply();
                    }
                }
                catch (IOException e) {
                    Log.e(ECLogcatUtil.LOG_TAG, "Error on reading output from 'ps'", e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                    try {
                        ps.waitFor();
                        ps.exitValue();
                    }
                    catch (Exception e) {
                        Log.e(ECLogcatUtil.LOG_TAG, "Error on destroy ps", e);
                    }
                }
            }
            return myUserName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final String getLogcatPIDRunningBy(@NotNull String user) {
            Process ps;
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            String pid = null;
            ProcessBuilder processBuilder = new ProcessBuilder(ECLogcatUtil.COMMAND_PS);
            try {
                Process process = processBuilder.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"processBuilder.start()");
                ps = process;
            }
            catch (IOException e) {
                Log.e(ECLogcatUtil.LOG_TAG, "Not able to run command on this device!", e);
                return null;
            }
            InputStream is = ps.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(is));
            try {
                List list;
                Collection $receiver$iv;
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` look for logcat output start======", null, 4, null);
                String line = bf.readLine();
                if (line == null) {
                    Log.e$default(ECLogcatUtil.LOG_TAG, "'ps' no output?!", null, 4, null);
                    String string = null;
                    return string;
                }
                Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                Object e = line;
                String string = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                string = new Regex(string);
                int n = 0;
                e = string.split((CharSequence)e, n);
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        CharSequence charSequence = it;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] columns = stringArray;
                int userColumn = -1;
                int pidColumn = -1;
                int nameColumn = -1;
                int n2 = 0;
                int $i$a$1$dropLastWhile = columns.length;
                while (n2 < $i$a$1$dropLastWhile) {
                    void i;
                    if (StringsKt.equals((String)ECLogcatUtil.PS_COL_USER, (String)columns[i], (boolean)true)) {
                        userColumn = i;
                    } else if (StringsKt.equals((String)ECLogcatUtil.PS_COL_PID, (String)columns[i], (boolean)true)) {
                        pidColumn = i;
                    } else if (StringsKt.equals((String)ECLogcatUtil.PS_COL_NAME, (String)columns[i], (boolean)true)) {
                        nameColumn = i;
                    }
                    ++i;
                }
                if (userColumn == -1 || pidColumn == -1 || nameColumn == -1) {
                    Log.e$default(ECLogcatUtil.LOG_TAG, "Some column cannot be found from output.", null, 4, null);
                    String i = null;
                    return i;
                }
                line = bf.readLine();
                while (line != null) {
                    String string2;
                    Collection thisCollection$iv2;
                    List list2;
                    Collection $receiver$iv2;
                    Log.d$default(ECLogcatUtil.LOG_TAG, line, null, 4, null);
                    Object i = line;
                    String e2 = ECLogcatUtil.REGEX_COLUMN_SEPARATOR;
                    e2 = new Regex(e2);
                    int $i$f$dropLastWhile = 0;
                    i = e2.split((CharSequence)i, $i$f$dropLastWhile);
                    if (!$receiver$iv2.isEmpty()) {
                        ListIterator iterator$iv = $receiver$iv2.listIterator($receiver$iv2.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            CharSequence charSequence = it;
                            if (charSequence.length() == 0) continue;
                            list2 = CollectionsKt.take((Iterable)$receiver$iv2, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    $receiver$iv2 = list2;
                    if ($receiver$iv2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    if (thisCollection$iv2.toArray(new String[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String string3 = string2 = columns[nameColumn];
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    if (StringsKt.contains$default((CharSequence)string4, (CharSequence)ECLogcatUtil.COMMAND_LOGCAT, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)user, (Object)columns[userColumn])) {
                        pid = columns[pidColumn];
                        Log.v$default(ECLogcatUtil.LOG_TAG, "Logcat is running by user [" + user + "] pid : " + pid, null, 4, null);
                    }
                    line = bf.readLine();
                }
                Log.d$default(ECLogcatUtil.LOG_TAG, "======`ps` look for logcat output end======", null, 4, null);
            }
            catch (IOException e) {
                Log.e(ECLogcatUtil.LOG_TAG, "Error on reading output from 'ps'", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                try {
                    ps.waitFor();
                    ps.exitValue();
                }
                catch (Exception e) {
                    Log.e(ECLogcatUtil.LOG_TAG, "Error on destroy ps", e);
                }
            }
            return pid;
        }

        @JvmStatic
        public final boolean isLogcatRunningBy(@NotNull String user) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            return this.getLogcatPIDRunningBy(user) != null;
        }

        @JvmStatic
        private final SharedPreferences.Editor getEditor(Context context) {
            SharedPreferences sharedPref = context.getSharedPreferences(ECLogcatUtil.SHARED_PREF_FILE_KEY, 0);
            SharedPreferences.Editor editor = sharedPref.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"sharedPref.edit()");
            return editor;
        }

        @JvmStatic
        private final SharedPreferences getSharedPreferences(Context context) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(ECLogcatUtil.SHARED_PREF_FILE_KEY, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EY, Context.MODE_PRIVATE)");
            return sharedPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

