/*
 * Decompiled with CFR 0.152.
 */
package com.sotwtm.util;

import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final int NONE = 100;
    static final int UNKNOWN = -1;
    private static final int LOG_MAX_CHAR_CHUNK = 2048;
    private static final Logger LOGGER_V = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.v((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.v((String)tag, (String)msg, (Throwable)tr);
        }
    };
    private static final Logger LOGGER_D = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.d((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.d((String)tag, (String)msg, (Throwable)tr);
        }
    };
    private static final Logger LOGGER_I = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.i((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.i((String)tag, (String)msg, (Throwable)tr);
        }
    };
    private static final Logger LOGGER_W = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.w((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.w((String)tag, (String)msg, (Throwable)tr);
        }
    };
    private static final Logger LOGGER_E = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.e((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
        }
    };
    private static final Logger LOGGER_WTF = new Logger(){

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg) {
            return android.util.Log.wtf((String)tag, (String)msg);
        }

        @Override
        public int printLog(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
            return android.util.Log.wtf((String)tag, (String)msg, (Throwable)tr);
        }
    };
    static int _logLevel = -1;
    @NonNull
    static String _DefaultTag = "Log";
    @Nullable
    static OnWtfListener _ActionOnWtf = null;
    @Nullable
    static OnWtfListener _ActionOnWtfDebug = null;

    public static void setDefaultLogTag(@NonNull String logTag) {
        _DefaultTag = logTag;
    }

    public static void setActionOnWtf(@Nullable OnWtfListener action) {
        _ActionOnWtf = action;
    }

    public static void setActionOnWtfDebug(@Nullable OnWtfListener action) {
        _ActionOnWtfDebug = action;
    }

    public static void setLogLevel(int lLevel) {
        switch (lLevel) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 100: {
                _logLevel = lLevel;
                break;
            }
            case -1: {
                _logLevel = Log.getLogLevel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log level passed to setLogLevel: " + lLevel);
            }
        }
    }

    private Log() {
    }

    public static int getLogLevel() {
        if (_logLevel == -1) {
            return 100;
        }
        return _logLevel;
    }

    public static boolean isLoggable(int level) {
        return level != 100 && android.util.Log.isLoggable((String)_DefaultTag, (int)level);
    }

    private static void getCustomPrefix(StringBuilder logBuilder) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        logBuilder.append("<");
        logBuilder.append(Process.myTid());
        logBuilder.append(">[(");
        if (null != ste && ste.length >= 4) {
            StackTraceElement stackTraceClass = ste[3];
            String className = stackTraceClass.getClassName();
            int subClassIndex = className.indexOf(36);
            String subClass = subClassIndex >= 0 ? className.substring(subClassIndex) : null;
            String javaName = stackTraceClass.getFileName();
            String method = stackTraceClass.getMethodName();
            int line = stackTraceClass.getLineNumber();
            logBuilder.append(javaName).append(":").append(line).append(")");
            if (subClass != null) {
                logBuilder.append(subClass);
            }
            logBuilder.append("#").append(method);
        }
        logBuilder.append("] ");
    }

    @NonNull
    private static String getOutputLog(@Nullable String msg) {
        StringBuilder sb = new StringBuilder();
        Log.getCustomPrefix(sb);
        sb.append(msg);
        return sb.toString();
    }

    public static String getStackTraceString(@Nullable Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    public static int v(@Nullable String msg) {
        return Log.v(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int v(@Nullable String tag, @Nullable String msg) {
        if (msg == null) {
            return 0;
        }
        if (Log.getLogLevel() > 2) {
            return 0;
        }
        return Log.printLog(LOGGER_V, tag, msg);
    }

    public static int v(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 2) {
            return 0;
        }
        return Log.printLog(LOGGER_V, tag, msg, tr);
    }

    public static int d(@Nullable String msg) {
        return Log.d(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int d(@Nullable String tag, @Nullable String msg) {
        if (msg == null) {
            return 0;
        }
        if (Log.getLogLevel() > 3) {
            return 0;
        }
        return Log.printLog(LOGGER_D, tag, msg);
    }

    public static int d(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 3) {
            return 0;
        }
        return Log.printLog(LOGGER_D, tag, msg, tr);
    }

    public static int i(@Nullable String msg) {
        return Log.i(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int i(@Nullable String tag, @Nullable String msg) {
        if (msg == null) {
            return 0;
        }
        if (Log.getLogLevel() > 4) {
            return 0;
        }
        return Log.printLog(LOGGER_I, tag, msg);
    }

    public static int i(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 4) {
            return 0;
        }
        return Log.printLog(LOGGER_I, tag, msg, tr);
    }

    public static int w(@Nullable String msg) {
        return Log.w(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int w(@Nullable String tag, @Nullable String msg) {
        if (msg == null) {
            return 0;
        }
        if (Log.getLogLevel() > 5) {
            return 0;
        }
        return Log.printLog(LOGGER_W, tag, msg);
    }

    public static int w(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 5) {
            return 0;
        }
        return Log.printLog(LOGGER_W, tag, msg, tr);
    }

    public static int e(@Nullable String msg) {
        return Log.e(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int e(@Nullable String tag, @Nullable String msg) {
        if (msg == null) {
            return 0;
        }
        if (Log.getLogLevel() > 6) {
            return 0;
        }
        return Log.printLog(LOGGER_E, tag, msg);
    }

    public static int e(@Nullable String msg, @Nullable Throwable tr) {
        return Log.e(_DefaultTag, msg, tr);
    }

    public static int e(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 6) {
            return 0;
        }
        return Log.printLog(LOGGER_E, tag, msg, tr);
    }

    public static int wtf(@Nullable String msg) {
        return Log.wtf(_DefaultTag, Log.getOutputLog(msg));
    }

    public static int wtf(@Nullable String tag, @Nullable String msg) {
        return Log.wtf(tag, msg, null);
    }

    public static int wtf(@Nullable String msg, @Nullable Throwable tr) {
        return Log.wtf(_DefaultTag, msg, tr);
    }

    public static int wtf(@Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg == null && tr == null) {
            return 0;
        }
        if (Log.getLogLevel() > 7) {
            return 0;
        }
        if (_ActionOnWtf != null) {
            _ActionOnWtf.onWtf(msg, tr);
        }
        return Log.printLog(LOGGER_WTF, tag, msg, tr);
    }

    public static boolean isDebuggable() {
        return Log.getLogLevel() != 100;
    }

    private static String getChunkPrefix() {
        return "<" + Process.myTid() + ">";
    }

    private static int printLog(@NonNull Logger logger, @Nullable String tag, @Nullable String msg) {
        return Log.printLog(logger, tag, msg, null);
    }

    private static int printLog(@NonNull Logger logger, @Nullable String tag, @Nullable String msg, @Nullable Throwable tr) {
        if (msg != null && msg.length() > 2048) {
            int wroteByte = 0;
            int chunkCount = 0;
            String prefix = Log.getChunkPrefix();
            for (int i = 0; i < msg.length(); i += 2048) {
                int endPos = i + 2048;
                wroteByte = endPos <= msg.length() ? (wroteByte += logger.printLog(tag, chunkCount + prefix + msg.substring(i, endPos))) : (wroteByte += logger.printLog(tag, chunkCount + prefix + msg.substring(i)));
                ++chunkCount;
            }
            if (tr != null) {
                wroteByte += logger.printLog(tag, "", tr);
            }
            return wroteByte;
        }
        return logger.printLog(tag, msg, tr);
    }

    private static interface Logger {
        public int printLog(@Nullable String var1, @Nullable String var2);

        public int printLog(@Nullable String var1, @Nullable String var2, @Nullable Throwable var3);
    }

    public static interface OnWtfListener {
        public void onWtf(@Nullable String var1, @Nullable Throwable var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

