/*
 * Decompiled with CFR 0.152.
 */
package com.sotwtm.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.sotwtm.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class ECLogcatUtil {
    private static final String COMMAND_SEPARATOR = "\n\r";
    static final String SHARED_PREF_FILE_KEY = "LogcatPref";
    public static final int DEFAULT_LOGCAT_FILE_SIZE = 256;
    public static final LogFormat DEFAULT_LOGCAT_FORMAT = LogFormat.Time;
    public static final int DEFAULT_LOGCAT_MAX_NO_OF_LOG_FILES = 1;
    static final String LOG_TAG = "ECLogcatUtil";
    static final String PREF_KEY_APP_LINUX_USER_NAME = "AppLinuxUserName";
    static final String PREF_KEY_LOGCAT_SINCE = "LogcatSince";
    static final String PREF_KEY_LOGCAT_FILE_MAX_SIZE = "LogcatFileMaxSize";
    static final String PREF_KEY_LOGCAT_FORMAT = "LogcatFormat";
    static final String PREF_KEY_LOGCAT_MAX_LOG_FILE = "LogcatMaxLogFile";
    static final String PREF_KEY_LOGCAT_FILTER_LOG_TAG = "LogcatFilterLogTag";
    static final String PREF_KEY_LOGCAT_PATH = "LogcatPath";
    static final SimpleDateFormat LOGCAT_SINCE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    static final String REGEX_COLUMN_SEPARATOR = "(\\s+[A-Z]?\\s+|\\s+)";
    static final String PS_COL_USER = "USER";
    static final String PS_COL_PID = "PID";
    static final String PS_COL_NAME = "NAME";
    private static volatile ECLogcatUtil _instance;
    private final WeakReference<Context> mContextRef;

    @NonNull
    public static synchronized ECLogcatUtil getInstance(@NonNull Context context) {
        if (_instance == null || ECLogcatUtil._instance.mContextRef.get() == null) {
            _instance = new ECLogcatUtil(context);
        }
        return _instance;
    }

    private ECLogcatUtil(@NonNull Context context) {
        this.mContextRef = new WeakReference<Context>(context.getApplicationContext());
    }

    public synchronized boolean startLogcat() {
        return this.startLogcat(true);
    }

    public synchronized boolean startLogcat(boolean clearPreviousLog) {
        String filterTag;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e("No Context!!!");
            return false;
        }
        String username = ECLogcatUtil.getAppRunByUser(context);
        if (username == null) {
            Log.w(LOG_TAG, "Cannot start logcat due to app user is unknown.");
            return false;
        }
        Log.v(LOG_TAG, "App running by : " + username);
        if (ECLogcatUtil.isLogcatRunningBy(username)) {
            Log.v(LOG_TAG, "logcat running already");
            return true;
        }
        SharedPreferences sharedPreferences = ECLogcatUtil.getSharedPreferences(context);
        String logcatPath = sharedPreferences.getString(PREF_KEY_LOGCAT_PATH, null);
        if (TextUtils.isEmpty((CharSequence)logcatPath)) {
            throw new NullPointerException("Logcat path is not set yet!!!");
        }
        if (clearPreviousLog) {
            boolean deletedOldLog;
            File oldLog = new File(logcatPath);
            boolean bl = deletedOldLog = !oldLog.isFile() || oldLog.delete();
            if (deletedOldLog) {
                Log.d(LOG_TAG, "Deleted old log.");
            } else {
                Log.e(LOG_TAG, "Error on delete old log.");
            }
        }
        StringBuilder commandBuilder = new StringBuilder("logcat");
        commandBuilder.append(COMMAND_SEPARATOR).append("-f").append(COMMAND_SEPARATOR).append(logcatPath).append(COMMAND_SEPARATOR).append("-r").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, 256)).append(COMMAND_SEPARATOR).append("-n").append(COMMAND_SEPARATOR).append(sharedPreferences.getInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, 1)).append(COMMAND_SEPARATOR).append("-v").append(COMMAND_SEPARATOR).append(sharedPreferences.getString(PREF_KEY_LOGCAT_FORMAT, DEFAULT_LOGCAT_FORMAT.toString()));
        String logcatSince = sharedPreferences.getString(PREF_KEY_LOGCAT_SINCE, null);
        if (logcatSince != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("-T").append(COMMAND_SEPARATOR).append("0");
        }
        if ((filterTag = sharedPreferences.getString(PREF_KEY_LOGCAT_FILTER_LOG_TAG, null)) != null) {
            commandBuilder.append(COMMAND_SEPARATOR).append("*:S").append(COMMAND_SEPARATOR).append(filterTag);
        }
        String[] processParams = commandBuilder.toString().split(COMMAND_SEPARATOR);
        ProcessBuilder processBuilder = new ProcessBuilder(processParams);
        processBuilder.redirectErrorStream(true);
        try {
            processBuilder.start();
            Log.v(LOG_TAG, "Started logcat");
            return ECLogcatUtil.isLogcatRunningBy(username);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on starting logcat", e);
            return false;
        }
    }

    public boolean stopLogcat() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e("No Context!!!");
            return false;
        }
        String username = ECLogcatUtil.getAppRunByUser(context);
        if (username == null) {
            Log.e(LOG_TAG, "Cannot get ps user!!!");
            return false;
        }
        String pid = ECLogcatUtil.getLogcatPIDRunningBy(username);
        if (pid == null) {
            return true;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("kill", pid);
        Log.d(Arrays.toString(processBuilder.command().toArray()));
        try {
            Process process = processBuilder.start();
            process.waitFor();
            int exitCode = process.exitValue();
            Log.v(LOG_TAG, "Stopped logcat exit code : " + exitCode);
            return true;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error on kill logcat", e);
            return false;
        }
    }

    public boolean resetLogcat() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e("No Context!!!");
            return false;
        }
        boolean logcatStopped = this.stopLogcat();
        Log.d("Logcat stopped : " + logcatStopped);
        ECLogcatUtil.getEditor(context).remove(PREF_KEY_LOGCAT_SINCE).apply();
        Log.d("Reset logcat");
        return this.startLogcat();
    }

    public boolean clearLogcat() {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            Log.e("No Context!!!");
            return false;
        }
        String logcatSince = LOGCAT_SINCE_FORMAT.format(new Date());
        boolean logcatStopped = this.stopLogcat();
        Log.d("Logcat stopped : " + logcatStopped);
        ECLogcatUtil.getEditor(context).putString(PREF_KEY_LOGCAT_SINCE, logcatSince).apply();
        Log.d("Clear logcat since : " + logcatSince);
        return this.startLogcat();
    }

    public void setLogcatFileMaxSize(int logcatFileMaxSize) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        ECLogcatUtil.getEditor(context).putInt(PREF_KEY_LOGCAT_FILE_MAX_SIZE, logcatFileMaxSize).apply();
    }

    public void setLogcatFormat(@NonNull LogFormat logFormat) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        ECLogcatUtil.getEditor(context).putString(PREF_KEY_LOGCAT_FORMAT, logFormat.toString()).apply();
    }

    public void setMaxLogFile(int maxLogFile) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        ECLogcatUtil.getEditor(context).putInt(PREF_KEY_LOGCAT_MAX_LOG_FILE, maxLogFile).apply();
    }

    public void setFilterLogTag(@Nullable String filterLogTag) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        SharedPreferences.Editor editor = ECLogcatUtil.getEditor(context);
        if (TextUtils.isEmpty((CharSequence)filterLogTag)) {
            editor.remove(PREF_KEY_LOGCAT_FILTER_LOG_TAG);
        } else {
            editor.putString(PREF_KEY_LOGCAT_FILTER_LOG_TAG, filterLogTag);
        }
        editor.apply();
    }

    public void setLogcatDest(@NonNull File file) {
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        ECLogcatUtil.getEditor(context).putString(PREF_KEY_LOGCAT_PATH, file.getAbsolutePath()).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String getAppRunByUser(@NonNull Context context) {
        SharedPreferences sharedPreferences = ECLogcatUtil.getSharedPreferences(context);
        String myUserName = sharedPreferences.getString(PREF_KEY_APP_LINUX_USER_NAME, null);
        if (TextUtils.isEmpty((CharSequence)myUserName)) {
            Process ps;
            String packageName = context.getPackageName();
            Log.d(LOG_TAG, "Retrieving application username. ApplicationPackage = " + packageName);
            ProcessBuilder psBuilder = new ProcessBuilder("ps");
            try {
                ps = psBuilder.start();
            }
            catch (IOException e) {
                Log.e(LOG_TAG, "Not able to run command on this device!!!", e);
                return null;
            }
            InputStream is = ps.getInputStream();
            BufferedReader bf = new BufferedReader(new InputStreamReader(is));
            try {
                Log.d(LOG_TAG, "======`ps` output start======");
                String line = bf.readLine();
                if (line == null) {
                    Log.e(LOG_TAG, "'ps' no output?!");
                    String string = null;
                    return string;
                }
                Log.d(LOG_TAG, line);
                String[] columns = line.split(REGEX_COLUMN_SEPARATOR);
                int userColumn = -1;
                int nameColumn = -1;
                for (int i = 0; i < columns.length; ++i) {
                    if (PS_COL_USER.equalsIgnoreCase(columns[i])) {
                        userColumn = i;
                        continue;
                    }
                    if (!PS_COL_NAME.equalsIgnoreCase(columns[i])) continue;
                    nameColumn = i;
                }
                if (userColumn == -1 || nameColumn == -1) {
                    Log.e(LOG_TAG, "Some column cannot be found from output.");
                    String string = null;
                    return string;
                }
                while ((line = bf.readLine()) != null) {
                    Log.d(LOG_TAG, line);
                    columns = line.split(REGEX_COLUMN_SEPARATOR);
                    if (!packageName.equals(columns[nameColumn])) continue;
                    myUserName = columns[userColumn];
                    Log.d(LOG_TAG, "Application executed by user : " + myUserName);
                    break;
                }
                Log.d(LOG_TAG, "======`ps` output end======");
                if (TextUtils.isEmpty((CharSequence)myUserName)) {
                    Log.e(LOG_TAG, "Cannot find the owner of current app...");
                } else {
                    ECLogcatUtil.getEditor(context).putString(PREF_KEY_APP_LINUX_USER_NAME, myUserName).apply();
                }
            }
            catch (IOException e) {
                Log.e(LOG_TAG, "Error on reading output from 'ps'", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                try {
                    ps.waitFor();
                    ps.exitValue();
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Error on destroy ps", e);
                }
            }
        }
        return myUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String getLogcatPIDRunningBy(@NonNull String user) {
        Process ps;
        String pid = null;
        ProcessBuilder processBuilder = new ProcessBuilder("ps", "logcat");
        try {
            ps = processBuilder.start();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Not able to run command on this device!!!", e);
            return null;
        }
        InputStream is = ps.getInputStream();
        BufferedReader bf = new BufferedReader(new InputStreamReader(is));
        try {
            Log.d(LOG_TAG, "======`ps logcat` output start======");
            String line = bf.readLine();
            if (line == null) {
                Log.e(LOG_TAG, "'ps' no output?!");
                String string = null;
                return string;
            }
            Log.d(LOG_TAG, line);
            String[] columns = line.split(REGEX_COLUMN_SEPARATOR);
            int userColumn = -1;
            int pidColumn = -1;
            for (int i = 0; i < columns.length; ++i) {
                if (PS_COL_USER.equalsIgnoreCase(columns[i])) {
                    userColumn = i;
                    continue;
                }
                if (!PS_COL_PID.equalsIgnoreCase(columns[i])) continue;
                pidColumn = i;
            }
            if (userColumn == -1 || pidColumn == -1) {
                Log.e(LOG_TAG, "Some column cannot be found from output.");
                String string = null;
                return string;
            }
            while ((line = bf.readLine()) != null) {
                Log.d(LOG_TAG, line);
                columns = line.split(REGEX_COLUMN_SEPARATOR);
                if (!user.equals(columns[userColumn])) continue;
                pid = columns[pidColumn];
                Log.v(LOG_TAG, "Logcat is already running by user [" + user + "] pid : " + pid);
            }
            Log.d(LOG_TAG, "======`ps logcat` output end======");
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Error on reading output from 'ps'", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                ps.waitFor();
                ps.exitValue();
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error on destroy ps", e);
            }
        }
        return pid;
    }

    static boolean isLogcatRunningBy(@NonNull String user) {
        return ECLogcatUtil.getLogcatPIDRunningBy(user) != null;
    }

    @NonNull
    private static SharedPreferences.Editor getEditor(@NonNull Context context) {
        SharedPreferences sharedPref = context.getSharedPreferences(SHARED_PREF_FILE_KEY, 0);
        return sharedPref.edit();
    }

    @NonNull
    private static SharedPreferences getSharedPreferences(@NonNull Context context) {
        return context.getSharedPreferences(SHARED_PREF_FILE_KEY, 0);
    }

    public static enum LogFormat {
        Brief,
        Process,
        Tag,
        Thread,
        Raw,
        Time,
        ThreadTime,
        Long;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

