/*
 * Decompiled with CFR 0.152.
 */
package com.sothree.slidinguppanel;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.nineoldandroids.view.animation.AnimatorProxy;
import com.sothree.slidinguppanel.ViewDragHelper;
import com.sothree.slidinguppanel.library.R;

public class SlidingUpPanelLayout
extends ViewGroup {
    private static final String TAG = SlidingUpPanelLayout.class.getSimpleName();
    private static final int DEFAULT_PANEL_HEIGHT = 68;
    private static final float DEFAULT_ANCHOR_POINT = 1.0f;
    private static SlideState DEFAULT_SLIDE_STATE = SlideState.COLLAPSED;
    private static final int DEFAULT_SHADOW_HEIGHT = 4;
    private static final int DEFAULT_FADE_COLOR = -1728053248;
    private static final int DEFAULT_MIN_FLING_VELOCITY = 400;
    private static final boolean DEFAULT_OVERLAY_FLAG = false;
    private static final int[] DEFAULT_ATTRS = new int[]{16842927};
    private int mMinFlingVelocity = 400;
    private int mCoveredFadeColor = -1728053248;
    private static final int DEFAULT_PARALAX_OFFSET = 0;
    private final Paint mCoveredFadePaint = new Paint();
    private final Drawable mShadowDrawable;
    private int mPanelHeight = -1;
    private int mShadowHeight = -1;
    private int mParallaxOffset = -1;
    private boolean mIsSlidingUp;
    private boolean mOverlayContent = false;
    private View mDragView;
    private int mDragViewResId = -1;
    private View mSlideableView;
    private View mMainView;
    private SlideState mSlideState = SlideState.COLLAPSED;
    private float mSlideOffset;
    private int mSlideRange;
    private boolean mIsUnableToDrag;
    private boolean mIsSlidingEnabled;
    private boolean mIsUsingDragViewTouchEvents;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private float mAnchorPoint = 1.0f;
    private PanelSlideListener mPanelSlideListener;
    private final ViewDragHelper mDragHelper;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();

    public SlidingUpPanelLayout(Context context) {
        this(context, null);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingUpPanelLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            this.mShadowDrawable = null;
            this.mDragHelper = null;
            return;
        }
        if (attrs != null) {
            TypedArray defAttrs = context.obtainStyledAttributes(attrs, DEFAULT_ATTRS);
            if (defAttrs != null) {
                int gravity = defAttrs.getInt(0, 0);
                if (gravity != 48 && gravity != 80) {
                    throw new IllegalArgumentException("gravity must be set to either top or bottom");
                }
                this.mIsSlidingUp = gravity == 80;
            }
            defAttrs.recycle();
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingUpPanelLayout);
            if (ta != null) {
                this.mPanelHeight = ta.getDimensionPixelSize(0, -1);
                this.mShadowHeight = ta.getDimensionPixelSize(1, -1);
                this.mParallaxOffset = ta.getDimensionPixelSize(2, -1);
                this.mMinFlingVelocity = ta.getInt(4, 400);
                this.mCoveredFadeColor = ta.getColor(3, -1728053248);
                this.mDragViewResId = ta.getResourceId(5, -1);
                this.mOverlayContent = ta.getBoolean(6, false);
                this.mAnchorPoint = ta.getFloat(7, 1.0f);
                this.mSlideState = SlideState.values()[ta.getInt(8, DEFAULT_SLIDE_STATE.ordinal())];
            }
            ta.recycle();
        }
        float density = context.getResources().getDisplayMetrics().density;
        if (this.mPanelHeight == -1) {
            this.mPanelHeight = (int)(68.0f * density + 0.5f);
        }
        if (this.mShadowHeight == -1) {
            this.mShadowHeight = (int)(4.0f * density + 0.5f);
        }
        if (this.mParallaxOffset == -1) {
            this.mParallaxOffset = (int)(0.0f * density);
        }
        this.mShadowDrawable = this.mShadowHeight > 0 ? (this.mIsSlidingUp ? this.getResources().getDrawable(R.drawable.above_shadow) : this.getResources().getDrawable(R.drawable.below_shadow)) : null;
        this.setWillNotDraw(false);
        this.mDragHelper = ViewDragHelper.create(this, 0.5f, new DragHelperCallback());
        this.mDragHelper.setMinVelocity((float)this.mMinFlingVelocity * density);
        this.mIsSlidingEnabled = true;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mDragViewResId != -1) {
            this.setDragView(this.findViewById(this.mDragViewResId));
        }
    }

    public void setCoveredFadeColor(int color) {
        this.mCoveredFadeColor = color;
        this.invalidate();
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setSlidingEnabled(boolean enabled) {
        this.mIsSlidingEnabled = enabled;
    }

    public boolean isSlidingEnabled() {
        return this.mIsSlidingEnabled && this.mSlideableView != null;
    }

    public void setPanelHeight(int val) {
        this.mPanelHeight = val;
        this.requestLayout();
    }

    public int getPanelHeight() {
        return this.mPanelHeight;
    }

    public int getCurrentParalaxOffset() {
        int offset = (int)((float)this.mParallaxOffset * Math.max(this.mSlideOffset, 0.0f));
        return this.mIsSlidingUp ? -offset : offset;
    }

    public void setPanelSlideListener(PanelSlideListener listener) {
        this.mPanelSlideListener = listener;
    }

    public void setDragView(View dragView) {
        if (this.mDragView != null) {
            this.mDragView.setOnClickListener(null);
        }
        this.mDragView = dragView;
        if (this.mDragView != null) {
            this.mDragView.setClickable(true);
            this.mDragView.setFocusable(false);
            this.mDragView.setFocusableInTouchMode(false);
            this.mDragView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!SlidingUpPanelLayout.this.isEnabled()) {
                        return;
                    }
                    if (!SlidingUpPanelLayout.this.isPanelExpanded() && !SlidingUpPanelLayout.this.isPanelAnchored()) {
                        SlidingUpPanelLayout.this.expandPanel(SlidingUpPanelLayout.this.mAnchorPoint);
                    } else {
                        SlidingUpPanelLayout.this.collapsePanel();
                    }
                }
            });
        }
    }

    public void setAnchorPoint(float anchorPoint) {
        if (anchorPoint > 0.0f && anchorPoint <= 1.0f) {
            this.mAnchorPoint = anchorPoint;
        }
    }

    public float getAnchorPoint() {
        return this.mAnchorPoint;
    }

    public void setOverlayed(boolean overlayed) {
        this.mOverlayContent = overlayed;
    }

    public boolean isOverlayed() {
        return this.mOverlayContent;
    }

    void dispatchOnPanelSlide(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(panel, this.mSlideOffset);
        }
    }

    void dispatchOnPanelExpanded(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelExpanded(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelCollapsed(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelCollapsed(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelAnchored(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelAnchored(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelHidden(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelHidden(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void updateObscuredViewVisibility() {
        int bottom;
        int top;
        int right;
        int left;
        if (this.getChildCount() == 0) {
            return;
        }
        int leftBound = this.getPaddingLeft();
        int rightBound = this.getWidth() - this.getPaddingRight();
        int topBound = this.getPaddingTop();
        int bottomBound = this.getHeight() - this.getPaddingBottom();
        if (this.mSlideableView != null && SlidingUpPanelLayout.hasOpaqueBackground(this.mSlideableView)) {
            left = this.mSlideableView.getLeft();
            right = this.mSlideableView.getRight();
            top = this.mSlideableView.getTop();
            bottom = this.mSlideableView.getBottom();
        } else {
            bottom = 0;
            top = 0;
            right = 0;
            left = 0;
        }
        View child = this.getChildAt(0);
        int clampedChildLeft = Math.max(leftBound, child.getLeft());
        int clampedChildTop = Math.max(topBound, child.getTop());
        int clampedChildRight = Math.min(rightBound, child.getRight());
        int clampedChildBottom = Math.min(bottomBound, child.getBottom());
        int vis = clampedChildLeft >= left && clampedChildTop >= top && clampedChildRight <= right && clampedChildBottom <= bottom ? 4 : 0;
        child.setVisibility(vis);
    }

    void setAllChildrenVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 4) continue;
            child.setVisibility(0);
        }
    }

    private static boolean hasOpaqueBackground(View v) {
        Drawable bg = v.getBackground();
        return bg != null && bg.getOpacity() == -1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
        }
        if (heightMode != 0x40000000) {
            throw new IllegalStateException("Height must have an exact value or MATCH_PARENT");
        }
        int childCount = this.getChildCount();
        if (childCount != 2) {
            throw new IllegalStateException("Sliding up panel layout must have exactly 2 children!");
        }
        this.mMainView = this.getChildAt(0);
        this.mSlideableView = this.getChildAt(1);
        if (this.mDragView == null) {
            this.setDragView(this.mSlideableView);
        }
        if (this.mSlideableView.getVisibility() == 8) {
            this.mSlideState = SlideState.HIDDEN;
        }
        int layoutHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 && i == 0) continue;
            int height = layoutHeight;
            if (child == this.mMainView && !this.mOverlayContent && this.mSlideState != SlideState.HIDDEN) {
                height -= this.mPanelHeight;
            }
            int childWidthSpec = lp.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE) : (lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)0x40000000));
            int childHeightSpec = lp.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE) : (lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
            child.measure(childWidthSpec, childHeightSpec);
            if (child != this.mSlideableView) continue;
            this.mSlideRange = this.mSlideableView.getMeasuredHeight() - this.mPanelHeight;
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int childCount = this.getChildCount();
        if (this.mFirstLayout) {
            switch (this.mSlideState) {
                case EXPANDED: {
                    this.mSlideOffset = 1.0f;
                    break;
                }
                case ANCHORED: {
                    this.mSlideOffset = this.mAnchorPoint;
                    break;
                }
                case HIDDEN: {
                    int newTop = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
                    this.mSlideOffset = this.computeSlideOffset(newTop);
                    break;
                }
                default: {
                    this.mSlideOffset = 0.0f;
                }
            }
        }
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 && (i == 0 || this.mFirstLayout)) continue;
            int childHeight = child.getMeasuredHeight();
            int childTop = paddingTop;
            if (child == this.mSlideableView) {
                childTop = this.computePanelTopPosition(this.mSlideOffset);
            }
            if (!this.mIsSlidingUp && child == this.mMainView && !this.mOverlayContent) {
                childTop = this.computePanelTopPosition(this.mSlideOffset) + this.mSlideableView.getMeasuredHeight();
            }
            int childBottom = childTop + childHeight;
            int childLeft = paddingLeft;
            int childRight = childLeft + child.getMeasuredWidth();
            child.layout(childLeft, childTop, childRight, childBottom);
        }
        if (this.mFirstLayout) {
            this.updateObscuredViewVisibility();
        }
        this.mFirstLayout = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (h != oldh) {
            this.mFirstLayout = true;
        }
    }

    public void setEnableDragViewTouchEvents(boolean enabled) {
        this.mIsUsingDragViewTouchEvents = enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.collapsePanel();
        }
        super.setEnabled(enabled);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (!this.isEnabled() || !this.mIsSlidingEnabled || this.mIsUnableToDrag && action != 0) {
            this.mDragHelper.cancel();
            return super.onInterceptTouchEvent(ev);
        }
        if (action == 3 || action == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        float x = ev.getX();
        float y = ev.getY();
        switch (action) {
            case 0: {
                this.mIsUnableToDrag = false;
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                break;
            }
            case 2: {
                float adx = Math.abs(x - this.mInitialMotionX);
                float ady = Math.abs(y - this.mInitialMotionY);
                int dragSlop = this.mDragHelper.getTouchSlop();
                if (this.mIsUsingDragViewTouchEvents && adx > (float)dragSlop && ady < (float)dragSlop) {
                    return super.onInterceptTouchEvent(ev);
                }
                if (!(ady > (float)dragSlop && adx > ady) && this.isDragViewUnder((int)this.mInitialMotionX, (int)this.mInitialMotionY)) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
        }
        return this.mDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isSlidingEnabled()) {
            return super.onTouchEvent(ev);
        }
        this.mDragHelper.processTouchEvent(ev);
        return true;
    }

    private boolean isDragViewUnder(int x, int y) {
        if (this.mDragView == null) {
            return false;
        }
        int[] viewLocation = new int[2];
        this.mDragView.getLocationOnScreen(viewLocation);
        int[] parentLocation = new int[2];
        this.getLocationOnScreen(parentLocation);
        int screenX = parentLocation[0] + x;
        int screenY = parentLocation[1] + y;
        return screenX >= viewLocation[0] && screenX < viewLocation[0] + this.mDragView.getWidth() && screenY >= viewLocation[1] && screenY < viewLocation[1] + this.mDragView.getHeight();
    }

    private boolean expandPanel(View pane, int initialVelocity, float mSlideOffset) {
        return this.mFirstLayout || this.smoothSlideTo(mSlideOffset, initialVelocity);
    }

    private boolean collapsePanel(View pane, int initialVelocity) {
        return this.mFirstLayout || this.smoothSlideTo(0.0f, initialVelocity);
    }

    private int computePanelTopPosition(float slideOffset) {
        int slidingViewHeight = this.mSlideableView != null ? this.mSlideableView.getMeasuredHeight() : 0;
        int slidePixelOffset = (int)(slideOffset * (float)this.mSlideRange);
        return this.mIsSlidingUp ? this.getMeasuredHeight() - this.getPaddingBottom() - this.mPanelHeight - slidePixelOffset : this.getPaddingTop() - slidingViewHeight + this.mPanelHeight + slidePixelOffset;
    }

    private float computeSlideOffset(int topPosition) {
        int topBoundCollapsed = this.computePanelTopPosition(0.0f);
        return this.mIsSlidingUp ? (float)(topBoundCollapsed - topPosition) / (float)this.mSlideRange : (float)(topPosition - topBoundCollapsed) / (float)this.mSlideRange;
    }

    public boolean collapsePanel() {
        if (this.mFirstLayout) {
            this.mSlideState = SlideState.COLLAPSED;
            return true;
        }
        if (this.mSlideState == SlideState.HIDDEN || this.mSlideState == SlideState.COLLAPSED) {
            return false;
        }
        return this.collapsePanel(this.mSlideableView, 0);
    }

    public boolean expandPanel() {
        if (this.mFirstLayout) {
            this.mSlideState = SlideState.EXPANDED;
            return true;
        }
        return this.expandPanel(1.0f);
    }

    public boolean anchorPanel() {
        if (this.mFirstLayout) {
            this.mSlideState = SlideState.ANCHORED;
            return true;
        }
        return this.expandPanel(this.mAnchorPoint);
    }

    public boolean expandPanel(float mSlideOffset) {
        if (this.mSlideableView == null || this.mSlideState == SlideState.EXPANDED) {
            return false;
        }
        this.mSlideableView.setVisibility(0);
        return this.expandPanel(this.mSlideableView, 0, mSlideOffset);
    }

    public boolean isPanelExpanded() {
        return this.mSlideState == SlideState.EXPANDED;
    }

    public boolean isPanelAnchored() {
        return this.mSlideState == SlideState.ANCHORED;
    }

    public boolean isPanelHidden() {
        return this.mSlideState == SlideState.HIDDEN;
    }

    public void showPanel() {
        if (this.mFirstLayout) {
            this.mSlideState = SlideState.COLLAPSED;
        } else {
            if (this.mSlideableView == null || this.mSlideState != SlideState.HIDDEN) {
                return;
            }
            this.mSlideableView.setVisibility(0);
            this.requestLayout();
            this.smoothSlideTo(0.0f, 0);
        }
    }

    public void hidePanel() {
        if (this.mFirstLayout) {
            this.mSlideState = SlideState.HIDDEN;
        } else {
            if (this.mSlideState == SlideState.DRAGGING || this.mSlideState == SlideState.HIDDEN) {
                return;
            }
            int newTop = this.computePanelTopPosition(0.0f) + (this.mIsSlidingUp ? this.mPanelHeight : -this.mPanelHeight);
            this.smoothSlideTo(this.computeSlideOffset(newTop), 0);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void onPanelDragged(int newTop) {
        this.mSlideState = SlideState.DRAGGING;
        this.mSlideOffset = this.computeSlideOffset(newTop);
        if (this.mParallaxOffset > 0 && this.mSlideOffset >= 0.0f) {
            int mainViewOffset = this.getCurrentParalaxOffset();
            if (Build.VERSION.SDK_INT >= 11) {
                this.mMainView.setTranslationY((float)mainViewOffset);
            } else {
                AnimatorProxy.wrap((View)this.mMainView).setTranslationY((float)mainViewOffset);
            }
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
        if (this.mSlideOffset <= 0.0f && !this.mOverlayContent) {
            LayoutParams lp = (LayoutParams)this.mMainView.getLayoutParams();
            lp.height = this.mIsSlidingUp ? newTop - this.getPaddingBottom() : this.getHeight() - this.getPaddingBottom() - this.mSlideableView.getMeasuredHeight() - newTop;
            this.mMainView.requestLayout();
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        int save = canvas.save(2);
        if (this.isSlidingEnabled() && this.mSlideableView != child && !this.mOverlayContent) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.mIsSlidingUp) {
                this.mTmpRect.bottom = Math.min(this.mTmpRect.bottom, this.mSlideableView.getTop());
            } else {
                this.mTmpRect.top = Math.max(this.mTmpRect.top, this.mSlideableView.getBottom());
            }
            canvas.clipRect(this.mTmpRect);
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(save);
        if (this.mCoveredFadeColor != 0 && this.mSlideOffset > 0.0f) {
            int baseAlpha = (this.mCoveredFadeColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * this.mSlideOffset);
            int color = imag << 24 | this.mCoveredFadeColor & 0xFFFFFF;
            this.mCoveredFadePaint.setColor(color);
            canvas.drawRect(this.mTmpRect, this.mCoveredFadePaint);
        }
        return result;
    }

    boolean smoothSlideTo(float slideOffset, int velocity) {
        if (!this.isSlidingEnabled()) {
            return false;
        }
        int panelTop = this.computePanelTopPosition(slideOffset);
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, this.mSlideableView.getLeft(), panelTop)) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)this);
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper != null && this.mDragHelper.continueSettling(true)) {
            if (!this.isSlidingEnabled()) {
                this.mDragHelper.abort();
                return;
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void draw(Canvas c) {
        int bottom;
        int top;
        super.draw(c);
        if (!this.isSlidingEnabled()) {
            return;
        }
        int right = this.mSlideableView.getRight();
        if (this.mIsSlidingUp) {
            top = this.mSlideableView.getTop() - this.mShadowHeight;
            bottom = this.mSlideableView.getTop();
        } else {
            top = this.mSlideableView.getBottom();
            bottom = this.mSlideableView.getBottom() + this.mShadowHeight;
        }
        int left = this.mSlideableView.getLeft();
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setBounds(left, top, right, bottom);
            this.mShadowDrawable.draw(c);
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && ViewCompat.canScrollHorizontally((View)v, (int)(-dx));
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mSlideState = this.mSlideState;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSlideState = ss.mSlideState;
    }

    static class SavedState
    extends View.BaseSavedState {
        SlideState mSlideState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            try {
                this.mSlideState = Enum.valueOf(SlideState.class, in.readString());
            }
            catch (IllegalArgumentException e) {
                this.mSlideState = SlideState.COLLAPSED;
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.mSlideState.toString());
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int[] ATTRS = new int[]{0x1010181};

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, ATTRS);
            a.recycle();
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidingUpPanelLayout.this.mIsUnableToDrag) {
                return false;
            }
            return child == SlidingUpPanelLayout.this.mSlideableView;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            if (SlidingUpPanelLayout.this.mDragHelper.getViewDragState() == 0) {
                SlidingUpPanelLayout.this.mSlideOffset = SlidingUpPanelLayout.this.computeSlideOffset(SlidingUpPanelLayout.this.mSlideableView.getTop());
                if (SlidingUpPanelLayout.this.mSlideOffset == 1.0f) {
                    if (SlidingUpPanelLayout.this.mSlideState != SlideState.EXPANDED) {
                        SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                        SlidingUpPanelLayout.this.mSlideState = SlideState.EXPANDED;
                        SlidingUpPanelLayout.this.dispatchOnPanelExpanded(SlidingUpPanelLayout.this.mSlideableView);
                    }
                } else if (SlidingUpPanelLayout.this.mSlideOffset == 0.0f) {
                    if (SlidingUpPanelLayout.this.mSlideState != SlideState.COLLAPSED) {
                        SlidingUpPanelLayout.this.mSlideState = SlideState.COLLAPSED;
                        SlidingUpPanelLayout.this.dispatchOnPanelCollapsed(SlidingUpPanelLayout.this.mSlideableView);
                    }
                } else if (SlidingUpPanelLayout.this.mSlideOffset < 0.0f) {
                    SlidingUpPanelLayout.this.mSlideState = SlideState.HIDDEN;
                    SlidingUpPanelLayout.this.mSlideableView.setVisibility(8);
                    SlidingUpPanelLayout.this.dispatchOnPanelHidden(SlidingUpPanelLayout.this.mSlideableView);
                } else if (SlidingUpPanelLayout.this.mSlideState != SlideState.ANCHORED) {
                    SlidingUpPanelLayout.this.updateObscuredViewVisibility();
                    SlidingUpPanelLayout.this.mSlideState = SlideState.ANCHORED;
                    SlidingUpPanelLayout.this.dispatchOnPanelAnchored(SlidingUpPanelLayout.this.mSlideableView);
                }
            }
        }

        @Override
        public void onViewCaptured(View capturedChild, int activePointerId) {
            SlidingUpPanelLayout.this.setAllChildrenVisible();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidingUpPanelLayout.this.onPanelDragged(top);
            SlidingUpPanelLayout.this.invalidate();
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            float direction;
            int target = 0;
            float f = direction = SlidingUpPanelLayout.this.mIsSlidingUp ? -yvel : yvel;
            target = direction > 0.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(1.0f) : (direction < 0.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(0.0f) : (SlidingUpPanelLayout.this.mAnchorPoint != 1.0f && SlidingUpPanelLayout.this.mSlideOffset >= (1.0f + SlidingUpPanelLayout.this.mAnchorPoint) / 2.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(1.0f) : (SlidingUpPanelLayout.this.mAnchorPoint == 1.0f && SlidingUpPanelLayout.this.mSlideOffset >= 0.5f ? SlidingUpPanelLayout.this.computePanelTopPosition(1.0f) : (SlidingUpPanelLayout.this.mAnchorPoint != 1.0f && SlidingUpPanelLayout.this.mSlideOffset >= SlidingUpPanelLayout.this.mAnchorPoint ? SlidingUpPanelLayout.this.computePanelTopPosition(SlidingUpPanelLayout.this.mAnchorPoint) : (SlidingUpPanelLayout.this.mAnchorPoint != 1.0f && SlidingUpPanelLayout.this.mSlideOffset >= SlidingUpPanelLayout.this.mAnchorPoint / 2.0f ? SlidingUpPanelLayout.this.computePanelTopPosition(SlidingUpPanelLayout.this.mAnchorPoint) : SlidingUpPanelLayout.this.computePanelTopPosition(0.0f))))));
            SlidingUpPanelLayout.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), target);
            SlidingUpPanelLayout.this.invalidate();
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return SlidingUpPanelLayout.this.mSlideRange;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            int collapsedTop = SlidingUpPanelLayout.this.computePanelTopPosition(0.0f);
            int expandedTop = SlidingUpPanelLayout.this.computePanelTopPosition(1.0f);
            if (SlidingUpPanelLayout.this.mIsSlidingUp) {
                return Math.min(Math.max(top, expandedTop), collapsedTop);
            }
            return Math.min(Math.max(top, collapsedTop), expandedTop);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelSlide(View panel, float slideOffset) {
        }

        @Override
        public void onPanelCollapsed(View panel) {
        }

        @Override
        public void onPanelExpanded(View panel) {
        }

        @Override
        public void onPanelAnchored(View panel) {
        }

        @Override
        public void onPanelHidden(View panel) {
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(View var1, float var2);

        public void onPanelCollapsed(View var1);

        public void onPanelExpanded(View var1);

        public void onPanelAnchored(View var1);

        public void onPanelHidden(View var1);
    }

    private static enum SlideState {
        EXPANDED,
        COLLAPSED,
        ANCHORED,
        HIDDEN,
        DRAGGING;

    }
}

