/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.model.RunAction2;
import org.apache.commons.io.FileUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ScanLogAction
implements RunAction2 {
    public static final String FILE_NAME = "com.sonyericsson.jenkins.plugins.bfa.ScanLogAction.log";
    private transient Run run;
    private long startTime = System.currentTimeMillis();
    private Long endTime;
    private String exceptionMessage;

    @NonNull
    public String getIconFileName() {
        return PluginImpl.getDefaultIcon();
    }

    @NonNull
    public String getDisplayName() {
        return Messages.ScanLogAction_DisplayName();
    }

    public Run getRun() {
        return this.run;
    }

    @NonNull
    public String getUrlName() {
        return "failure-cause-scan-log";
    }

    public String getLogText() throws IOException {
        return FileUtils.readFileToString((File)new File(this.run.getRootDir(), FILE_NAME), (Charset)StandardCharsets.UTF_8);
    }

    @Exported
    public long getStartTime() {
        return this.startTime;
    }

    @Exported
    public Long getEndTime() {
        return this.endTime;
    }

    @Restricted(value={NoExternalUse.class})
    protected void finished() {
        this.endTime = System.currentTimeMillis();
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }
}

