/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.tokens;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandTask;
import com.sonyericsson.jenkins.plugins.bfa.tokens.Renderer;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension(optional=true)
public class Token
extends DataBoundTokenMacro {
    private Renderer renderer = new Renderer();

    @DataBoundTokenMacro.Parameter
    public void setIncludeIndications(boolean includeIndications) {
        this.renderer.setIncludeIndications(includeIndications);
    }

    @DataBoundTokenMacro.Parameter
    public void setUseHtmlFormat(boolean useHtmlFormat) {
        this.renderer.setUseHtmlFormat(useHtmlFormat);
    }

    @DataBoundTokenMacro.Parameter
    public void setIncludeTitle(boolean includeTitle) {
        this.renderer.setIncludeTitle(includeTitle);
    }

    @DataBoundTokenMacro.Parameter
    public void setWrapWidth(int wrapWidth) {
        this.renderer.setWrapWidth(wrapWidth);
    }

    @DataBoundTokenMacro.Parameter
    public void setNoFailureText(String noFailureText) {
        this.renderer.setNoFailureText(noFailureText);
    }

    public boolean acceptsMacroName(String macroName) {
        return "BUILD_FAILURE_ANALYZER".equals(macroName);
    }

    public boolean handlesHtmlEscapeInternally() {
        return true;
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate(run);
    }

    private String evaluate(Run<?, ?> run) {
        new ScanOnDemandTask(run).run();
        this.renderer.setEscapeHtml(this.escapeHtml);
        FailureCauseBuildAction action = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
        if (action != null) {
            return this.renderer.render(action);
        }
        FailureCauseMatrixBuildAction matrixAction = (FailureCauseMatrixBuildAction)run.getAction(FailureCauseMatrixBuildAction.class);
        if (matrixAction != null) {
            return this.renderer.render(matrixAction);
        }
        return "";
    }
}

