/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.BfaGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BarChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphCache;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphType;
import com.sonyericsson.jenkins.plugins.bfa.graphs.PieChart;
import com.sonyericsson.jenkins.plugins.bfa.graphs.TimeSeriesChart;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.util.Graph;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;

public class ComputerGraphAction
extends BfaGraphAction {
    private static final String GRAPH_TITLE_CAUSES = "Failure causes for this node";
    private static final String GRAPH_TITLE_CATEGORIES = "Failures grouped by categories for this node";
    private static final String URL_NAME = "bfa-comp-graphs";
    private static final String DISPLAY_NAME = "Graph statistics";
    private Computer computer;

    public ComputerGraphAction(Computer computer) {
        this.computer = computer;
    }

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION) && PluginImpl.getInstance().isGraphsEnabled()) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (PluginImpl.getInstance().isGraphsEnabled()) {
            return DISPLAY_NAME;
        }
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    private String getNodeName() {
        if (this.computer == null) {
            return null;
        }
        return this.computer.getName();
    }

    private boolean isSlave() {
        if (this.computer == null) {
            return false;
        }
        return this.computer.getNode() instanceof Slave;
    }

    @Override
    public ModelObject getOwner() {
        return this.computer;
    }

    @Override
    public GraphType[] getGraphTypes() {
        return new GraphType[]{GraphType.BAR_CHART_CAUSES, GraphType.PIE_CHART_CAUSES, GraphType.TIME_SERIES_CHART_CAUSES, GraphType.BAR_CHART_CATEGORIES, GraphType.PIE_CHART_CATEGORIES, GraphType.TIME_SERIES_CHART_CATEGORIES};
    }

    @Override
    public String getGraphsPageTitle() {
        return "Statistics for node " + this.getNodeName();
    }

    @Override
    protected Graph getGraph(GraphType which, Date timePeriod, boolean hideManAborted, boolean forAllMasters, Map<String, String> rawReqParams) {
        GraphFilterBuilder filter = this.getDefaultBuilder(hideManAborted, timePeriod);
        switch (which) {
            case BAR_CHART_CAUSES: {
                return new BarChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CAUSES, false);
            }
            case BAR_CHART_CATEGORIES: {
                return new BarChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CATEGORIES, true);
            }
            case PIE_CHART_CAUSES: {
                return new PieChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CAUSES, false);
            }
            case PIE_CHART_CATEGORIES: {
                return new PieChart(-1L, 700, 500, null, filter, GRAPH_TITLE_CATEGORIES, true);
            }
            case TIME_SERIES_CHART_CAUSES: {
                return this.getTimeSeriesChart(false, GRAPH_TITLE_CAUSES, filter, rawReqParams);
            }
            case TIME_SERIES_CHART_CATEGORIES: {
                return this.getTimeSeriesChart(true, GRAPH_TITLE_CATEGORIES, filter, rawReqParams);
            }
        }
        return null;
    }

    private Graph getTimeSeriesChart(boolean byCategories, String title, GraphFilterBuilder filter, Map<String, String> rawReqParams) {
        int interval;
        String date = rawReqParams.get("time");
        Calendar cal = Calendar.getInstance();
        if ("today".equals(date)) {
            interval = 11;
            cal.add(6, -1);
        } else {
            interval = 5;
            cal.add(2, -1);
        }
        filter.setSince(cal.getTime());
        return new TimeSeriesChart(-1L, 700, 500, null, filter, interval, byCategories, title);
    }

    private GraphFilterBuilder getDefaultBuilder(boolean hideAborted, Date period) {
        GraphFilterBuilder filter = new GraphFilterBuilder();
        if (hideAborted) {
            filter.setExcludeResult("ABORTED");
        }
        filter.setSince(period);
        String nodeName = this.getNodeName();
        if (this.isSlave()) {
            filter.setSlaveName(nodeName);
        } else {
            filter.setMasterName(BfaUtils.getMasterName());
        }
        return filter;
    }

    @Override
    protected String getGraphCacheId(GraphType whichGraph, String reqTimePeriod, boolean hideAborted, boolean forAllMasters) {
        return this.getClass().getSimpleName() + '-' + whichGraph.getValue() + '-' + this.getNodeName() + '-' + reqTimePeriod + '-' + String.valueOf(hideAborted);
    }

    public static void invalidateNodeGraphCache(Computer computer) {
        if (computer != null) {
            Pattern projectPattern = Pattern.compile("^.*-" + computer.getName() + '-' + ".*$");
            GraphCache.getInstance().invalidateMatching(projectPattern);
        }
    }

    public static void invalidateNodeGraphCache(Node buildNode) {
        if (buildNode != null) {
            Computer correspondingComputer = buildNode.toComputer();
            ComputerGraphAction.invalidateNodeGraphCache(correspondingComputer);
        }
    }
}

