/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.dbf.DownstreamBuildFinder;
import hudson.matrix.MatrixRun;
import hudson.model.BuildBadgeAction;
import hudson.model.Run;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class FailureCauseBuildAction
implements BuildBadgeAction {
    private transient List<FailureCause> failureCauses;
    private List<FoundFailureCause> foundFailureCauses;
    public static final String URL_NAME = "bfa";
    private static final Logger logger = Logger.getLogger(FailureCauseBuildAction.class.getName());
    private Run build;

    public FailureCauseBuildAction(List<FoundFailureCause> foundFailureCauses) {
        this.foundFailureCauses = foundFailureCauses;
    }

    public String getIconFileName() {
        if (Jenkins.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (Jenkins.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return Messages.CauseManagement_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Exported
    public List<FoundFailureCause> getFoundFailureCauses() {
        return this.foundFailureCauses;
    }

    public String getImageUrl() {
        return PluginImpl.getFullImageUrl("48x48", "information.png");
    }

    public String getBadgeImageUrl() {
        return PluginImpl.getFullImageUrl("16x16", "information.png");
    }

    public PluginImpl getPluginImpl() {
        return PluginImpl.getInstance();
    }

    public Object readResolve() {
        if (this.failureCauses != null) {
            LinkedList<FoundFailureCause> list = new LinkedList<FoundFailureCause>();
            for (FailureCause fc : this.failureCauses) {
                list.add(new FoundFailureCause(fc));
            }
            this.foundFailureCauses = list;
            this.failureCauses = null;
        }
        return this;
    }

    public FoundFailureCause getDynamic(String token, StaplerRequest req, StaplerResponse resp) {
        try {
            int causeNumber = Integer.parseInt(token) - 1;
            if (causeNumber >= 0 && causeNumber < this.foundFailureCauses.size()) {
                return this.foundFailureCauses.get(causeNumber);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "[BFA] Failed to parse token for getDynamic: " + token);
            return null;
        }
        logger.log(Level.WARNING, "[BFA] Unable to navigate to the FailureCause: " + token);
        return null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) throws IOException {
        resp.sendRedirect2("../../failure-cause-management");
    }

    public void setBuild(Run build) {
        this.build = build;
    }

    public Run getBuild() {
        return this.build;
    }

    @Exported
    public FailureCauseDisplayData getFailureCauseDisplayData() {
        FailureCauseDisplayData failureCauseDisplayData = FailureCauseBuildAction.getDownstreamData(this, 0);
        if (failureCauseDisplayData == null) {
            failureCauseDisplayData = new FailureCauseDisplayData();
            failureCauseDisplayData.setFoundFailureCauses(this.getFoundFailureCauses());
        }
        return failureCauseDisplayData;
    }

    private static FailureCauseDisplayData getDownstreamData(FailureCauseBuildAction buildAction, int depth) {
        int maxDepth = 10;
        FailureCauseDisplayData displayData = null;
        if (depth < 10 && buildAction.getBuild() != null) {
            Run build = buildAction.getBuild();
            displayData = new FailureCauseDisplayData(build.getParent().getUrl(), build.getParent().getDisplayName(), build.getUrl(), build.getDisplayName());
            displayData.setFoundFailureCauses(buildAction.getFoundFailureCauses());
            for (Run<?, ?> run : FailureCauseBuildAction.getDownstreamBuilds(buildAction.getBuild())) {
                FailureCauseBuildAction.checkSubFailureCauseBuildAction(run, displayData, depth);
            }
        }
        return displayData;
    }

    private static void checkSubFailureCauseBuildAction(Run run, FailureCauseDisplayData displayData, int depth) {
        FailureCauseBuildAction subAction = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
        if (subAction != null) {
            FailureCauseBuildAction.setSubDisplayData(subAction, displayData, depth);
        } else {
            FailureCauseMatrixBuildAction subMatrixAction = (FailureCauseMatrixBuildAction)run.getAction(FailureCauseMatrixBuildAction.class);
            if (subMatrixAction != null) {
                for (MatrixRun matrixRun : subMatrixAction.getRunsWithAction()) {
                    FailureCauseBuildAction action = (FailureCauseBuildAction)matrixRun.getAction(FailureCauseBuildAction.class);
                    if (action == null) continue;
                    FailureCauseDisplayData subDisplayData = FailureCauseBuildAction.setSubDisplayData(action, displayData, depth);
                    FailureCauseBuildAction.adjustProjectDisplayName(run, subDisplayData);
                }
            }
        }
    }

    private static FailureCauseDisplayData setSubDisplayData(FailureCauseBuildAction subAction, FailureCauseDisplayData displayData, int depth) {
        FailureCauseDisplayData subDisplayData = FailureCauseBuildAction.getDownstreamData(subAction, depth + 1);
        if (subDisplayData != null) {
            displayData.addDownstreamFailureCause(subDisplayData);
        }
        return subDisplayData;
    }

    private static void adjustProjectDisplayName(Run run, FailureCauseDisplayData subDisplayData) {
        if (subDisplayData != null) {
            subDisplayData.getLinks().setProjectDisplayName(run.getParent().getFullName() + " \u00bb " + subDisplayData.getLinks().getProjectDisplayName());
        }
    }

    private static Set<Run<?, ?>> getDownstreamBuilds(Run build) {
        TreeSet foundDbf = new TreeSet(new Comparator<Run<?, ?>>(){

            @Override
            public int compare(Run<?, ?> o1, Run<?, ?> o2) {
                int res = o1.getParent().getFullName().compareTo(o2.getParent().getFullName());
                if (res == 0) {
                    return o1.number - o2.number;
                }
                return res;
            }
        });
        for (DownstreamBuildFinder dbf : DownstreamBuildFinder.getAll()) {
            List<Run<?, ?>> downstreamBuilds = dbf.getDownstreamBuilds(build);
            for (Run<?, ?> downstreamBuild : downstreamBuilds) {
                if (downstreamBuild != null) {
                    foundDbf.add(downstreamBuild);
                    continue;
                }
                logger.log(Level.FINER, "[BFA] Ignoring missing downstream build for " + build.getFullDisplayName());
            }
        }
        return foundDbf;
    }
}

