/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.statistics;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StatisticsLogger {
    private static final Logger logger = Logger.getLogger(StatisticsLogger.class.getName());
    private static StatisticsLogger instance;
    private ExecutorService queueExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(target, "BFA StatisticsLogger Queue");
        }
    });

    private StatisticsLogger() {
    }

    public static synchronized StatisticsLogger getInstance() {
        if (instance == null) {
            instance = new StatisticsLogger();
        }
        return instance;
    }

    public void log(Run build, List<FoundFailureCause> causes) {
        if (PluginImpl.getInstance().getKnowledgeBase().isEnableStatistics()) {
            this.queueExecutor.submit(new LoggingWork(build, causes));
        }
    }

    static class LoggingWork
    implements Runnable {
        List<FoundFailureCause> causes;
        Run build;

        LoggingWork(Run build, List<FoundFailureCause> causes) {
            this.build = build;
            this.causes = causes;
        }

        @Override
        public void run() {
            AbstractBuild abstractBuild;
            Node node;
            String projectName = this.build.getParent().getFullName();
            int buildNumber = this.build.getNumber();
            String displayName = this.build.getDisplayName();
            Date startingTime = this.build.getTime();
            long duration = this.build.getDuration();
            LinkedList<String> triggerCauses = new LinkedList<String>();
            for (Object o : this.build.getCauses()) {
                triggerCauses.add(o.getClass().getSimpleName());
            }
            String nodeName = "NoNodeInformation";
            if (this.build instanceof AbstractBuild && (node = (abstractBuild = (AbstractBuild)this.build).getBuiltOn()) != null) {
                nodeName = node.getNodeName();
            }
            int timeZoneOffset = TimeZone.getDefault().getRawOffset();
            String result = "Running";
            Result buildResult = this.build.getResult();
            if (buildResult != null) {
                result = buildResult.toString();
            }
            LinkedList<FailureCauseStatistics> failureCauseStatistics = new LinkedList<FailureCauseStatistics>();
            LinkedList<String> causeIds = new LinkedList<String>();
            for (FoundFailureCause cause : this.causes) {
                FailureCauseStatistics stats = new FailureCauseStatistics(cause.getId(), cause.getIndications());
                failureCauseStatistics.add(stats);
                causeIds.add(cause.getId());
            }
            String master = BfaUtils.getMasterName();
            Cause.UpstreamCause uc = (Cause.UpstreamCause)this.build.getCause(Cause.UpstreamCause.class);
            Statistics.UpstreamCause suc = new Statistics.UpstreamCause(uc);
            Statistics obj = new Statistics(projectName, buildNumber, displayName, startingTime, duration, triggerCauses, nodeName, master, timeZoneOffset, result, suc, failureCauseStatistics);
            PluginImpl p = PluginImpl.getInstance();
            KnowledgeBase kb = p.getKnowledgeBase();
            try {
                kb.saveStatistics(obj);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Couldn't save statistics: ", e);
            }
            kb.updateLastSeen(causeIds, startingTime);
        }
    }
}

