/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.connection.ClusterConnectionMode;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.MetricsManager;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.MongoDBKnowledgeBaseCache;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimePeriod;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.mongojack.JacksonMongoCollection;
import org.mongojack.internal.MongoJackModule;

public class MongoDBKnowledgeBase
extends KnowledgeBase {
    private static final long serialVersionUID = 4984133048405390951L;
    public static final String COLLECTION_NAME = "failureCauses";
    public static final String STATISTICS_COLLECTION_NAME = "statistics";
    private static final int MONGO_DEFAULT_PORT = 27017;
    static final Bson NOT_REMOVED_QUERY_FILTER = Filters.not((Bson)Filters.exists((String)"_removed"));
    private static final Logger logger = Logger.getLogger(MongoDBKnowledgeBase.class.getName());
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SERVER_SELECTION_TIMEOUT = 5000;
    private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance().withClassLoader(MongoDBKnowledgeBase.class.getClassLoader());
    private static final ObjectMapper OBJECT_MAPPER = MongoJackModule.configure((ObjectMapper)new ObjectMapper()).setTypeFactory(TYPE_FACTORY);
    private transient MongoClient mongo;
    private transient MongoDatabase db;
    private transient JacksonMongoCollection<FailureCause> jacksonCollection;
    private transient JacksonMongoCollection<DBObject> jacksonStatisticsCollection;
    private transient MongoDBKnowledgeBaseCache cache;
    private String host;
    private int port;
    private String dbName;
    private String userName;
    private Secret password;
    private boolean enableStatistics;
    private boolean successfulLogging;
    private boolean tls;

    public String getUserName() {
        return this.userName;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isTls() {
        return this.tls;
    }

    @DataBoundSetter
    public void setTls(boolean tls) {
        this.tls = tls;
    }

    @DataBoundConstructor
    public MongoDBKnowledgeBase(String host, int port, String dbName, String userName, Secret password, boolean enableStatistics, boolean successfulLogging) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.password = password;
        this.enableStatistics = enableStatistics;
        this.successfulLogging = successfulLogging;
    }

    @Override
    public synchronized void start() {
        this.initCache();
        this.cache.updateCache();
        for (FailureCause entry : this.getCauseNames()) {
            MetricsManager.addMetric(entry);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    private void initCache() {
        if (this.cache == null) {
            this.cache = new MongoDBKnowledgeBaseCache(this.getJacksonCollection());
            this.cache.start();
        }
    }

    @Override
    public Collection<FailureCause> getCauses() {
        this.initCache();
        return this.cache.getCauses();
    }

    @Override
    public Collection<FailureCause> getCauseNames() {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        FindIterable dbCauses = this.getJacksonCollection().find(NOT_REMOVED_QUERY_FILTER);
        MongoCursor iterator = dbCauses.iterator();
        while (iterator.hasNext()) {
            list.add((FailureCause)iterator.next());
        }
        return list;
    }

    @Override
    public Collection<FailureCause> getShallowCauses() {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        keys.put("description", (Object)1);
        keys.put("categories", (Object)1);
        keys.put("comment", (Object)1);
        keys.put("modifications", (Object)1);
        keys.put("lastOccurred", (Object)1);
        BasicDBObject orderBy = new BasicDBObject("name", (Object)1);
        FindIterable dbCauses = this.getJacksonCollection().find(NOT_REMOVED_QUERY_FILTER);
        dbCauses.sort((Bson)orderBy);
        MongoCursor iterator = dbCauses.iterator();
        while (iterator.hasNext()) {
            list.add((FailureCause)iterator.next());
        }
        return list;
    }

    @Override
    public FailureCause getCause(String id) {
        FailureCause returnCase = null;
        try {
            returnCase = (FailureCause)this.getJacksonCollection().findOneById((Object)id);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Could not find the id, returning null for id: " + id);
            return returnCase;
        }
        return returnCase;
    }

    @Override
    public FailureCause addCause(FailureCause cause) {
        return this.addCause(cause, true);
    }

    @Override
    public FailureCause removeCause(String id) {
        BasicDBObject removedInfo = new BasicDBObject("timestamp", (Object)new Date());
        removedInfo.put((Object)"by", (Object)Jenkins.getAuthentication().getName());
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("_removed", (Object)removedInfo));
        this.getJacksonCollection().updateById((Object)id, (Bson)update);
        FailureCause modifiedFailureCause = (FailureCause)this.getJacksonCollection().findOneById((Object)id);
        this.initCache();
        this.cache.updateCache();
        return modifiedFailureCause;
    }

    public FailureCause addCause(FailureCause cause, boolean doUpdate) {
        return this.saveCause(cause, doUpdate);
    }

    @Override
    public FailureCause saveCause(FailureCause cause) {
        MetricsManager.addMetric(cause);
        return this.saveCause(cause, true);
    }

    public FailureCause saveCause(FailureCause cause, boolean doUpdate) {
        UpdateResult result = this.getJacksonCollection().save((Object)cause);
        if (doUpdate) {
            this.initCache();
            this.cache.updateCache();
        }
        BsonValue upsertedId = result.getUpsertedId();
        FailureCause modifiedFailureCause = (FailureCause)this.getJacksonCollection().find(Filters.eq((String)"_id", (Object)upsertedId)).first();
        return modifiedFailureCause;
    }

    @Override
    public void convertFrom(KnowledgeBase oldKnowledgeBase) throws Exception {
        if (oldKnowledgeBase instanceof MongoDBKnowledgeBase) {
            this.convertFromAbstract(oldKnowledgeBase);
            this.convertRemoved((MongoDBKnowledgeBase)oldKnowledgeBase);
        } else {
            for (FailureCause cause : oldKnowledgeBase.getCauseNames()) {
                try {
                    if (this.getCause(cause.getId()) != null) {
                        this.saveCause(cause, false);
                        continue;
                    }
                    cause.setId(null);
                    this.addCause(cause, false);
                }
                catch (MongoException e) {
                    cause.setId(null);
                    this.addCause(cause, false);
                }
            }
            this.initCache();
            this.cache.updateCache();
        }
    }

    @Override
    public List<String> getCategories() {
        this.initCache();
        return this.cache.getCategories();
    }

    protected void convertRemoved(MongoDBKnowledgeBase oldKnowledgeBase) throws Exception {
        List<FailureCause> removed = oldKnowledgeBase.getRemovedCauses();
        for (FailureCause fc : removed) {
            this.getJacksonCollection().save((Object)fc);
        }
    }

    protected List<FailureCause> getRemovedCauses() throws Exception {
        BasicDBObject query = new BasicDBObject("_removed", (Object)new BasicDBObject("$exists", (Object)true));
        FindIterable causes = this.getJacksonCollection().find((Bson)query);
        LinkedList<FailureCause> removed = new LinkedList<FailureCause>();
        while (causes.iterator().hasNext()) {
            removed.add((FailureCause)causes.iterator().next());
        }
        return removed;
    }

    @Override
    public boolean equals(KnowledgeBase oldKnowledgeBase) {
        if (this.getClass().isInstance(oldKnowledgeBase)) {
            MongoDBKnowledgeBase oldMongoDBKnowledgeBase = (MongoDBKnowledgeBase)oldKnowledgeBase;
            return MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getHost(), this.host) && oldMongoDBKnowledgeBase.getPort() == this.port && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getDbName(), this.dbName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getUserName(), this.userName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getPassword(), this.password) && this.tls == oldMongoDBKnowledgeBase.tls && this.enableStatistics == oldMongoDBKnowledgeBase.enableStatistics && this.successfulLogging == oldMongoDBKnowledgeBase.successfulLogging;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof KnowledgeBase) {
            return this.equals((KnowledgeBase)other);
        }
        return false;
    }

    public static boolean equals(Object firstObject, Object secondObject) {
        if (firstObject == null) {
            return secondObject == null;
        }
        if (secondObject == null) {
            return false;
        }
        return secondObject.equals(firstObject);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    @Override
    public boolean isSuccessfulLogging() {
        return this.successfulLogging;
    }

    @Override
    public void saveStatistics(Statistics stat) {
        BasicDBObject object = new BasicDBObject();
        object.put("projectName", (Object)stat.getProjectName());
        object.put("buildNumber", (Object)stat.getBuildNumber());
        object.put("displayName", (Object)stat.getDisplayName());
        object.put("master", (Object)stat.getMaster());
        object.put("slaveHostName", (Object)stat.getSlaveHostName());
        object.put("startingTime", (Object)stat.getStartingTime());
        object.put("duration", (Object)stat.getDuration());
        object.put("timeZoneOffset", (Object)stat.getTimeZoneOffset());
        object.put("triggerCauses", stat.getTriggerCauses());
        BasicDBObject cause = null;
        if (stat.getUpstreamCause() != null) {
            cause = new BasicDBObject();
            Statistics.UpstreamCause upstreamCause = stat.getUpstreamCause();
            cause.put("project", (Object)upstreamCause.getUpstreamProject());
            cause.put("build", (Object)upstreamCause.getUpstreamBuild());
        }
        object.put("upstreamCause", (Object)cause);
        object.put("result", (Object)stat.getResult());
        List<FailureCauseStatistics> failureCauseStatisticsList = stat.getFailureCauseStatisticsList();
        this.addFailureCausesToDBObject((DBObject)object, failureCauseStatisticsList);
        this.getJacksonStatisticsCollection().insert((Object[])new DBObject[]{object});
    }

    @Override
    public Date getLatestFailureForCause(String id) {
        try {
            BasicDBObject match = new BasicDBObject("failureCauses.failureCause.$id", (Object)new ObjectId(id));
            FindIterable output = this.getJacksonStatisticsCollection().find((Bson)match).sort((Bson)new BasicDBObject("startingTime", (Object)-1)).limit(1);
            for (DBObject result : output) {
                Date startingTime = (Date)result.get("startingTime");
                if (startingTime == null) continue;
                return startingTime;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting latest failure of cause", e);
        }
        return null;
    }

    @Override
    public Date getCreationDateForCause(String id) {
        Date creationDate;
        try {
            creationDate = new ObjectId(id).getDate();
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Could not retrieve original modification", e);
            creationDate = new Date(0L);
        }
        return creationDate;
    }

    @Override
    public void updateLastSeen(List<String> ids, Date seen) {
        BasicDBObject set = new BasicDBObject("$set", (Object)new BasicDBObject("lastOccurred", (Object)seen));
        for (String id : ids) {
            this.getJacksonCollection().updateById((Object)id, (Bson)set);
        }
    }

    private static void putNonNullStringValue(DBObject dbObject, String key, String value) {
        if (value != null) {
            dbObject.put(key, (Object)value);
        }
    }

    private static void putNonNullBasicDBObject(DBObject dbObject, String key, String operator, Object value) {
        if (value != null) {
            dbObject.put(key, (Object)new BasicDBObject(operator, value));
        }
    }

    private DBObject generateTimeGrouping(int intervalSize) {
        BasicDBObject timeFields = new BasicDBObject();
        if (intervalSize == 11) {
            timeFields.put("hour", (Object)new BasicDBObject("$hour", (Object)"$startingTime"));
        }
        if (intervalSize == 11 || intervalSize == 5) {
            timeFields.put("dayOfMonth", (Object)new BasicDBObject("$dayOfMonth", (Object)"$startingTime"));
        }
        timeFields.put("month", (Object)new BasicDBObject("$month", (Object)"$startingTime"));
        timeFields.put("year", (Object)new BasicDBObject("$year", (Object)"$startingTime"));
        return timeFields;
    }

    private TimePeriod generateTimePeriodFromResult(DBObject result, int intervalSize) {
        Month period;
        BasicDBObject groupedAttrs = (BasicDBObject)result.get("_id");
        int month = groupedAttrs.getInt("month");
        int year = groupedAttrs.getInt("year");
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.setTimeZone(new SimpleTimeZone(0, "UTC"));
        if (intervalSize == 11) {
            int dayOfMonth = groupedAttrs.getInt("dayOfMonth");
            c.set(5, dayOfMonth);
            int hour = groupedAttrs.getInt("hour");
            c.set(11, hour);
            period = new Hour(c.getTime());
        } else if (intervalSize == 5) {
            int dayOfMonth = groupedAttrs.getInt("dayOfMonth");
            c.set(5, dayOfMonth);
            period = new Day(c.getTime());
        } else {
            period = new Month(c.getTime());
        }
        return period;
    }

    @Override
    public void removeBuildfailurecause(Run build) {
        BasicDBObject searchObj = new BasicDBObject();
        searchObj.put((Object)"projectName", (Object)build.getParent().getFullName());
        searchObj.put((Object)"buildNumber", (Object)build.getNumber());
        searchObj.put((Object)"master", (Object)BfaUtils.getMasterName());
        this.getJacksonStatisticsCollection().getMongoCollection().deleteMany((Bson)searchObj);
    }

    private void addFailureCausesToDBObject(DBObject object, List<FailureCauseStatistics> failureCauseStatisticsList) {
        if (failureCauseStatisticsList != null && !failureCauseStatisticsList.isEmpty()) {
            LinkedList<BasicDBObject> failureCauseStatisticsObjects = new LinkedList<BasicDBObject>();
            for (FailureCauseStatistics failureCauseStatistics : failureCauseStatisticsList) {
                BasicDBObject failureCauseStatisticsObject = new BasicDBObject();
                ObjectId id = new ObjectId(failureCauseStatistics.getId());
                DBRef failureCauseRef = new DBRef(this.dbName, COLLECTION_NAME, (Object)id);
                failureCauseStatisticsObject.put("failureCause", (Object)failureCauseRef);
                List<FoundIndication> foundIndicationList = failureCauseStatistics.getIndications();
                this.addIndicationsToDBObject((DBObject)failureCauseStatisticsObject, foundIndicationList);
                failureCauseStatisticsObjects.add(failureCauseStatisticsObject);
            }
            object.put(COLLECTION_NAME, failureCauseStatisticsObjects);
        }
    }

    private void addIndicationsToDBObject(DBObject object, List<FoundIndication> indications) {
        if (indications != null && !indications.isEmpty()) {
            LinkedList<BasicDBObject> foundIndicationObjects = new LinkedList<BasicDBObject>();
            for (FoundIndication foundIndication : indications) {
                BasicDBObject foundIndicationObject = new BasicDBObject();
                foundIndicationObject.put("pattern", (Object)foundIndication.getPattern());
                foundIndicationObject.put("matchingFile", (Object)foundIndication.getMatchingFile());
                foundIndicationObject.put("matchingString", (Object)foundIndication.getMatchingString());
                foundIndicationObject.put("matchingLine", (Object)foundIndication.getMatchingLine());
                foundIndicationObjects.add(foundIndicationObject);
            }
            object.put("indications", foundIndicationObjects);
        }
    }

    public Descriptor<KnowledgeBase> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(MongoDBKnowledgeBaseDescriptor.class);
    }

    private MongoClient getMongoConnection() {
        if (this.mongo == null) {
            StringBuilder connectionStringBuilder = new StringBuilder(this.host);
            connectionStringBuilder.append(":").append(this.port);
            MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(builder1 -> {
                LinkedList<ServerAddress> hostlist = new LinkedList<ServerAddress>();
                hostlist.add(new ServerAddress(this.host, this.port));
                builder1.hosts(hostlist).serverSelectionTimeout(5000L, TimeUnit.MILLISECONDS).mode(ClusterConnectionMode.SINGLE);
            }).applyToConnectionPoolSettings(builder15 -> {}).applyToServerSettings(builder12 -> {}).applyToSocketSettings(builder13 -> builder13.connectTimeout(5000, TimeUnit.MILLISECONDS)).applyToSslSettings(builder14 -> builder14.enabled(this.tls));
            if (this.password != null && Util.fixEmpty((String)this.password.getPlainText()) != null) {
                char[] pwd = this.password.getPlainText().toCharArray();
                MongoCredential credential = MongoCredential.createCredential((String)this.userName, (String)this.dbName, (char[])pwd);
                builder.credential(credential);
            }
            this.mongo = MongoClients.create((MongoClientSettings)builder.build());
        }
        return this.mongo;
    }

    private MongoDatabase getDb() {
        if (this.db == null) {
            this.db = this.getMongoConnection().getDatabase(this.dbName);
        }
        return this.db;
    }

    private synchronized JacksonMongoCollection<FailureCause> getJacksonCollection() {
        if (this.jacksonCollection == null) {
            this.jacksonCollection = JacksonMongoCollection.builder().withObjectMapper(OBJECT_MAPPER).build(this.getMongoConnection(), this.dbName, COLLECTION_NAME, FailureCause.class, UuidRepresentation.STANDARD);
        }
        return this.jacksonCollection;
    }

    private synchronized JacksonMongoCollection<DBObject> getJacksonStatisticsCollection() {
        if (this.jacksonStatisticsCollection == null) {
            this.jacksonStatisticsCollection = JacksonMongoCollection.builder().withObjectMapper(OBJECT_MAPPER).build(this.getMongoConnection(), this.dbName, STATISTICS_COLLECTION_NAME, DBObject.class, UuidRepresentation.STANDARD);
        }
        return this.jacksonStatisticsCollection;
    }

    @Extension
    public static class MongoDBKnowledgeBaseDescriptor
    extends KnowledgeBase.KnowledgeBaseDescriptor {
        public String getDisplayName() {
            return Messages.MongoDBKnowledgeBase_DisplayName();
        }

        public int getDefaultPort() {
            return 27017;
        }

        public FormValidation doCheckHost(@QueryParameter(value="value") String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"Please provide a host name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Host name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter(value="value") String value) {
            try {
                Long.parseLong(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please provide a port number!");
            }
        }

        public FormValidation doCheckDbName(@QueryParameter(value="value") String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please provide a database name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Database name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="port") int port, @QueryParameter(value="dbName") String dbName, @QueryParameter(value="userName") String userName, @QueryParameter(value="password") String password, @QueryParameter(value="tls") boolean tls) {
            MongoDBKnowledgeBase base = new MongoDBKnowledgeBase(host, port, dbName, userName, Secret.fromString((String)password), false, false);
            base.setTls(tls);
            try {
                BasicDBObject ping = new BasicDBObject("ping", (Object)"1");
                base.getDb().runCommand((Bson)ping);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)Messages.MongoDBKnowledgeBase_ConnectionError());
            }
            return FormValidation.ok((String)Messages.MongoDBKnowledgeBase_ConnectionOK());
        }
    }
}

