/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import com.sonyericsson.jenkins.plugins.bfa.BuildFailureScanner;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScanOnDemandTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(ScanOnDemandTask.class.getName());
    private Run build;

    public ScanOnDemandTask(Run build) {
        this.build = build;
    }

    @Override
    public void run() {
        try {
            if (this.build instanceof MatrixBuild) {
                List runs = ((MatrixBuild)this.build).getRuns();
                for (Run run : runs) {
                    if (!run.getActions(FailureCauseBuildAction.class).isEmpty() || !run.getActions(FailureCauseMatrixBuildAction.class).isEmpty() || !PluginImpl.needToAnalyze(run.getResult()) || run.getNumber() != this.build.getNumber()) continue;
                    this.scanBuild(run);
                }
                this.endMatrixBuildScan();
            } else {
                this.scanBuild(this.build);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to add a FailureScanner to " + this.build.getParent().getFullDisplayName(), e);
        }
    }

    public void endMatrixBuildScan() throws IOException {
        List runs = ((MatrixBuild)this.build).getRuns();
        LinkedList<MatrixRun> runsWithCorrectNumber = new LinkedList<MatrixRun>();
        for (MatrixRun run : runs) {
            if (run.getNumber() != this.build.getNumber()) continue;
            runsWithCorrectNumber.add(run);
        }
        this.build.addAction((Action)new FailureCauseMatrixBuildAction((MatrixBuild)this.build, runsWithCorrectNumber));
        this.build.save();
    }

    public void scanBuild(Run run) {
        File file = new File(run.getRootDir(), "com.sonyericsson.jenkins.plugins.bfa.ScanLogAction.log");
        try (FileOutputStream fos = new FileOutputStream(file, true);
             PrintStream buildLog = new PrintStream((OutputStream)fos, true, "UTF8");){
            PluginImpl.getInstance().getKnowledgeBase().removeBuildfailurecause(run);
            BuildFailureScanner.scanIfNotScanned(run, buildLog);
            run.save();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not get the causes from the knowledge base", e);
        }
    }
}

