/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.mongodb.MongoException;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.sonyericsson.jenkins.plugins.bfa.db.MongoDBKnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.Semaphore;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mongojack.JacksonMongoCollection;

public class MongoDBKnowledgeBaseCache {
    private Semaphore shouldUpdate;
    private UpdateThread updaterThread;
    private Timer timer;
    private TimerTask timerTask;
    private List<FailureCause> cachedFailureCauses;
    private List<String> categories;
    private JacksonMongoCollection<FailureCause> jacksonCollection;
    private static final long CACHE_UPDATE_INTERVAL = 60000L;
    private static final Logger logger = Logger.getLogger(MongoDBKnowledgeBase.class.getName());

    public MongoDBKnowledgeBaseCache(JacksonMongoCollection<FailureCause> jacksonCollection) {
        this.jacksonCollection = jacksonCollection;
    }

    public void start() {
        this.shouldUpdate = new Semaphore();
        this.updaterThread = new UpdateThread();
        this.updaterThread.start();
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                MongoDBKnowledgeBaseCache.this.shouldUpdate.release();
            }
        };
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, 60000L);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
        this.timerTask = null;
        this.updaterThread.stopThread();
        this.updaterThread = null;
    }

    public void updateCache() {
        if (this.shouldUpdate != null) {
            this.shouldUpdate.release();
        }
    }

    public List<FailureCause> getCauses() {
        return this.cachedFailureCauses;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    protected class UpdateThread
    extends Thread {
        private volatile boolean stop = false;

        protected UpdateThread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    MongoDBKnowledgeBaseCache.this.shouldUpdate.acquire();
                    if (this.stop) break;
                    LinkedList<Object> list = new LinkedList<Object>();
                    FindIterable dbCauses = MongoDBKnowledgeBaseCache.this.jacksonCollection.find(MongoDBKnowledgeBase.NOT_REMOVED_QUERY_FILTER);
                    MongoCursor iterator = dbCauses.iterator();
                    while (iterator.hasNext()) {
                        list.add(iterator.next());
                    }
                    MongoDBKnowledgeBaseCache.this.cachedFailureCauses = list;
                    LinkedList<Object> catList = new LinkedList<Object>();
                    DistinctIterable categoriesIterable = MongoDBKnowledgeBaseCache.this.jacksonCollection.distinct("categories", String.class);
                    MongoCursor catIterator = categoriesIterable.iterator();
                    while (catIterator.hasNext()) {
                        catList.add(catIterator.next());
                    }
                    MongoDBKnowledgeBaseCache.this.categories = catList;
                }
                catch (MongoException e) {
                    logger.log(Level.SEVERE, "MongoException caught when updating cache: ", e);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Updater thread interrupted", e);
                }
            }
        }

        protected void stopThread() {
            this.stop = true;
            MongoDBKnowledgeBaseCache.this.shouldUpdate.release();
        }
    }
}

