/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class CauseManagement
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(CauseManagement.class.getName());
    public static final String URL_NAME = "failure-cause-management";
    public static final String NEW_CAUSE_DYNAMIC_ID = "new";
    public static final String NEW_CAUSE_NAME = "New...";
    public static final String NEW_CAUSE_DESCRIPTION = "Description...";
    public static final String REQUEST_CAUSE_MANAGEMENT_ERROR = "CauseManagementError";
    public static final String SESSION_REMOVED_FAILURE_CAUSE = "removed-failureCause";
    public static final String GRAPH_PAGE_TITLE = "Global statistics";
    private static final String GRAPH_TITLE_CAUSES = "Failure causes for all nodes";
    private static final String GRAPH_TITLE_CATEGORIES = "Failures causes for all nodes grouped by categories";
    private static final String GRAPH_TITLE_UNKNOWN_PERCENTAGE = "Unknown failure causes";
    private static final String OWNER_URL = "/";

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION) || Hudson.getInstance().hasPermission(PluginImpl.VIEW_PERMISSION)) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return Messages.CauseManagement_DisplayName();
        }
        if (Hudson.getInstance().hasPermission(PluginImpl.VIEW_PERMISSION)) {
            return Messages.CauseList_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getImageUrl(String size, String name) {
        return PluginImpl.getImageUrl(size, name);
    }

    public Iterable<FailureCause> getShallowCauses() throws Exception {
        Collection<FailureCause> returnValue = null;
        try {
            returnValue = PluginImpl.getInstance().getKnowledgeBase().getShallowCauses();
        }
        catch (Exception e) {
            String message = "Could not fetch causes: " + e.getMessage();
            this.setErrorMessage(message);
            LOGGER.log(Level.SEVERE, message, e);
        }
        return returnValue;
    }

    private void setErrorMessage(String message) {
        Stapler.getCurrentRequest().setAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR, (Object)message);
    }

    public boolean isError(StaplerRequest request) {
        return Util.fixEmpty((String)((String)request.getAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR))) != null;
    }

    public String getErrorMessage(StaplerRequest request) {
        return (String)request.getAttribute(REQUEST_CAUSE_MANAGEMENT_ERROR);
    }

    public FailureCause getDynamic(String id, StaplerRequest request, StaplerResponse response) throws Exception {
        if (NEW_CAUSE_DYNAMIC_ID.equalsIgnoreCase(id)) {
            return new FailureCause(NEW_CAUSE_NAME, NEW_CAUSE_DESCRIPTION);
        }
        return PluginImpl.getInstance().getKnowledgeBase().getCause(id);
    }

    public void doRemoveConfirm(@QueryParameter String id, StaplerRequest request, StaplerResponse response) throws IOException {
        Jenkins.getInstance().checkPermission(PluginImpl.REMOVE_PERMISSION);
        id = Util.fixEmpty((String)id);
        if (id != null) {
            try {
                FailureCause cause = PluginImpl.getInstance().getKnowledgeBase().removeCause(id);
                if (cause != null) {
                    request.getSession(true).setAttribute(SESSION_REMOVED_FAILURE_CAUSE, (Object)cause);
                }
            }
            catch (Exception e) {
                throw (Failure)new Failure(e.getMessage()).initCause((Throwable)e);
            }
        }
        response.sendRedirect2("./");
    }

    public ModelObject getOwner() {
        return Hudson.getInstance();
    }

    protected String getOwnerUrl() {
        return OWNER_URL;
    }

    public ExtensionList<Indication.IndicationDescriptor> getIndicationDescriptors() {
        return Indication.IndicationDescriptor.getAll();
    }

    public Permission getPermission() {
        return PluginImpl.UPDATE_PERMISSION;
    }

    public Permission getRemovePermission() {
        return PluginImpl.REMOVE_PERMISSION;
    }

    public boolean isUnderTest() {
        return "org.jvnet.hudson.test.TestPluginManager".equals(Hudson.getInstance().getPluginManager().getClass().getName());
    }

    public static CauseManagement getInstance() {
        for (Action action : Hudson.getInstance().getActions()) {
            if (!(action instanceof CauseManagement)) continue;
            return (CauseManagement)action;
        }
        throw new IllegalStateException("We seem to not have been initialized!");
    }
}

