/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class Indication
implements Describable<Indication>,
Serializable {
    private String pattern;
    private transient Pattern compiled = null;

    @DataBoundConstructor
    @JsonCreator
    public Indication(@JsonProperty(value="pattern") String pattern) {
        this.pattern = pattern;
    }

    protected Indication() {
    }

    public abstract FailureReader getReader();

    public FormValidation validate() {
        return IndicationDescriptor.checkPattern(this.pattern);
    }

    public Pattern getPattern() {
        if (this.compiled == null) {
            this.compiled = Pattern.compile(this.pattern);
        }
        return this.compiled;
    }

    public String toString() {
        return this.pattern.toString();
    }

    @JsonIgnoreType
    public static abstract class IndicationDescriptor
    extends Descriptor<Indication> {
        public static ExtensionList<IndicationDescriptor> getAll() {
            return Hudson.getInstance().getExtensionList(IndicationDescriptor.class);
        }

        public static FormValidation checkPattern(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please provide a pattern!");
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)("Bad syntax! " + e.getMessage()));
            }
            catch (Exception e) {
                return FormValidation.warning((String)("Unpredicted error. " + e.getMessage()));
            }
        }

        public FormValidation doCheckPattern(@QueryParameter String value) {
            return IndicationDescriptor.checkPattern(value);
        }
    }
}

