/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ComputerGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ProjectGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension(ordinal=11003.0)
public class BuildFailureScanner
extends RunListener<AbstractBuild> {
    public static final int ORDINAL = 11003;
    private static final Logger logger = Logger.getLogger(BuildFailureScanner.class.getName());

    public void onStarted(AbstractBuild build, TaskListener listener) {
        if (PluginImpl.shouldScan(build) && build.getProject().getProperty(ScannerJobProperty.class) == null) {
            try {
                build.getProject().addProperty((JobProperty)new ScannerJobProperty(false));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to add a ScannerJobProperty to " + build.getProject().getFullDisplayName(), e);
                listener.getLogger().println("[BFA] WARNING! Failed to add the scanner property to this job.");
            }
        }
    }

    public void onCompleted(AbstractBuild build, TaskListener listener) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "onCompleted");
        if (PluginImpl.shouldScan(build) && !(build.getProject() instanceof MatrixProject)) {
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                BuildFailureScanner.scan(build, listener.getLogger());
                ProjectGraphAction.invalidateProjectGraphCache(build.getProject());
                ComputerGraphAction.invalidateNodeGraphCache(build.getBuiltOn());
            } else if (PluginImpl.getInstance().getKnowledgeBase().isSuccessfulLoggingEnabled()) {
                List<FoundFailureCause> emptyCauseList = Collections.synchronizedList(new LinkedList());
                StatisticsLogger.getInstance().log(build, emptyCauseList);
            }
        }
    }

    public static void scan(AbstractBuild build, PrintStream buildLog) {
        try {
            Collection<FailureCause> causes = PluginImpl.getInstance().getKnowledgeBase().getCauses();
            List<FoundFailureCause> foundCauseList = BuildFailureScanner.findCauses(causes, build, buildLog);
            FailureCauseBuildAction buildAction = new FailureCauseBuildAction(foundCauseList);
            buildAction.setBuild(build);
            build.addAction((Action)buildAction);
            StatisticsLogger.getInstance().log(build, foundCauseList);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not scan build " + build, e);
        }
    }

    private static List<FoundFailureCause> findCauses(Collection<FailureCause> causes, final AbstractBuild build, final PrintStream buildLog) {
        final List<FoundFailureCause> foundFailureCauseList = Collections.synchronizedList(new LinkedList());
        long start = System.currentTimeMillis();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(PluginImpl.getInstance().getNrOfScanThreads());
        buildLog.println("[BFA] Scanning build for known causes...");
        for (final FailureCause cause : causes) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    List foundIndications = BuildFailureScanner.findIndications(cause, build, buildLog);
                    if (!foundIndications.isEmpty()) {
                        FoundFailureCause foundFailureCause = new FoundFailureCause(cause);
                        foundFailureCause.addIndications(foundIndications);
                        foundFailureCauseList.add(foundFailureCause);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                buildLog.print('.');
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, "Got interrupted while waiting for scanner threads to finish for {0}", build.getFullDisplayName());
            buildLog.println("[BFA] Interrupted.");
        }
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] {1}ms", new Object[]{build.getFullDisplayName(), String.valueOf(time)});
        }
        buildLog.println();
        buildLog.println("[BFA] Done. " + TimeUnit.MILLISECONDS.toSeconds(time) + "s");
        return foundFailureCauseList;
    }

    private static List<FoundIndication> findIndications(FailureCause cause, AbstractBuild build, PrintStream buildLog) {
        long start = System.currentTimeMillis();
        List<Indication> indicationList = cause.getIndications();
        LinkedList<FoundIndication> foundIndicationList = new LinkedList<FoundIndication>();
        for (Indication indication : indicationList) {
            FoundIndication foundIndication = BuildFailureScanner.findIndication(indication, build, buildLog);
            if (foundIndication == null) continue;
            foundIndicationList.add(foundIndication);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] [{1}] {2}ms", new Object[]{build.getFullDisplayName(), cause.getName(), String.valueOf(System.currentTimeMillis() - start)});
        }
        return foundIndicationList;
    }

    private static FoundIndication findIndication(Indication indication, AbstractBuild build, PrintStream buildLog) {
        FailureReader failureReader = indication.getReader();
        return failureReader.scan(build, buildLog);
    }
}

