/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.codehaus.jackson.annotate.JsonIgnoreType;

@JsonIgnoreType
public abstract class FailureReader {
    private static final Logger logger = Logger.getLogger(FailureReader.class.getName());
    private static final long TIMEOUT_FILE = 10000L;
    private static final long TIMEOUT_LINE = 1000L;
    private static final long SLEEPTIME = 200L;
    private static final int SCAN_HORIZON = 10000;
    protected Indication indication;

    public FailureReader(Indication indication) {
        this.indication = indication;
    }

    public abstract FoundIndication scan(AbstractBuild var1) throws IOException;

    public abstract FoundIndication scan(AbstractBuild var1, PrintStream var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoundIndication scanOneFile(AbstractBuild build, BufferedReader reader, String currentFile) throws IOException {
        TimerThread timerThread = new TimerThread(Thread.currentThread(), 1000L);
        FoundIndication foundIndication = null;
        boolean found = false;
        Pattern pattern = this.indication.getPattern();
        int currentLine = 1;
        timerThread.start();
        try {
            String line;
            long startTime = System.currentTimeMillis();
            while ((line = reader.readLine()) != null) {
                try {
                    if (pattern.matcher(new InterruptibleCharSequence(line)).matches()) {
                        found = true;
                        break;
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        logger.warning("Timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile + ":" + currentLine);
                    }
                    throw e;
                }
                ++currentLine;
                timerThread.touch();
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                logger.warning("File timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                break;
            }
            if (found) {
                String cleanLine = ConsoleNote.removeNotes((String)line);
                foundIndication = new FoundIndication(build, pattern.toString(), currentFile, cleanLine);
            }
            FoundIndication foundIndication2 = foundIndication;
            return foundIndication2;
        }
        finally {
            timerThread.requestStop();
            timerThread.interrupt();
            try {
                timerThread.join();
            }
            catch (InterruptedException eIgnore) {}
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoundIndication scanMultiLineOneFile(AbstractBuild build, BufferedReader reader, String currentFile) throws IOException {
        TimerThread timerThread = new TimerThread(Thread.currentThread(), 1000L);
        FoundIndication foundIndication = null;
        boolean found = false;
        Pattern pattern = Pattern.compile("^[\r\n]*?" + this.indication.getPattern().pattern() + "[^\r\n]*?$", 40);
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(Pattern.compile("[\\r\\n]+"));
        String firstLine = "";
        timerThread.start();
        try {
            long startTime = System.currentTimeMillis();
            while (scanner.hasNext()) {
                try {
                    String lines = scanner.findWithinHorizon(pattern, 10000);
                    if (lines != null) {
                        StringTokenizer tokenizer = new StringTokenizer(lines);
                        firstLine = tokenizer.nextToken("\n\r\f");
                        found = true;
                        break;
                    }
                    scanner.next();
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        logger.warning("Timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                    }
                    throw e;
                }
                timerThread.touch();
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                logger.warning("File timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                break;
            }
            if (found) {
                String cleanLine = ConsoleNote.removeNotes((String)firstLine);
                foundIndication = new FoundIndication(build, pattern.toString(), currentFile, cleanLine);
            }
            FoundIndication foundIndication2 = foundIndication;
            return foundIndication2;
        }
        finally {
            timerThread.requestStop();
            timerThread.interrupt();
            try {
                timerThread.join();
            }
            catch (InterruptedException eIgnore) {}
            Thread.interrupted();
        }
    }

    static class TimerThread
    extends Thread {
        private Thread monitorThread;
        private boolean stop = false;
        private long timeout;
        private long lastTouched;

        TimerThread(Thread monitorThread, long timeout) {
            this.monitorThread = monitorThread;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            this.lastTouched = System.currentTimeMillis();
            while (!this.stop) {
                try {
                    Thread.sleep(200L);
                    if (System.currentTimeMillis() - this.lastTouched < this.timeout) continue;
                    this.monitorThread.interrupt();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void touch() {
            this.lastTouched = System.currentTimeMillis();
        }

        public void requestStop() {
            this.stop = true;
        }
    }

    public static class InterruptibleCharSequence
    implements CharSequence {
        CharSequence inner;

        public InterruptibleCharSequence(CharSequence inner) {
            this.inner = ((Object)inner).toString();
        }

        @Override
        public char charAt(int index) {
            if (Thread.interrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new InterruptibleCharSequence(this.inner.subSequence(start, end));
        }

        @Override
        public String toString() {
            return ((Object)this.inner).toString();
        }
    }
}

