/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import java.util.LinkedList;
import java.util.List;

public class FailureCauseMatrixAggregator
extends MatrixAggregator {
    public FailureCauseMatrixAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        super(build, launcher, listener);
    }

    public boolean endBuild() {
        if (PluginImpl.shouldScan((AbstractBuild)this.build) && this.build.getResult().isWorseThan(Result.SUCCESS)) {
            List<MatrixRun> runsWithCorrectNumber = FailureCauseMatrixAggregator.getRuns(this.build);
            this.build.addAction((Action)new FailureCauseMatrixBuildAction(this.build, runsWithCorrectNumber));
        }
        return true;
    }

    public static List<MatrixRun> getRuns(MatrixBuild matrixBuild) {
        List runs = matrixBuild.getRuns();
        LinkedList<MatrixRun> runsWithCorrectNumber = new LinkedList<MatrixRun>();
        for (MatrixRun run : runs) {
            if (run.getNumber() != matrixBuild.getNumber()) continue;
            runsWithCorrectNumber.add(run);
        }
        return runsWithCorrectNumber;
    }
}

