/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.AnnotationHelper;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndicationAnnotator
extends ConsoleAnnotator<Object> {
    private int currentLine;
    private static final int CONTEXT = 10;
    private Map<Integer, AnnotationHelper> helperMap = new HashMap<Integer, AnnotationHelper>();

    public IndicationAnnotator(List<FoundFailureCause> foundFailureCauses) {
        for (FoundFailureCause foundFailureCause : foundFailureCauses) {
            this.addToHelperMap(foundFailureCause);
        }
        this.currentLine = 0;
    }

    private void addToHelperMap(FoundFailureCause cause) {
        for (FoundIndication indication : cause.getIndications()) {
            AnnotationHelper matchingHelper;
            int matchingLine = indication.getMatchingLine();
            int focusLine = matchingLine - 10;
            if (focusLine < 1) {
                focusLine = 1;
            }
            if ((matchingHelper = this.helperMap.get(matchingLine)) == null) {
                matchingHelper = new AnnotationHelper();
                matchingHelper.addAfter("</span>");
            }
            matchingHelper.addTitle(cause.getName());
            this.helperMap.put(matchingLine, matchingHelper);
            AnnotationHelper focusHelper = this.helperMap.get(focusLine);
            if (focusHelper == null) {
                focusHelper = new AnnotationHelper();
            }
            focusHelper.addFocus(matchingLine + cause.getId());
            focusHelper.addAfter("</span>");
            this.helperMap.put(focusLine, focusHelper);
        }
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text) {
        ++this.currentLine;
        AnnotationHelper match = this.helperMap.get(this.currentLine);
        if (match != null) {
            text.wrapBy(match.getBefore(), match.getAfter());
        }
        return this;
    }
}

