/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sonyericsson.jenkins.plugins.bfa.utils.OldDataConverter;
import hudson.model.Run;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FoundIndication {
    protected static final String FILE_ENCODING = System.getProperty("file.encoding");
    private String matchingFile;
    private String pattern;
    private Run build;
    private String matchingString;
    private Integer matchingLine;

    @Deprecated
    public FoundIndication(Run build, String originalPattern, String matchingFile, String matchingString) {
        this(build, originalPattern, matchingFile, matchingString, -1);
    }

    @Deprecated
    public FoundIndication(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="matchingFile") String matchingFile, @JsonProperty(value="matchingString") String matchingString) {
        this(pattern, matchingFile, matchingString, -1);
    }

    public FoundIndication(Run build, String originalPattern, String matchingFile, String matchingString, Integer matchingLine) {
        this.pattern = originalPattern;
        this.matchingFile = matchingFile;
        this.build = build;
        this.matchingString = matchingString;
        this.matchingLine = matchingLine;
    }

    @JsonCreator
    public FoundIndication(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="matchingFile") String matchingFile, @JsonProperty(value="matchingString") String matchingString, @JsonProperty(value="matchingLine") Integer matchingLine) {
        this.pattern = pattern;
        this.matchingFile = matchingFile;
        this.matchingString = matchingString;
        this.matchingLine = matchingLine;
    }

    public String getMatchingFile() {
        return this.matchingFile;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Run getBuild() {
        return this.build;
    }

    public String getMatchingString() {
        return this.matchingString;
    }

    public String getFirstMatchingLine() {
        try (Scanner scanner = new Scanner(this.matchingString);){
            scanner.useDelimiter(Pattern.compile("[\\n\\r]"));
            String string = scanner.next();
            return string;
        }
    }

    public void convertFromLineNumber(List<String> log) {
        if (this.matchingLine != null && log.size() >= this.matchingLine) {
            this.matchingString = log.get(Math.max(0, this.matchingLine - 1));
        }
    }

    public Object readResolve() {
        if (this.matchingLine != null && (this.matchingString == null || this.matchingString.isEmpty())) {
            OldDataConverter.getInstance().convertFoundIndications(this.build);
        }
        return this;
    }

    public int getMatchingLine() {
        if (this.matchingLine != null) {
            return this.matchingLine;
        }
        return -1;
    }

    public int getMatchingHash() {
        if (this.matchingString != null) {
            return this.matchingString.hashCode();
        }
        return 0;
    }
}

