/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.BuildLogFailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class", visible=true)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildLogIndication
extends Indication {
    private static final long serialVersionUID = -2889792693081908532L;
    private transient Pattern compiled = null;

    @JsonCreator
    @DataBoundConstructor
    public BuildLogIndication(@JsonProperty(value="pattern") String pattern) {
        super(pattern);
    }

    @Override
    @JsonIgnore
    public FailureReader getReader() {
        return new BuildLogFailureReader(this);
    }

    @Override
    @JsonIgnore
    public Pattern getPattern() {
        if (this.compiled == null) {
            this.compiled = Pattern.compile(this.getUserProvidedExpression());
        }
        return this.compiled;
    }

    @JsonIgnore
    public Indication.IndicationDescriptor getDescriptor() {
        return (Indication.IndicationDescriptor)Hudson.getInstance().getDescriptorByType(BuildLogIndicationDescriptor.class);
    }

    @Extension
    public static class BuildLogIndicationDescriptor
    extends Indication.IndicationDescriptor {
        private static final Pattern URL_PATTERN = Pattern.compile("^(.*/)([^/]+)/([^/]+)/([^/]+)/?$");
        private static final int NUM_OF_URL_PARTS = 4;

        public String getDisplayName() {
            return Messages.BuildLogIndication_DisplayName();
        }

        @RequirePOST
        public FormValidation doMatchText(@QueryParameter(value="pattern") String testPattern, @QueryParameter(value="testText") String testText, @QueryParameter(value="textSourceIsUrl") boolean textSourceIsUrl) {
            Jenkins.get().checkPermission(PluginImpl.UPDATE_PERMISSION);
            if (textSourceIsUrl) {
                Matcher urlMatcher = URL_PATTERN.matcher(testText = testText.replaceAll("/\\./", "/").replaceAll("/view/change-requests", ""));
                if (urlMatcher.matches()) {
                    Jenkins getItemInstance;
                    String[] urlParts = new String[4];
                    for (int i = 0; i < urlParts.length; ++i) {
                        urlParts[i] = urlMatcher.group(i + 1);
                    }
                    Run build = null;
                    if (urlParts[0].split("/job/").length > 1) {
                        String[] jobParts;
                        StringBuilder fullFolderName = new StringBuilder();
                        String[] interestingJobParts = urlParts[0].split("/job/", 2);
                        for (String part : jobParts = interestingJobParts[interestingJobParts.length - 1].split("/job/")) {
                            fullFolderName.append("/").append(part);
                        }
                        getItemInstance = (ItemGroup)Jenkins.getInstance().getItemByFullName(fullFolderName.toString());
                    } else {
                        getItemInstance = Jenkins.getInstance();
                    }
                    if (getItemInstance == null) {
                        throw new AssertionError((Object)"Folder not found!");
                    }
                    Item itemFromPart2 = getItemInstance.getItem(urlParts[2]);
                    if (itemFromPart2 instanceof Job && this.isValidBuildId(urlParts[3])) {
                        Job project = (Job)itemFromPart2;
                        build = this.getBuildById(project, urlParts[3]);
                    } else {
                        MatrixConfiguration configuration;
                        Item itemFromPart1 = getItemInstance.getItem(urlParts[1]);
                        if (itemFromPart1 instanceof MatrixProject && this.isValidBuildId(urlParts[3])) {
                            MatrixProject project = (MatrixProject)itemFromPart1;
                            configuration = project.getItem(urlParts[2]);
                            build = this.getBuildById((Job<? extends Job<?, ?>, ? extends Run<?, ?>>)configuration, urlParts[3]);
                        } else if (itemFromPart1 instanceof MatrixProject && this.isValidBuildId(urlParts[2])) {
                            MatrixProject matrixProject = (MatrixProject)itemFromPart1;
                            configuration = matrixProject.getItem(urlParts[3]);
                            build = this.getBuildById((Job<? extends Job<?, ?>, ? extends Run<?, ?>>)configuration, urlParts[2]);
                        }
                    }
                    if (build != null) {
                        try {
                            FailureReader failureReader = this.getFailureReader(testPattern);
                            FoundIndication foundIndication = failureReader.scan(build);
                            if (foundIndication == null) {
                                return FormValidation.warning((String)Messages.StringDoesNotMatchPattern());
                            }
                            return FormValidation.okWithMarkup((String)foundIndication.getFirstMatchingLine());
                        }
                        catch (IOException e) {
                            return FormValidation.error((String)Messages.FailedToScanFile_Error());
                        }
                    }
                }
                return FormValidation.error((String)Messages.InvalidURL_Error());
            }
            try {
                Pattern pattern = Pattern.compile(testPattern);
                Matcher matcher = pattern.matcher(new FailureReader.InterruptibleCharSequence(testText));
                if (matcher.matches()) {
                    return FormValidation.ok((String)Messages.StringMatchesPattern());
                }
                return FormValidation.warning((String)Messages.StringDoesNotMatchPattern());
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)Messages.InvalidPattern_Error());
            }
        }

        private boolean isValidBuildId(String id) {
            return id.matches("\\d+") || StringBuildId.fromString(id) != null;
        }

        private Run getBuildById(Job<? extends Job<?, ?>, ? extends Run<?, ?>> project, String id) {
            if (id.matches("\\d+")) {
                return project.getBuildByNumber(Integer.parseInt(id));
            }
            StringBuildId stringBuildId = StringBuildId.fromString(id);
            if (stringBuildId != null) {
                return stringBuildId.getBuild(project);
            }
            return null;
        }

        protected FailureReader getFailureReader(String testPattern) {
            return new BuildLogFailureReader(new BuildLogIndication(testPattern));
        }

        public static enum StringBuildId {
            LAST_BUILD("lastBuild"){

                @Override
                public Run getBuild(Job<? extends Job<?, ?>, ? extends Run<?, ?>> project) {
                    return project.getLastBuild();
                }
            }
            ,
            LAST_FAILED_BUILD("lastFailedBuild"){

                @Override
                public Run getBuild(Job<? extends Job<?, ?>, ? extends Run<?, ?>> project) {
                    return project.getLastFailedBuild();
                }
            }
            ,
            LAST_UNSUCCESSFUL_BUILD("lastUnsuccessfulBuild"){

                @Override
                public Run getBuild(Job<? extends Job<?, ?>, ? extends Run<?, ?>> project) {
                    return project.getLastUnsuccessfulBuild();
                }
            }
            ,
            LAST_SUCCESSFUL_BUILD("lastSuccessfulBuild"){

                @Override
                public Run getBuild(Job<? extends Job<?, ?>, ? extends Run<?, ?>> project) {
                    return project.getLastSuccessfulBuild();
                }
            };

            private final String name;

            private StringBuildId(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static StringBuildId fromString(String str) {
                if (str != null) {
                    for (StringBuildId stringBuildId : StringBuildId.values()) {
                        if (!str.equals(stringBuildId.getName())) continue;
                        return stringBuildId;
                    }
                }
                return null;
            }

            public abstract Run getBuild(Job<? extends Job<?, ?>, ? extends Run<?, ?>> var1);
        }
    }
}

