/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.Graph;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;

public abstract class BFAGraph
extends Graph {
    protected Job project;
    protected GraphFilterBuilder filter;
    protected String graphTitle;
    protected static final int MAX_GRAPH_ELEMENTS = 10;
    protected static final String GRAPH_OTHERS = "Others";
    protected static final String GRAPH_UNCATEGORIZED = "Uncategorized";
    protected static final String GRAPH_UNKNOWN = "Unknown";
    public static final int MAX_YEARS_FOR_TIME_GRAPH = 3;

    protected BFAGraph(long timestamp, int defaultW, int defaultH, Job project, GraphFilterBuilder filter, String graphTitle) {
        super(timestamp, defaultW, defaultH);
        this.project = project;
        this.filter = filter;
        this.graphTitle = graphTitle;
    }

    public static List<Integer> getBuildNumbers(Job project) {
        RunList runList;
        ArrayList<Integer> buildNumbers = new ArrayList<Integer>();
        if (project != null && (runList = project.getBuilds()) != null) {
            for (Run currentRun : runList) {
                if (currentRun == null) continue;
                buildNumbers.add(currentRun.getNumber());
            }
        }
        return buildNumbers;
    }
}

