/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BFAGraph;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.utils.ObjectCountPair;
import hudson.model.Job;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart
extends BFAGraph {
    private boolean byCategories;

    public PieChart(long timestamp, int defaultW, int defaultH, Job project, GraphFilterBuilder filter, String graphTitle, boolean byCategories) {
        super(timestamp, defaultW, defaultH, project, filter, graphTitle);
        this.byCategories = byCategories;
    }

    protected JFreeChart createGraph() {
        PieDataset dataset = this.createDataset();
        return ChartFactory.createPieChart((String)this.graphTitle, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
    }

    private PieDataset createDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        KnowledgeBase knowledgeBase = PluginImpl.getInstance().getKnowledgeBase();
        List<ObjectCountPair<String>> nbrOfFailureCauses = this.byCategories ? knowledgeBase.getNbrOfFailureCategoriesPerName(this.filter, -1) : knowledgeBase.getFailureCauseNames(this.filter);
        if (nbrOfFailureCauses != null) {
            int othersCount = 0;
            for (int i = 0; i < nbrOfFailureCauses.size(); ++i) {
                ObjectCountPair<String> countPair = nbrOfFailureCauses.get(i);
                if (i < 10) {
                    if (countPair.getObject() == null) continue;
                    dataset.setValue((Comparable)((Object)countPair.getObject()), (double)countPair.getCount());
                    continue;
                }
                othersCount += countPair.getCount();
            }
            if (othersCount > 0) {
                dataset.setValue((Comparable)((Object)"Others"), (double)othersCount);
            }
        }
        return dataset;
    }
}

