/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.LocalFileKnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandQueue;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandVariables;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.Terminator;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.util.CopyOnWriteList;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"buildFailureAnalyzer"})
public class PluginImpl
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(PluginImpl.class.getName());
    public static final String DEFAULT_ICON_SIZE = "24x24";
    public static final String DEFAULT_ICON_NAME = "information.png";
    public static final int DEFAULT_NR_OF_SCAN_THREADS = 3;
    public static final int DEFAULT_MAX_LOG_SIZE = 0;
    private static final int BYTES_IN_MEGABYTE = 0x100000;
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._PermissionGroup_Title());
    public static final Permission UPDATE_PERMISSION = new Permission(PERMISSION_GROUP, "UpdateCauses", Messages._PermissionUpdate_Description(), Hudson.ADMINISTER);
    public static final Permission VIEW_PERMISSION = new Permission(PERMISSION_GROUP, "ViewCauses", Messages._PermissionView_Description(), UPDATE_PERMISSION);
    public static final Permission REMOVE_PERMISSION = new Permission(PERMISSION_GROUP, "RemoveCause", Messages._PermissionRemove_Description(), Hudson.ADMINISTER);
    private static final String DEFAULT_NO_CAUSES_MESSAGE = "No problems were identified. If you know why this problem occurred, please add a suitable Cause for it.";
    protected static final int MINIMUM_NR_OF_SCAN_THREADS = 1;
    private Boolean noCausesEnabled;
    private String noCausesMessage;
    private Boolean globalEnabled;
    private boolean doNotAnalyzeAbortedJob;
    private Boolean gerritTriggerEnabled;
    private String fallbackCategoriesAsString;
    private transient List<String> fallbackCategories;
    private transient CopyOnWriteList<FailureCause> causes;
    private KnowledgeBase knowledgeBase;
    private int nrOfScanThreads;
    private int maxLogSize;
    private Boolean graphsEnabled;
    private Boolean testResultParsingEnabled;
    private String testResultCategories;
    private ScanOnDemandVariables sodVariables = new ScanOnDemandVariables();

    @DataBoundConstructor
    public PluginImpl() {
        this.load();
    }

    protected Object readResolve() {
        if (this.sodVariables == null) {
            this.sodVariables = new ScanOnDemandVariables();
        }
        return this;
    }

    public XmlFile getConfigFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getInstance().getRootDir(), "build-failure-analyzer.xml"));
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public void start() {
        logger.finer("[BFA] Starting...");
        if (this.noCausesMessage == null) {
            this.noCausesMessage = DEFAULT_NO_CAUSES_MESSAGE;
        }
        if (this.testResultCategories == null) {
            this.testResultCategories = "";
        }
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        if (this.knowledgeBase == null) {
            if (this.causes == null) {
                this.knowledgeBase = new LocalFileKnowledgeBase();
            } else {
                this.knowledgeBase = new LocalFileKnowledgeBase(this.causes);
                this.causes = null;
            }
        }
        try {
            this.knowledgeBase.start();
            logger.fine("[BFA] Started!");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not initialize the knowledge base: ", e);
        }
    }

    @Terminator
    public void stop() {
        ScanOnDemandQueue.shutdown();
        this.knowledgeBase.stop();
    }

    public static String getStaticResourcesBase() {
        return "/plugin/build-failure-analyzer";
    }

    public ScanOnDemandVariables getSodVariables() {
        return this.sodVariables;
    }

    public static String getStaticImagesBase() {
        return PluginImpl.getStaticResourcesBase() + "/images";
    }

    public static String getImageUrl(String size, String name) {
        return PluginImpl.getStaticImagesBase() + "/" + size + "/" + name;
    }

    public static String getFullImageUrl(String size, String name) {
        return Jenkins.getInstance().getRootUrl() + PluginImpl.getImageUrl(size, name);
    }

    public static String getImageUrl(String name) {
        return PluginImpl.getImageUrl(DEFAULT_ICON_SIZE, name);
    }

    public static String getDefaultIcon() {
        return PluginImpl.getImageUrl(DEFAULT_ICON_NAME);
    }

    @Nonnull
    public static PluginImpl getInstance() {
        return (PluginImpl)((Object)ExtensionList.lookup(PluginImpl.class).get(0));
    }

    public String getNoCausesMessage() {
        return this.noCausesMessage;
    }

    public boolean isNoCausesEnabled() {
        if (this.noCausesEnabled == null) {
            return true;
        }
        return this.noCausesEnabled;
    }

    @DataBoundSetter
    public void setNoCausesEnabled(boolean noCausesEnabled) {
        this.noCausesEnabled = noCausesEnabled;
    }

    public boolean isGlobalEnabled() {
        if (this.globalEnabled == null) {
            return true;
        }
        return this.globalEnabled;
    }

    public boolean isDoNotAnalyzeAbortedJob() {
        return this.doNotAnalyzeAbortedJob;
    }

    public boolean isGraphsEnabled() {
        if (this.graphsEnabled == null || this.knowledgeBase == null) {
            return false;
        }
        return this.knowledgeBase.isEnableStatistics() && this.graphsEnabled != false;
    }

    @DataBoundSetter
    public void setGraphsEnabled(boolean graphsEnabled) {
        this.graphsEnabled = graphsEnabled;
    }

    @DataBoundSetter
    public void setNoCausesMessage(String noCausesMessage) {
        this.noCausesMessage = noCausesMessage;
    }

    @DataBoundSetter
    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    @DataBoundSetter
    public void setSodVariables(ScanOnDemandVariables sodVariables) {
        this.sodVariables = sodVariables;
    }

    @DataBoundSetter
    public void setFallbackCategoriesAsString(String categories) {
        this.fallbackCategoriesAsString = categories;
        this.fallbackCategories = categories == null ? Collections.emptyList() : Arrays.asList(Util.tokenize((String)categories));
    }

    public String getFallbackCategoriesAsString() {
        return Util.join(this.getFallbackCategories(), (String)" ");
    }

    public boolean isTestResultParsingEnabled() {
        if (this.testResultParsingEnabled == null) {
            return false;
        }
        return this.testResultParsingEnabled;
    }

    public String getTestResultCategories() {
        return this.testResultCategories;
    }

    public List<String> getFallbackCategories() {
        if (this.fallbackCategories == null) {
            this.fallbackCategories = this.fallbackCategoriesAsString == null ? Collections.emptyList() : Arrays.asList(Util.tokenize((String)this.fallbackCategoriesAsString));
        }
        return this.fallbackCategories;
    }

    @DataBoundSetter
    public void setDoNotAnalyzeAbortedJob(boolean doNotAnalyzeAbortedJob) {
        this.doNotAnalyzeAbortedJob = doNotAnalyzeAbortedJob;
    }

    @DataBoundSetter
    public void setGlobalEnabled(boolean globalEnabled) {
        this.globalEnabled = globalEnabled;
    }

    @DataBoundSetter
    public void setTestResultParsingEnabled(boolean testResultParsingEnabled) {
        this.testResultParsingEnabled = testResultParsingEnabled;
    }

    @DataBoundSetter
    public void setTestResultCategories(String testResultCategories) {
        this.testResultCategories = testResultCategories;
    }

    public boolean isGerritTriggerEnabled() {
        if (this.gerritTriggerEnabled == null) {
            return true;
        }
        return this.gerritTriggerEnabled;
    }

    @DataBoundSetter
    public void setGerritTriggerEnabled(boolean gerritTriggerEnabled) {
        this.gerritTriggerEnabled = gerritTriggerEnabled;
    }

    public int getNrOfScanThreads() {
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        return this.nrOfScanThreads;
    }

    @DataBoundSetter
    public void setNrOfScanThreads(int nrOfScanThreads) {
        if (nrOfScanThreads < 1) {
            throw new IllegalArgumentException("Minimum nrOfScanThreads is 1");
        }
        this.nrOfScanThreads = nrOfScanThreads;
    }

    @DataBoundSetter
    public void setMaxLogSize(int maxLogSize) {
        this.maxLogSize = maxLogSize;
    }

    public int getMaxLogSize() {
        if (this.maxLogSize < 0) {
            return 0;
        }
        return this.maxLogSize;
    }

    public static boolean needToAnalyze(Result result) {
        if (PluginImpl.getInstance().isDoNotAnalyzeAbortedJob()) {
            return result != Result.SUCCESS && result != Result.ABORTED;
        }
        return result != Result.SUCCESS;
    }

    public static boolean shouldScan(Run build) {
        return PluginImpl.shouldScan(build.getParent());
    }

    public static boolean isSizeInLimit(Run build) {
        return PluginImpl.getInstance().getMaxLogSize() == 0 || (long)PluginImpl.getInstance().getMaxLogSize() > build.getLogText().length() / 0x100000L;
    }

    public static boolean shouldScan(Job project) {
        if (PluginImpl.getInstance().isGlobalEnabled()) {
            ScannerJobProperty property = (ScannerJobProperty)project.getProperty(ScannerJobProperty.class);
            if (property != null) {
                return !property.isDoNotScan();
            }
            return true;
        }
        return false;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public ExtensionList<KnowledgeBase.KnowledgeBaseDescriptor> getKnowledgeBaseDescriptors() {
        return KnowledgeBase.KnowledgeBaseDescriptor.all();
    }

    public KnowledgeBase.KnowledgeBaseDescriptor getKnowledgeBaseDescriptor(String descString) {
        for (KnowledgeBase.KnowledgeBaseDescriptor desc : this.getKnowledgeBaseDescriptors()) {
            if (!((Object)((Object)desc)).getClass().toString().contains(descString)) continue;
            return desc;
        }
        return null;
    }

    public boolean configure(StaplerRequest req, JSONObject o) {
        KnowledgeBase existingKb = this.knowledgeBase;
        req.bindJSON((Object)this, o);
        if (this.knowledgeBase != null && !existingKb.equals(this.knowledgeBase)) {
            try {
                this.knowledgeBase.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not start new knowledge base, reverting ", e);
                this.knowledgeBase = existingKb;
                this.save();
                return true;
            }
            if (o.getBoolean("convertOldKb")) {
                try {
                    this.knowledgeBase.convertFrom(existingKb);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not convert knowledge base ", e);
                }
            }
            existingKb.stop();
        } else {
            this.knowledgeBase = existingKb;
        }
        this.save();
        return true;
    }

    public AutoCompletionCandidates getCategoryAutoCompletionCandidates(String prefix) {
        List<String> categories;
        Jenkins.getInstance().checkPermission(UPDATE_PERMISSION);
        try {
            categories = this.getKnowledgeBase().getCategories();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not get the categories for autocompletion", e);
            return null;
        }
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        if (categories != null) {
            for (String category : categories) {
                if (!category.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                candidates.add(category);
            }
        }
        for (String category : this.getFallbackCategories()) {
            if (!category.toLowerCase().startsWith(prefix.toLowerCase()) || candidates.getValues().contains(category)) continue;
            candidates.add(category);
        }
        return candidates;
    }

    public AutoCompletionCandidates doAutoCompleteFallbackCategoriesAsString(@QueryParameter String value) {
        return this.getCategoryAutoCompletionCandidates(value);
    }
}

