/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class LocalFileKnowledgeBase
extends KnowledgeBase {
    private Map<String, FailureCause> causes = new HashMap<String, FailureCause>();

    public LocalFileKnowledgeBase(CopyOnWriteList<FailureCause> legacyCauses) {
        this(legacyCauses.getView());
    }

    public LocalFileKnowledgeBase(Collection<FailureCause> initialCauses) {
        for (FailureCause cause : initialCauses) {
            if (Util.fixEmpty((String)cause.getId()) == null) {
                cause.setId(UUID.randomUUID().toString());
            }
            this.causes.put(cause.getId(), cause);
        }
    }

    @DataBoundConstructor
    public LocalFileKnowledgeBase() {
    }

    @Override
    public Collection<FailureCause> getCauses() {
        return this.causes.values();
    }

    @Override
    public Collection<FailureCause> getCauseNames() {
        return this.getCauses();
    }

    @Override
    public Collection<FailureCause> getShallowCauses() throws Exception {
        return this.getCauses();
    }

    @Override
    public FailureCause getCause(String id) {
        return this.causes.get(id);
    }

    @Override
    public FailureCause addCause(FailureCause cause) throws IOException {
        cause.setId(UUID.randomUUID().toString());
        this.causes.put(cause.getId(), cause);
        PluginImpl.getInstance().save();
        return cause;
    }

    @Override
    public FailureCause removeCause(String id) throws Exception {
        FailureCause remove = this.causes.remove(id);
        PluginImpl.getInstance().save();
        return remove;
    }

    @Override
    public FailureCause saveCause(FailureCause cause) throws IOException {
        if (Util.fixEmpty((String)cause.getId()) == null) {
            return this.addCause(cause);
        }
        this.causes.put(cause.getId(), cause);
        PluginImpl.getInstance().save();
        return cause;
    }

    protected void put(FailureCause cause) {
        this.causes.put(cause.getId(), cause);
    }

    @Override
    public void convertFrom(KnowledgeBase oldKnowledgeBase) throws Exception {
        if (oldKnowledgeBase instanceof LocalFileKnowledgeBase) {
            LocalFileKnowledgeBase lfkb = (LocalFileKnowledgeBase)oldKnowledgeBase;
            this.causes = lfkb.causes;
        } else {
            this.convertFromAbstract(oldKnowledgeBase);
        }
    }

    @Override
    public List<String> getCategories() throws Exception {
        if (this.causes == null) {
            return null;
        }
        LinkedList<String> categories = new LinkedList<String>();
        HashSet<String> myset = new HashSet<String>();
        for (FailureCause cause : this.causes.values()) {
            List<String> categoriesForCause = cause.getCategories();
            if (categoriesForCause == null) continue;
            for (String string : categoriesForCause) {
                if (!myset.add(string)) continue;
                categories.add(string);
            }
        }
        return categories;
    }

    @Override
    public boolean equals(KnowledgeBase oldKnowledgeBase) {
        if (this.getClass().isInstance(oldKnowledgeBase)) {
            return oldKnowledgeBase.getClass().getName().equals(this.getClass().getName());
        }
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public boolean equals(Object other) {
        if (other instanceof KnowledgeBase) {
            return this.equals((KnowledgeBase)other);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return false;
    }

    @Override
    public boolean isSuccessfulLoggingEnabled() {
        return false;
    }

    @Override
    public void saveStatistics(Statistics stat) throws Exception {
    }

    public Descriptor<KnowledgeBase> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(LocalFileKnowledgeBaseDescriptor.class);
    }

    @Override
    public void removeBuildfailurecause(Run build) throws Exception {
    }

    @Extension
    public static class LocalFileKnowledgeBaseDescriptor
    extends KnowledgeBase.KnowledgeBaseDescriptor {
        public String getDisplayName() {
            return Messages.LocalFileKnowledgeBase_DisplayName();
        }
    }
}

