/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.ScanLogAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ComputerGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ProjectGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.MultilineBuildLogIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

@Extension(ordinal=11003.0)
public class BuildFailureScanner
extends RunListener<Run> {
    public static final int ORDINAL = 11003;
    private static final Logger logger = Logger.getLogger(BuildFailureScanner.class.getName());
    private static final String LOG_FILE_NAME = "log";
    private static ThreadPoolExecutor threadPoolExecutor;

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void initThreadPool() {
        threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(PluginImpl.getInstance().getNrOfScanThreads());
    }

    public void onStarted(Run build, TaskListener listener) {
        if (PluginImpl.shouldScan(build) && build.getParent().getProperty(ScannerJobProperty.class) == null) {
            try {
                build.getParent().addProperty((JobProperty)new ScannerJobProperty(false));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to add a ScannerJobProperty to " + build.getParent().getFullDisplayName(), e);
                listener.getLogger().println("[BFA] WARNING! Failed to add the scanner property to this job.");
            }
        }
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        if (run instanceof AbstractBuild) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "onCompleted");
            this.doScan(run);
        }
    }

    public void onFinalized(Run run) {
        if (!(run instanceof AbstractBuild)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "onFinalized");
            this.doScan(run);
        }
    }

    private void doScan(Run build) {
        File file = new File(build.getRootDir(), "com.sonyericsson.jenkins.plugins.bfa.ScanLogAction.log");
        try (FileOutputStream fos = new FileOutputStream(file, true);
             PrintStream scanLog = new PrintStream((OutputStream)fos, true, "UTF8");){
            if (PluginImpl.isSizeInLimit(build)) {
                BuildFailureScanner.scanIfNotScanned(build, scanLog);
            } else {
                BuildFailureScanner.logToScanLog(scanLog, "Log exceeds limit: " + PluginImpl.getInstance().getMaxLogSize() + "MB");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not get the causes from the knowledge base", e);
        }
    }

    public static void scanIfNotScanned(Run build, PrintStream scanLog) {
        if (PluginImpl.shouldScan(build) && !(build.getParent() instanceof MatrixProject) && build.getActions(FailureCauseBuildAction.class).isEmpty() && build.getActions(FailureCauseMatrixBuildAction.class).isEmpty()) {
            if (PluginImpl.needToAnalyze(build.getResult())) {
                BuildFailureScanner.scan(build, scanLog);
                ProjectGraphAction.invalidateProjectGraphCache(build.getParent());
                if (build instanceof AbstractBuild) {
                    ComputerGraphAction.invalidateNodeGraphCache(((AbstractBuild)build).getBuiltOn());
                }
            } else if (PluginImpl.getInstance().getKnowledgeBase().isSuccessfulLoggingEnabled()) {
                List<FoundFailureCause> emptyCauseList = Collections.synchronizedList(new LinkedList());
                StatisticsLogger.getInstance().log(build, emptyCauseList);
            }
        }
    }

    public static void scan(Run build, PrintStream scanLog) {
        build.addOrReplaceAction((Action)new ScanLogAction());
        try {
            List<FoundFailureCause> foundCauseList;
            Collection<FailureCause> causes = PluginImpl.getInstance().getKnowledgeBase().getCauses();
            List<FoundFailureCause> foundCauseListToLog = BuildFailureScanner.findCauses(causes, build, scanLog);
            if (PluginImpl.getInstance().isTestResultParsingEnabled()) {
                foundCauseList = Collections.synchronizedList(new LinkedList<FoundFailureCause>(foundCauseListToLog));
                foundCauseList.addAll(BuildFailureScanner.findFailedTests(build, scanLog));
            } else {
                foundCauseList = foundCauseListToLog;
            }
            List<String> fallbackCategories = PluginImpl.getInstance().getFallbackCategories();
            if (!fallbackCategories.isEmpty()) {
                ArrayList<FoundFailureCause> foundFallbackCauses = new ArrayList<FoundFailureCause>();
                Iterator<FoundFailureCause> iterator = foundCauseList.iterator();
                while (iterator.hasNext()) {
                    FoundFailureCause cause = iterator.next();
                    if (Collections.disjoint(cause.getCategories(), fallbackCategories)) continue;
                    iterator.remove();
                    foundFallbackCauses.add(cause);
                }
                if (!foundFallbackCauses.isEmpty()) {
                    if (!foundCauseList.isEmpty()) {
                        BuildFailureScanner.logToScanLog(scanLog, "Removing generic causes");
                    } else {
                        foundCauseList = foundFallbackCauses;
                    }
                }
            }
            FailureCauseBuildAction buildAction = new FailureCauseBuildAction(foundCauseList);
            buildAction.setBuild(build);
            build.addAction((Action)buildAction);
            FailureCauseDisplayData data = buildAction.getFailureCauseDisplayData();
            List<FailureCauseDisplayData> downstreamFailureCauses = data.getDownstreamFailureCauses();
            if (!downstreamFailureCauses.isEmpty()) {
                BuildFailureScanner.logToScanLog(scanLog, "Found downstream Failure causes ...");
                BuildFailureScanner.printDownstream(scanLog, downstreamFailureCauses);
            }
            StatisticsLogger.getInstance().log(build, foundCauseListToLog);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not scan build " + build, e);
        }
    }

    private static void printDownstream(PrintStream scanLog, List<FailureCauseDisplayData> downstreamFailureCauses) {
        for (FailureCauseDisplayData displayData : downstreamFailureCauses) {
            FailureCauseDisplayData.Links links = displayData.getLinks();
            if (!displayData.getFoundFailureCauses().isEmpty()) {
                BuildFailureScanner.logToScanLog(scanLog, "See: " + Jenkins.getInstance().getRootUrl() + links.getBuildUrl());
                for (FoundFailureCause foundCause : displayData.getFoundFailureCauses()) {
                    String foundString = foundCause.getName();
                    if (foundCause.getCategories() != null) {
                        foundString = foundString + " from category " + foundCause.getCategories().get(0);
                    }
                    BuildFailureScanner.logToScanLog(scanLog, foundString);
                }
            }
            BuildFailureScanner.printDownstream(scanLog, displayData.getDownstreamFailureCauses());
        }
    }

    private static List<FoundFailureCause> findCauses(Collection<FailureCause> causes, Run build, PrintStream scanLog) {
        threadPoolExecutor.setCorePoolSize(PluginImpl.getInstance().getNrOfScanThreads());
        threadPoolExecutor.setMaximumPoolSize(PluginImpl.getInstance().getNrOfScanThreads());
        BuildFailureScanner.logToScanLog(scanLog, "Scanning build for known causes...");
        long start = System.currentTimeMillis();
        List<FoundFailureCause> foundFailureCauseList = BuildFailureScanner.findIndications(causes, build, scanLog);
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[{0}] {1}ms", new Object[]{build.getFullDisplayName(), String.valueOf(time)});
        }
        if (!foundFailureCauseList.isEmpty()) {
            BuildFailureScanner.logToScanLog(scanLog, "Found failure cause(s):");
            for (FoundFailureCause foundCause : foundFailureCauseList) {
                if (foundCause.getCategories() == null) {
                    BuildFailureScanner.logToScanLog(scanLog, foundCause.getName());
                    continue;
                }
                BuildFailureScanner.logToScanLog(scanLog, foundCause.getName() + " from category " + foundCause.getCategories().get(0));
            }
        } else {
            BuildFailureScanner.logToScanLog(scanLog, "No failure causes found");
        }
        BuildFailureScanner.logToScanLog(scanLog, "Done. " + TimeUnit.MILLISECONDS.toSeconds(time) + "s");
        return foundFailureCauseList;
    }

    private static void logToScanLog(PrintStream scanLog, String logLine) {
        scanLog.printf("%tF %<tR %s%n", new Date(), logLine);
    }

    private static List<FoundFailureCause> findIndications(Collection<FailureCause> causes, final Run build, final PrintStream scanLog) {
        final ArrayList<FailureCause> singleLineCauses = new ArrayList<FailureCause>();
        ArrayList<FailureCause> notOnlySingleLineCauses = new ArrayList<FailureCause>();
        BuildFailureScanner.splitCauses(causes, singleLineCauses, notOnlySingleLineCauses);
        ArrayList scanningTasks = new ArrayList(notOnlySingleLineCauses.size() + 1);
        final List<FoundFailureCause> foundFailureCauses = Collections.synchronizedList(new ArrayList());
        if (!singleLineCauses.isEmpty()) {
            scanningTasks.add(threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    foundFailureCauses.addAll(BuildFailureScanner.parseSingleLineCauses(build, scanLog, singleLineCauses));
                    Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName());
                }
            }));
        }
        for (final FailureCause cause : notOnlySingleLineCauses) {
            scanningTasks.add(threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ArrayList<FoundIndication> foundIndications = new ArrayList<FoundIndication>();
                    for (Indication indication : cause.getIndications()) {
                        Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName() + ": " + cause.getName() + "-" + indication.getUserProvidedExpression());
                        FoundIndication foundIndication = BuildFailureScanner.parseIndication(build, scanLog, indication, cause.getName());
                        if (foundIndication == null) continue;
                        foundIndications.add(foundIndication);
                    }
                    if (!foundIndications.isEmpty()) {
                        foundFailureCauses.add(new FoundFailureCause(cause, foundIndications));
                    }
                }
            }));
        }
        BuildFailureScanner.waitAllTasks(scanLog, scanningTasks);
        return foundFailureCauses;
    }

    private static void waitAllTasks(PrintStream scanLog, List<Future<?>> scanningTasks) {
        try {
            for (Future<?> scanningTask : scanningTasks) {
                try {
                    scanningTask.get();
                }
                catch (ExecutionException e) {
                    BuildFailureScanner.logToScanLog(scanLog, "task failed due exception: " + e);
                }
            }
        }
        catch (InterruptedException e) {
            BuildFailureScanner.logToScanLog(scanLog, "was interrupted: " + e);
            for (Future<?> scanningTask : scanningTasks) {
                scanningTask.cancel(true);
            }
            BuildFailureScanner.logToScanLog(scanLog, "all bfa tasks were cancelled");
        }
    }

    private static void splitCauses(Collection<FailureCause> causes, List<FailureCause> singleLineCauses, List<FailureCause> notOnlySingleLineCauses) {
        for (FailureCause cause : causes) {
            boolean atLeastOneNonSignalLine = false;
            for (Indication indication : cause.getIndications()) {
                if (!(indication instanceof MultilineBuildLogIndication)) continue;
                atLeastOneNonSignalLine = true;
                break;
            }
            if (atLeastOneNonSignalLine) {
                notOnlySingleLineCauses.add(cause);
                continue;
            }
            singleLineCauses.add(cause);
        }
    }

    private static FoundIndication parseIndication(Run build, PrintStream scanLog, Indication indication, String causeName) {
        long start = System.currentTimeMillis();
        FoundIndication foundIndication = BuildFailureScanner.findIndication(indication, build, scanLog);
        if (foundIndication != null && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[{0}] [{1}] {2}ms", new Object[]{build.getFullDisplayName(), causeName, String.valueOf(System.currentTimeMillis() - start)});
        }
        return foundIndication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FoundFailureCause> parseSingleLineCauses(Run build, PrintStream scanLog, List<FailureCause> singleLineCauses) {
        ArrayList<FoundFailureCause> foundFailureCauses = new ArrayList<FoundFailureCause>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(build.getLogReader());
            foundFailureCauses.addAll(FailureReader.scanSingleLinePatterns(singleLineCauses, build, reader, LOG_FILE_NAME));
        }
        catch (IOException e) {
            BuildFailureScanner.logToScanLog(scanLog, "Exception during parsing file: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
        }
        return foundFailureCauses;
    }

    private static FoundIndication findIndication(Indication indication, Run build, PrintStream scanLog) {
        FailureReader failureReader = indication.getReader();
        return failureReader.scan(build, scanLog);
    }

    private static List<FoundFailureCause> findFailedTests(Run build, PrintStream scanLog) {
        List<FoundFailureCause> failedTestList = Collections.synchronizedList(new LinkedList());
        List testActions = build.getActions(AbstractTestResultAction.class);
        for (AbstractTestResultAction testAction : testActions) {
            List failedTests = testAction.getFailedTests();
            for (TestResult test : failedTests) {
                BuildFailureScanner.logToScanLog(scanLog, "Found failed test case: " + test.getName());
                FailureCause failureCause = new FailureCause(null, test.getName(), test.getErrorStackTrace(), "", null, PluginImpl.getInstance().getTestResultCategories(), null, null);
                FoundFailureCause foundFailureCause = new FoundFailureCause(failureCause);
                failedTestList.add(foundFailureCause);
            }
        }
        return failedTestList;
    }
}

