/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FoundFailureCause {
    private String id;
    private String name;
    private String description;
    private List<String> categories;
    private List<FoundIndication> indications;
    private static final Logger logger = Logger.getLogger(FoundFailureCause.class.getName());

    public FoundFailureCause(FailureCause originalCause) {
        this.id = originalCause.getId();
        this.name = originalCause.getName();
        this.description = originalCause.getDescription();
        this.categories = originalCause.getCategories();
        this.indications = new LinkedList<FoundIndication>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<FoundIndication> getIndications() {
        if (this.indications == null) {
            this.indications = new LinkedList<FoundIndication>();
        }
        return this.indications;
    }

    public void addIndication(FoundIndication indication) {
        if (this.indications == null) {
            this.indications = new LinkedList<FoundIndication>();
        }
        this.indications.add(indication);
    }

    public void addIndications(List<FoundIndication> foundIndications) {
        if (this.indications == null) {
            this.indications = new LinkedList<FoundIndication>();
        }
        this.indications.addAll(foundIndications);
    }

    public FoundIndication getDynamic(String token, StaplerRequest req, StaplerResponse resp) {
        try {
            int indicationNumber = Integer.parseInt(token) - 1;
            if (indicationNumber >= 0 && indicationNumber < this.indications.size()) {
                return this.indications.get(indicationNumber);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "[BFA] Failed to parse token for getDynamic: " + token);
            return null;
        }
        logger.log(Level.WARNING, "[BFA] Unable to navigate to the Indication: " + token);
        return null;
    }
}

