/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.tokens;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.tokens.TokenUtils;
import hudson.matrix.MatrixRun;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Renderer {
    private static final int ITEM_INCREMENT = 0;
    private static final int LIST_INCREMENT = 1;
    private static final String LIST_BULLET = "* ";
    private static final String LIST_BULLET_SPACE = "  ";
    private static final Logger logger = Logger.getLogger((String)Renderer.class.getName());
    private boolean includeIndications = true;
    private boolean useHtmlFormat = false;
    private boolean includeTitle = true;
    private int wrapWidth = 0;
    private String noFailureText = "";

    public void setIncludeIndications(boolean includeIndications) {
        this.includeIndications = includeIndications;
    }

    public void setUseHtmlFormat(boolean useHtmlFormat) {
        this.useHtmlFormat = useHtmlFormat;
    }

    public void setIncludeTitle(boolean includeTitle) {
        this.includeTitle = includeTitle;
    }

    public void setWrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    public void setNoFailureText(String noFailureText) {
        this.noFailureText = noFailureText;
    }

    protected void appendHtmlOrPlain(StringBuilder stringBuilder, String htmlText, String plainText) {
        if (this.useHtmlFormat && htmlText != null) {
            stringBuilder.append(htmlText);
        } else if (!this.useHtmlFormat && plainText != null) {
            stringBuilder.append(plainText);
        }
    }

    public String render(FailureCauseBuildAction action) {
        FailureCauseDisplayData data = action.getFailureCauseDisplayData();
        if (data.getFoundFailureCauses().isEmpty() && data.getDownstreamFailureCauses().isEmpty()) {
            logger.info((Object)"there were no causes");
            return this.noFailureText;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.addTitle(stringBuilder);
        boolean indentLevel = false;
        this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, 0);
        return stringBuilder.toString();
    }

    static String indentForDepth(int indentLevel) {
        return StringUtils.repeat((String)LIST_BULLET_SPACE, (int)indentLevel);
    }

    protected void addTitle(StringBuilder stringBuilder) {
        if (this.includeTitle) {
            String title = "Identified problems:";
            this.appendHtmlOrPlain(stringBuilder, "<h2>", null);
            stringBuilder.append("Identified problems:");
            this.appendHtmlOrPlain(stringBuilder, "</h2>", "\n");
        }
    }

    protected void addFailureCauseDisplayDataRepresentation(StringBuilder stringBuilder, FailureCauseDisplayData data, int indentLevel) {
        IndicationUrlBuilder indicationUrlBuilder = new IndicationUrlBuilder();
        indicationUrlBuilder.setBuildUrl(data.getLinks().getBuildUrl());
        List<FoundFailureCause> causes = data.getFoundFailureCauses();
        int nextIndentLevel = indentLevel + 0;
        this.appendHtmlOrPlain(stringBuilder, "<ul>", null);
        for (FoundFailureCause cause : causes) {
            indicationUrlBuilder.setCause(cause);
            this.addFailureCauseRepresentation(stringBuilder, indicationUrlBuilder, cause, nextIndentLevel);
        }
        this.appendHtmlOrPlain(stringBuilder, "</ul>", null);
    }

    private void addFailureCauseRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, FoundFailureCause cause, int indentLevel) {
        int nextIndentLevel = indentLevel + 1;
        if (this.useHtmlFormat) {
            stringBuilder.append("<li>");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(cause.getName()));
            }
            catch (IOException exception) {
                stringBuilder.append("cause-name");
            }
            stringBuilder.append(": ");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(cause.getDescription()));
            }
            catch (IOException exception) {
                stringBuilder.append("cause-description");
            }
            if (this.includeIndications) {
                this.addIndicationsRepresentation(stringBuilder, indicationUrlBuilder, cause.getIndications(), nextIndentLevel);
            }
            stringBuilder.append("</li>");
        } else {
            List<String> lines = TokenUtils.wrap(cause.getName() + ": " + cause.getDescription(), this.wrapWidth - Renderer.indentForDepth(indentLevel).length() - LIST_BULLET.length());
            int lineCount = lines.size();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                if (lineIndex == 0) {
                    stringBuilder.append(LIST_BULLET);
                } else {
                    stringBuilder.append(LIST_BULLET_SPACE);
                }
                stringBuilder.append(lines.get(lineIndex));
                stringBuilder.append("\n");
            }
            if (this.includeIndications) {
                this.addIndicationsRepresentation(stringBuilder, indicationUrlBuilder, cause.getIndications(), nextIndentLevel);
            }
        }
    }

    private void addIndicationsRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, List<FoundIndication> indications, int indentLevel) {
        int nextIndentLevel = indentLevel + 0;
        this.appendHtmlOrPlain(stringBuilder, "<ul>", null);
        int size = indications.size();
        for (int i = 0; i < size; ++i) {
            FoundIndication indication = indications.get(i);
            indicationUrlBuilder.setIndication(indication);
            int indicationNumber = i + 1;
            this.addIndicationRepresentation(stringBuilder, indicationUrlBuilder, indication, indicationNumber, nextIndentLevel);
        }
        this.appendHtmlOrPlain(stringBuilder, "</ul>", null);
    }

    private void addIndicationRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, FoundIndication indication, int indicationNumber, int indentLevel) {
        if (this.useHtmlFormat) {
            stringBuilder.append("<li><a href=\"");
            stringBuilder.append(indicationUrlBuilder.getUrlString());
            stringBuilder.append("\">");
            stringBuilder.append("Indication ");
            stringBuilder.append(indicationNumber);
            stringBuilder.append("</a></li>");
        } else {
            stringBuilder.append(Renderer.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET);
            stringBuilder.append("Indication ");
            stringBuilder.append(indicationNumber);
            stringBuilder.append(":\n");
            stringBuilder.append(Renderer.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET_SPACE);
            stringBuilder.append("<");
            stringBuilder.append(indicationUrlBuilder.getUrlString());
            stringBuilder.append(">\n");
        }
    }

    public String render(FailureCauseMatrixBuildAction matrixAction) {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTitle(stringBuilder);
        boolean indentLevel = false;
        this.addFailureCauseMatrixRepresentation(stringBuilder, matrixAction, 0);
        return stringBuilder.toString();
    }

    private void addFailureCauseMatrixRepresentation(StringBuilder stringBuilder, FailureCauseMatrixBuildAction matrixAction, int indentLevel) {
        List<MatrixRun> matrixRuns = matrixAction.getRunsWithAction();
        if (this.useHtmlFormat) {
            stringBuilder.append("<ul>");
        }
        for (MatrixRun matrixRun : matrixRuns) {
            this.addMatrixRunRepresentation(stringBuilder, matrixRun, indentLevel + 0);
        }
        if (this.useHtmlFormat) {
            stringBuilder.append("</ul>");
        }
    }

    private void addMatrixRunRepresentation(StringBuilder stringBuilder, MatrixRun matrixRun, int indentLevel) {
        FailureCauseDisplayData data = FailureCauseMatrixBuildAction.getFailureCauseDisplayData(matrixRun);
        if (data.getFoundFailureCauses().isEmpty() && data.getDownstreamFailureCauses().isEmpty()) {
            return;
        }
        int nextIndentLevel = indentLevel + 1;
        if (this.useHtmlFormat) {
            stringBuilder.append("<li>");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(matrixRun.getFullDisplayName()));
            }
            catch (IOException exception) {
                stringBuilder.append("matrix-full-display-name");
            }
            this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, nextIndentLevel);
            stringBuilder.append("</li>");
        } else {
            stringBuilder.append(Renderer.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET);
            stringBuilder.append(matrixRun.getFullDisplayName());
            stringBuilder.append("\n");
            this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, nextIndentLevel);
        }
    }

    protected static class IndicationUrlBuilder {
        private String buildUrl = "";
        private String causeId = "";
        private String indicationHash = "";

        protected IndicationUrlBuilder() {
        }

        void setBuildUrl(String buildUrl) {
            this.buildUrl = buildUrl;
        }

        void setCause(FoundFailureCause cause) {
            this.causeId = cause.getId();
        }

        void setIndication(FoundIndication indication) {
            this.indicationHash = String.valueOf(indication.getMatchingHash());
        }

        String getUrlString() {
            StringBuilder builder = new StringBuilder();
            builder.append(Jenkins.getInstance().getRootUrl());
            builder.append("/");
            builder.append(this.buildUrl);
            builder.append("consoleFull#");
            builder.append(this.indicationHash);
            builder.append(this.causeId);
            return builder.toString();
        }

        public String toString() {
            return this.getUrlString();
        }
    }
}

