/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.sonyericsson.jenkins.plugins.bfa.graphs.FailureCauseTimeInterval;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import com.sonyericsson.jenkins.plugins.bfa.utils.ObjectCountPair;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jfree.data.time.TimePeriod;

public abstract class KnowledgeBase
implements Describable<KnowledgeBase>,
Serializable {
    private static final long DEFAULT_NBR_OF_NULL_FAILURE_CAUSES = 0L;

    public abstract Collection<FailureCause> getCauses() throws Exception;

    public abstract Collection<FailureCause> getCauseNames() throws Exception;

    public abstract Collection<FailureCause> getShallowCauses() throws Exception;

    public abstract FailureCause getCause(String var1) throws Exception;

    public abstract FailureCause addCause(FailureCause var1) throws Exception;

    public abstract FailureCause removeCause(String var1) throws Exception;

    public abstract FailureCause saveCause(FailureCause var1) throws Exception;

    public abstract void convertFrom(KnowledgeBase var1) throws Exception;

    public abstract List<String> getCategories() throws Exception;

    protected void convertFromAbstract(KnowledgeBase oldKnowledgeBase) throws Exception {
        for (FailureCause cause : oldKnowledgeBase.getCauseNames()) {
            this.saveCause(oldKnowledgeBase.getCause(cause.getId()));
        }
    }

    public abstract boolean equals(KnowledgeBase var1);

    public abstract void start() throws Exception;

    public abstract void stop();

    public int hashCode() {
        return super.hashCode();
    }

    public abstract boolean isStatisticsEnabled();

    public abstract boolean isSuccessfulLoggingEnabled();

    public abstract void saveStatistics(Statistics var1) throws Exception;

    public List<Statistics> getStatistics(GraphFilterBuilder filter, int limit) throws Exception {
        return Collections.emptyList();
    }

    public List<ObjectCountPair<FailureCause>> getNbrOfFailureCauses(GraphFilterBuilder filter) {
        return Collections.emptyList();
    }

    public Map<TimePeriod, Double> getUnknownFailureCauseQuotaPerTime(int intervalSize, GraphFilterBuilder filter) {
        return Collections.emptyMap();
    }

    public List<ObjectCountPair<String>> getFailureCauseNames(GraphFilterBuilder filter) {
        return Collections.emptyList();
    }

    public long getNbrOfNullFailureCauses(GraphFilterBuilder filter) {
        return 0L;
    }

    public List<ObjectCountPair<String>> getNbrOfFailureCategoriesPerName(GraphFilterBuilder filter, int limit) {
        return Collections.emptyList();
    }

    public Map<Integer, List<FailureCause>> getFailureCausesPerBuild(GraphFilterBuilder filter) {
        return Collections.emptyMap();
    }

    public List<FailureCauseTimeInterval> getFailureCausesPerTime(int intervalSize, GraphFilterBuilder filter, boolean byCategories) {
        return Collections.emptyList();
    }

    public List<ObjectCountPair<String>> getNbrOfFailureCausesPerId(GraphFilterBuilder filter, int limit) {
        return Collections.emptyList();
    }

    public Date getLatestFailureForCause(String id) {
        return null;
    }

    public void updateLastSeen(List<String> ids, Date seen) {
    }

    public Date getCreationDateForCause(String id) {
        return new Date(0L);
    }

    @Deprecated
    public void removeBuildfailurecause(AbstractBuild build) throws Exception {
        if (Util.isOverridden(KnowledgeBase.class, this.getClass(), (String)"removeBuildfailurecause", (Class[])new Class[]{Run.class})) {
            this.removeBuildfailurecause((Run)build);
        }
    }

    public void removeBuildfailurecause(Run build) throws Exception {
        if (Util.isOverridden(KnowledgeBase.class, this.getClass(), (String)"removeBuildfailurecause", (Class[])new Class[]{AbstractBuild.class})) {
            this.removeBuildfailurecause((AbstractBuild)build);
        }
    }

    public static abstract class KnowledgeBaseDescriptor
    extends Descriptor<KnowledgeBase> {
        public static ExtensionList<KnowledgeBaseDescriptor> all() {
            return Jenkins.getInstance().getExtensionList(KnowledgeBaseDescriptor.class);
        }
    }
}

