/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.dbf;

import com.sonyericsson.jenkins.plugins.bfa.model.dbf.DownstreamBuildFinder;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class ParameterizedTriggerDBF
extends DownstreamBuildFinder {
    private static final Logger logger = Logger.getLogger(ParameterizedTriggerDBF.class.getName());

    @Override
    public List<Run<?, ?>> getDownstreamBuilds(Run build) {
        if (build == null) {
            return EMPTY;
        }
        String className = "hudson.plugins.parameterizedtrigger.BuildInfoExporterAction";
        String methodName = "getTriggeredBuilds";
        try {
            Class<?> clazz = Class.forName(className);
            Action action = build.getAction(clazz);
            if (action != null) {
                Method method = clazz.getMethod(methodName, new Class[0]);
                return (List)method.invoke((Object)action, new Object[0]);
            }
            return EMPTY;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINER, "Class " + className + " not installed. " + "Can't get downstream builds");
            return EMPTY;
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINER, "Method " + methodName + " doesn't exists in " + "class " + className + ".");
            return EMPTY;
        }
        catch (InvocationTargetException e) {
            return EMPTY;
        }
        catch (IllegalAccessException e) {
            return EMPTY;
        }
    }
}

