/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ComputerGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ProjectGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.MultilineBuildLogIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

@Extension(ordinal=11003.0)
public class BuildFailureScanner
extends RunListener<Run> {
    public static final int ORDINAL = 11003;
    private static final Logger logger = Logger.getLogger(BuildFailureScanner.class.getName());
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(PluginImpl.getInstance().getNrOfScanThreads());

    public void onStarted(Run build, TaskListener listener) {
        if (PluginImpl.shouldScan(build) && build.getParent().getProperty(ScannerJobProperty.class) == null) {
            try {
                build.getParent().addProperty((JobProperty)new ScannerJobProperty(false));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to add a ScannerJobProperty to " + build.getParent().getFullDisplayName(), e);
                listener.getLogger().println("[BFA] WARNING! Failed to add the scanner property to this job.");
            }
        }
    }

    public void onCompleted(Run build, @Nonnull TaskListener listener) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "onCompleted");
        if (PluginImpl.isSizeInLimit(build)) {
            BuildFailureScanner.scanIfNotScanned(build, listener.getLogger());
        } else {
            listener.getLogger().println("[BFA] Log exceeds limit: " + PluginImpl.getInstance().getMaxLogSize() + "MB");
        }
    }

    public static void scanIfNotScanned(Run build, PrintStream buildLog) {
        if (PluginImpl.shouldScan(build) && !(build.getParent() instanceof MatrixProject) && build.getActions(FailureCauseBuildAction.class).isEmpty() && build.getActions(FailureCauseMatrixBuildAction.class).isEmpty()) {
            if (PluginImpl.needToAnalyze(build.getResult())) {
                BuildFailureScanner.scan(build, buildLog);
                ProjectGraphAction.invalidateProjectGraphCache(build.getParent());
                if (build instanceof AbstractBuild) {
                    ComputerGraphAction.invalidateNodeGraphCache(((AbstractBuild)build).getBuiltOn());
                }
            } else if (PluginImpl.getInstance().getKnowledgeBase().isSuccessfulLoggingEnabled()) {
                List<FoundFailureCause> emptyCauseList = Collections.synchronizedList(new LinkedList());
                StatisticsLogger.getInstance().log(build, emptyCauseList);
            }
        }
    }

    public static void scan(Run build, PrintStream buildLog) {
        try {
            List<FoundFailureCause> foundCauseList;
            Collection<FailureCause> causes = PluginImpl.getInstance().getKnowledgeBase().getCauses();
            List<FoundFailureCause> foundCauseListToLog = BuildFailureScanner.findCauses(causes, build, buildLog);
            if (PluginImpl.getInstance().isTestResultParsingEnabled()) {
                foundCauseList = Collections.synchronizedList(new LinkedList<FoundFailureCause>(foundCauseListToLog));
                foundCauseList.addAll(BuildFailureScanner.findFailedTests(build, buildLog));
            } else {
                foundCauseList = foundCauseListToLog;
            }
            FailureCauseBuildAction buildAction = new FailureCauseBuildAction(foundCauseList);
            buildAction.setBuild(build);
            build.addAction((Action)buildAction);
            FailureCauseDisplayData data = buildAction.getFailureCauseDisplayData();
            List<FailureCauseDisplayData> downstreamFailureCauses = data.getDownstreamFailureCauses();
            if (!downstreamFailureCauses.isEmpty()) {
                buildLog.println("[BFA] Found downstream Failure causes ...");
                BuildFailureScanner.printDownstream(buildLog, downstreamFailureCauses);
            }
            StatisticsLogger.getInstance().log(build, foundCauseListToLog);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not scan build " + build, e);
        }
    }

    private static void printDownstream(PrintStream buildLog, List<FailureCauseDisplayData> downstreamFailureCauses) {
        for (FailureCauseDisplayData displayData : downstreamFailureCauses) {
            FailureCauseDisplayData.Links links = displayData.getLinks();
            if (!displayData.getFoundFailureCauses().isEmpty()) {
                buildLog.println("[BFA] See: " + Jenkins.getInstance().getRootUrl() + links.getBuildUrl());
                for (FoundFailureCause foundCause : displayData.getFoundFailureCauses()) {
                    String foundString = "[BFA] " + foundCause.getName();
                    if (foundCause.getCategories() != null) {
                        foundString = foundString + " from category " + foundCause.getCategories().get(0);
                    }
                    buildLog.println(foundString);
                }
            }
            BuildFailureScanner.printDownstream(buildLog, displayData.getDownstreamFailureCauses());
        }
    }

    private static List<FoundFailureCause> findCauses(Collection<FailureCause> causes, Run build, PrintStream buildLog) {
        THREAD_POOL_EXECUTOR.setCorePoolSize(PluginImpl.getInstance().getNrOfScanThreads());
        THREAD_POOL_EXECUTOR.setMaximumPoolSize(PluginImpl.getInstance().getNrOfScanThreads());
        buildLog.println("[BFA] Scanning build for known causes...");
        long start = System.currentTimeMillis();
        List<FoundFailureCause> foundFailureCauseList = BuildFailureScanner.findIndications(causes, build, buildLog);
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] {1}ms", new Object[]{build.getFullDisplayName(), String.valueOf(time)});
        }
        if (!foundFailureCauseList.isEmpty()) {
            buildLog.println("[BFA] Found failure cause(s):");
            for (FoundFailureCause foundCause : foundFailureCauseList) {
                if (foundCause.getCategories() == null) {
                    buildLog.println("[BFA] " + foundCause.getName());
                    continue;
                }
                buildLog.println("[BFA] " + foundCause.getName() + " from category " + foundCause.getCategories().get(0));
            }
        } else {
            buildLog.println("[BFA] No failure causes found");
        }
        buildLog.println("[BFA] Done. " + TimeUnit.MILLISECONDS.toSeconds(time) + "s");
        return foundFailureCauseList;
    }

    private static List<FoundFailureCause> findIndications(Collection<FailureCause> causes, final Run build, final PrintStream buildLog) {
        final ArrayList<FailureCause> singleLineCauses = new ArrayList<FailureCause>();
        ArrayList<FailureCause> notOnlySingleLineCauses = new ArrayList<FailureCause>();
        BuildFailureScanner.splitCauses(causes, singleLineCauses, notOnlySingleLineCauses);
        ArrayList scanningTasks = new ArrayList(notOnlySingleLineCauses.size() + 1);
        final List<FoundFailureCause> foundFailureCauses = Collections.synchronizedList(new ArrayList());
        if (!singleLineCauses.isEmpty()) {
            scanningTasks.add(THREAD_POOL_EXECUTOR.submit(new Runnable(){

                @Override
                public void run() {
                    foundFailureCauses.addAll(BuildFailureScanner.parseSingleLineCauses(build, buildLog, singleLineCauses));
                    Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName());
                }
            }));
        }
        for (final FailureCause cause : notOnlySingleLineCauses) {
            scanningTasks.add(THREAD_POOL_EXECUTOR.submit(new Runnable(){

                @Override
                public void run() {
                    ArrayList<FoundIndication> foundIndications = new ArrayList<FoundIndication>();
                    for (Indication indication : cause.getIndications()) {
                        Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName() + ": " + cause.getName() + "-" + indication.getUserProvidedExpression());
                        FoundIndication foundIndication = BuildFailureScanner.parseIndication(build, buildLog, indication, cause.getName());
                        if (foundIndication == null) continue;
                        foundIndications.add(foundIndication);
                    }
                    if (!foundIndications.isEmpty()) {
                        foundFailureCauses.add(new FoundFailureCause(cause, foundIndications));
                    }
                }
            }));
        }
        BuildFailureScanner.waitAllTasks(buildLog, scanningTasks);
        return foundFailureCauses;
    }

    private static void waitAllTasks(PrintStream buildLog, List<Future<?>> scanningTasks) {
        try {
            for (Future<?> scanningTask : scanningTasks) {
                try {
                    scanningTask.get();
                }
                catch (ExecutionException e) {
                    buildLog.print("[BFA] task failed due exception: " + e);
                }
            }
        }
        catch (InterruptedException e) {
            buildLog.print("[BFA] was interrupted: " + e);
            for (Future<?> scanningTask : scanningTasks) {
                scanningTask.cancel(true);
            }
            buildLog.print("[BFA] all bfa tasks were cancelled");
        }
    }

    private static void splitCauses(Collection<FailureCause> causes, List<FailureCause> singleLineCauses, List<FailureCause> notOnlySingleLineCauses) {
        for (FailureCause cause : causes) {
            boolean atLeastOneNonSignalLine = false;
            for (Indication indication : cause.getIndications()) {
                if (!(indication instanceof MultilineBuildLogIndication)) continue;
                atLeastOneNonSignalLine = true;
                break;
            }
            if (atLeastOneNonSignalLine) {
                notOnlySingleLineCauses.add(cause);
                continue;
            }
            singleLineCauses.add(cause);
        }
    }

    private static FoundIndication parseIndication(Run build, PrintStream buildLog, Indication indication, String causeName) {
        long start = System.currentTimeMillis();
        FoundIndication foundIndication = BuildFailureScanner.findIndication(indication, build, buildLog);
        if (foundIndication != null && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] [{1}] {2}ms", new Object[]{build.getFullDisplayName(), causeName, String.valueOf(System.currentTimeMillis() - start)});
        }
        return foundIndication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FoundFailureCause> parseSingleLineCauses(Run build, PrintStream buildLog, List<FailureCause> singleLineCauses) {
        ArrayList<FoundFailureCause> foundFailureCauses = new ArrayList<FoundFailureCause>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(build.getLogReader());
            foundFailureCauses.addAll(FailureReader.scanSingleLinePatterns(singleLineCauses, build, reader, build.getLogFile().getName()));
        }
        catch (IOException e) {
            buildLog.print("[BFA] Exception during parsing file: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
        }
        return foundFailureCauses;
    }

    private static FoundIndication findIndication(Indication indication, Run build, PrintStream buildLog) {
        FailureReader failureReader = indication.getReader();
        return failureReader.scan(build, buildLog);
    }

    private static List<FoundFailureCause> findFailedTests(Run build, PrintStream buildLog) {
        List<FoundFailureCause> failedTestList = Collections.synchronizedList(new LinkedList());
        List testActions = build.getActions(AbstractTestResultAction.class);
        for (AbstractTestResultAction testAction : testActions) {
            List failedTests = testAction.getFailedTests();
            for (TestResult test : failedTests) {
                buildLog.println("[BFA] Found failed test case: " + test.getName());
                FailureCause failureCause = new FailureCause(null, test.getName(), test.getErrorStackTrace(), "", null, PluginImpl.getInstance().getTestResultCategories(), null, null);
                FoundFailureCause foundFailureCause = new FoundFailureCause(failureCause);
                failedTestList.add(foundFailureCause);
            }
        }
        return failedTestList;
    }
}

