/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.graphs.BFAGraph;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import hudson.model.Job;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class StackedBarChart
extends BFAGraph {
    protected static final String NO_FAILURE = "No failure for this build";

    public StackedBarChart(long timestamp, int defaultW, int defaultH, Job project, GraphFilterBuilder filter, String graphTitle) {
        super(timestamp, defaultW, defaultH, project, filter, graphTitle);
    }

    protected JFreeChart createGraph() {
        DefaultCategoryDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart((String)this.getTitle(), (String)this.getXAxisTitle(), (String)this.getYAxisTitle(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        int index = dataset.getRowIndex((Comparable)((Object)NO_FAILURE));
        if (index >= 0) {
            plot.getRenderer().setSeriesVisibleInLegend(index, Boolean.valueOf(false));
        }
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    protected abstract DefaultCategoryDataset createDataset();

    protected abstract String getTitle();

    protected abstract String getYAxisTitle();

    protected abstract String getXAxisTitle();
}

