/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ComputerGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.graphs.ProjectGraphAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension(ordinal=11003.0)
public class BuildFailureScanner
extends RunListener<Run> {
    public static final int ORDINAL = 11003;
    private static final Logger logger = Logger.getLogger(BuildFailureScanner.class.getName());

    public void onStarted(Run build, TaskListener listener) {
        if (PluginImpl.shouldScan(build) && build.getParent().getProperty(ScannerJobProperty.class) == null) {
            try {
                build.getParent().addProperty((JobProperty)new ScannerJobProperty(false));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to add a ScannerJobProperty to " + build.getParent().getFullDisplayName(), e);
                listener.getLogger().println("[BFA] WARNING! Failed to add the scanner property to this job.");
            }
        }
    }

    public void onCompleted(Run build, TaskListener listener) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "onCompleted");
        if (PluginImpl.isSizeInLimit(build)) {
            BuildFailureScanner.scanIfNotScanned(build, listener.getLogger());
        } else {
            listener.getLogger().println("[BFA] Log exceeds limit: " + PluginImpl.getInstance().getMaxLogSize() + "MB");
        }
    }

    public static void scanIfNotScanned(Run build, PrintStream buildLog) {
        if (PluginImpl.shouldScan(build) && !(build.getParent() instanceof MatrixProject) && build.getActions(FailureCauseBuildAction.class).isEmpty() && build.getActions(FailureCauseMatrixBuildAction.class).isEmpty()) {
            if (PluginImpl.needToAnalyze(build.getResult())) {
                BuildFailureScanner.scan(build, buildLog);
                ProjectGraphAction.invalidateProjectGraphCache(build.getParent());
                if (build instanceof AbstractBuild) {
                    ComputerGraphAction.invalidateNodeGraphCache(((AbstractBuild)build).getBuiltOn());
                }
            } else if (PluginImpl.getInstance().getKnowledgeBase().isSuccessfulLoggingEnabled()) {
                List<FoundFailureCause> emptyCauseList = Collections.synchronizedList(new LinkedList());
                StatisticsLogger.getInstance().log(build, emptyCauseList);
            }
        }
    }

    public static void scan(Run build, PrintStream buildLog) {
        try {
            List<FoundFailureCause> foundCauseList;
            Collection<FailureCause> causes = PluginImpl.getInstance().getKnowledgeBase().getCauses();
            List<FoundFailureCause> foundCauseListToLog = BuildFailureScanner.findCauses(causes, build, buildLog);
            if (PluginImpl.getInstance().isTestResultParsingEnabled()) {
                foundCauseList = Collections.synchronizedList(new LinkedList<FoundFailureCause>(foundCauseListToLog));
                foundCauseList.addAll(BuildFailureScanner.findFailedTests(build, buildLog));
            } else {
                foundCauseList = foundCauseListToLog;
            }
            FailureCauseBuildAction buildAction = new FailureCauseBuildAction(foundCauseList);
            buildAction.setBuild(build);
            build.addAction((Action)buildAction);
            FailureCauseDisplayData data = buildAction.getFailureCauseDisplayData();
            List<FailureCauseDisplayData> downstreamFailureCauses = data.getDownstreamFailureCauses();
            if (!downstreamFailureCauses.isEmpty()) {
                buildLog.println("[BFA] Found downstream Failure causes ...");
                BuildFailureScanner.printDownstream(buildLog, downstreamFailureCauses);
            }
            StatisticsLogger.getInstance().log(build, foundCauseListToLog);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not scan build " + build, e);
        }
    }

    private static void printDownstream(PrintStream buildLog, List<FailureCauseDisplayData> downstreamFailureCauses) {
        for (FailureCauseDisplayData displayData : downstreamFailureCauses) {
            FailureCauseDisplayData.Links links = displayData.getLinks();
            if (!displayData.getFoundFailureCauses().isEmpty()) {
                buildLog.println("[BFA] See: " + Jenkins.getInstance().getRootUrl() + links.getBuildUrl());
                for (FoundFailureCause foundCause : displayData.getFoundFailureCauses()) {
                    String foundString = "[BFA] " + foundCause.getName();
                    if (foundCause.getCategories() != null) {
                        foundString = foundString + " from category " + foundCause.getCategories().get(0);
                    }
                    buildLog.println(foundString);
                }
            }
            BuildFailureScanner.printDownstream(buildLog, displayData.getDownstreamFailureCauses());
        }
    }

    private static List<FoundFailureCause> findCauses(Collection<FailureCause> causes, final Run build, final PrintStream buildLog) {
        final List<FoundFailureCause> foundFailureCauseList = Collections.synchronizedList(new LinkedList());
        long start = System.currentTimeMillis();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(PluginImpl.getInstance().getNrOfScanThreads());
        buildLog.println("[BFA] Scanning build for known causes...");
        for (final FailureCause cause : causes) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName() + ": " + cause.getName());
                    List foundIndications = BuildFailureScanner.findIndications(cause, build, buildLog);
                    if (!foundIndications.isEmpty()) {
                        FoundFailureCause foundFailureCause = new FoundFailureCause(cause, foundIndications);
                        foundFailureCauseList.add(foundFailureCause);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                buildLog.print('.');
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, "Got interrupted while waiting for scanner threads to finish for {0}", build.getFullDisplayName());
            buildLog.println("[BFA] Interrupted.");
        }
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] {1}ms", new Object[]{build.getFullDisplayName(), String.valueOf(time)});
        }
        if (!foundFailureCauseList.isEmpty()) {
            buildLog.println("[BFA] Found failure cause(s):");
            for (FoundFailureCause foundCause : foundFailureCauseList) {
                if (foundCause.getCategories() == null) {
                    buildLog.println("[BFA] " + foundCause.getName());
                    continue;
                }
                buildLog.println("[BFA] " + foundCause.getName() + " from category " + foundCause.getCategories().get(0));
            }
        } else {
            buildLog.println("[BFA] No failure causes found");
        }
        buildLog.println("[BFA] Done. " + TimeUnit.MILLISECONDS.toSeconds(time) + "s");
        return foundFailureCauseList;
    }

    private static List<FoundIndication> findIndications(FailureCause cause, Run build, PrintStream buildLog) {
        long start = System.currentTimeMillis();
        List<Indication> indicationList = cause.getIndications();
        LinkedList<FoundIndication> foundIndicationList = new LinkedList<FoundIndication>();
        for (Indication indication : indicationList) {
            Thread.currentThread().setName("BFA-scanner-" + build.getFullDisplayName() + ": " + cause.getName() + "-" + indication.getUserProvidedExpression());
            FoundIndication foundIndication = BuildFailureScanner.findIndication(indication, build, buildLog);
            if (foundIndication == null) continue;
            foundIndicationList.add(foundIndication);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] [{1}] {2}ms", new Object[]{build.getFullDisplayName(), cause.getName(), String.valueOf(System.currentTimeMillis() - start)});
        }
        return foundIndicationList;
    }

    private static FoundIndication findIndication(Indication indication, Run build, PrintStream buildLog) {
        FailureReader failureReader = indication.getReader();
        return failureReader.scan(build, buildLog);
    }

    private static List<FoundFailureCause> findFailedTests(Run build, PrintStream buildLog) {
        List<FoundFailureCause> failedTestList = Collections.synchronizedList(new LinkedList());
        List testActions = build.getActions(AbstractTestResultAction.class);
        for (AbstractTestResultAction testAction : testActions) {
            List failedTests = testAction.getFailedTests();
            for (TestResult test : failedTests) {
                buildLog.println("[BFA] Found failed test case: " + test.getName());
                FailureCause failureCause = new FailureCause(null, test.getName(), test.getErrorStackTrace(), "", null, PluginImpl.getInstance().getTestResultCategories(), null, null);
                FoundFailureCause foundFailureCause = new FoundFailureCause(failureCause);
                failedTestList.add(foundFailureCause);
            }
        }
        return failedTestList;
    }
}

