/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.google.common.base.Joiner;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Util;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.annotate.JsonIgnoreType;

@JsonIgnoreType
public abstract class FailureReader {
    private static final Logger logger = Logger.getLogger(FailureReader.class.getName());
    private static final long TIMEOUT_BLOCK = 2000L;
    private static final long TIMEOUT_FILE = 10000L;
    private static final long TIMEOUT_LINE = 1000L;
    private static final long SLEEPTIME = 200L;
    private static final int OVERLAP_BYTES = 5000;
    private static final int BUF_SIZE_BYTES = 15000;
    protected Indication indication;

    public FailureReader(Indication indication) {
        this.indication = indication;
    }

    @Deprecated
    public FoundIndication scan(AbstractBuild build) throws IOException {
        if (Util.isOverridden(FailureReader.class, this.getClass(), (String)"scan", (Class[])new Class[]{Run.class})) {
            return this.scan((Run)build);
        }
        return null;
    }

    public FoundIndication scan(Run build) throws IOException {
        if (Util.isOverridden(FailureReader.class, this.getClass(), (String)"scan", (Class[])new Class[]{AbstractBuild.class})) {
            return this.scan((AbstractBuild)build);
        }
        return null;
    }

    @Deprecated
    public FoundIndication scan(AbstractBuild build, PrintStream buildLog) {
        if (Util.isOverridden(FailureReader.class, this.getClass(), (String)"scan", (Class[])new Class[]{Run.class, PrintStream.class})) {
            return this.scan((Run)build, buildLog);
        }
        return null;
    }

    public FoundIndication scan(Run build, PrintStream buildLog) {
        if (Util.isOverridden(FailureReader.class, this.getClass(), (String)"scan", (Class[])new Class[]{AbstractBuild.class, PrintStream.class})) {
            return this.scan((AbstractBuild)build, buildLog);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoundIndication scanOneFile(Run build, BufferedReader reader, String currentFile) throws IOException {
        TimerThread timerThread = new TimerThread(Thread.currentThread(), 1000L);
        FoundIndication foundIndication = null;
        boolean found = false;
        Pattern pattern = this.indication.getPattern();
        int currentLine = 1;
        timerThread.start();
        try {
            String line;
            long startTime = System.currentTimeMillis();
            while ((line = reader.readLine()) != null) {
                try {
                    if (pattern.matcher(new InterruptibleCharSequence(line)).matches()) {
                        found = true;
                        break;
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        logger.warning("Timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile + ":" + currentLine);
                    }
                    throw e;
                }
                ++currentLine;
                timerThread.touch();
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                logger.warning("File timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                break;
            }
            if (found) {
                String cleanLine = ConsoleNote.removeNotes((String)line);
                foundIndication = new FoundIndication(build, pattern.toString(), currentFile, cleanLine);
            }
            FoundIndication foundIndication2 = foundIndication;
            return foundIndication2;
        }
        finally {
            timerThread.requestStop();
            timerThread.interrupt();
            try {
                timerThread.join();
            }
            catch (InterruptedException interruptedException) {}
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoundIndication scanMultiLineOneFile(Run build, BufferedReader reader, String currentFile) throws IOException {
        TimerThread timerThread = new TimerThread(Thread.currentThread(), 2000L);
        FoundIndication foundIndication = null;
        Pattern pattern = this.indication.getPattern();
        timerThread.start();
        try {
            int read;
            long startTime = System.currentTimeMillis();
            char[] buf = new char[15000];
            StringBuilder searchBuffer = new StringBuilder();
            boolean firstRead = true;
            while ((read = reader.read(buf, 0, 15000 - (firstRead ? 0 : 5000))) != -1) {
                try {
                    firstRead = false;
                    searchBuffer.append(buf, 0, read);
                    Matcher matcher = pattern.matcher(new InterruptibleCharSequence(searchBuffer.toString()));
                    if (matcher.find()) {
                        foundIndication = new FoundIndication(build, pattern.pattern(), currentFile, this.removeConsoleNotes(matcher.group()));
                        break;
                    }
                    searchBuffer.delete(0, 10000);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        logger.warning("Timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                    }
                    throw e;
                }
                timerThread.touch();
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                logger.warning("File timeout scanning for indication '" + this.indication.toString() + "' for file " + currentFile);
                break;
            }
            FoundIndication foundIndication2 = foundIndication;
            return foundIndication2;
        }
        finally {
            timerThread.requestStop();
            timerThread.interrupt();
            try {
                timerThread.join();
            }
            catch (InterruptedException interruptedException) {}
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String removeConsoleNotes(String input) {
        LinkedList<String> cleanLines = new LinkedList<String>();
        Scanner lineTokenizer = new Scanner(input);
        try {
            lineTokenizer.useDelimiter(Pattern.compile("[\\n\\r]"));
            while (lineTokenizer.hasNext()) {
                cleanLines.add(ConsoleNote.removeNotes((String)lineTokenizer.next()));
            }
        }
        finally {
            lineTokenizer.close();
        }
        return Joiner.on((char)'\n').join(cleanLines);
    }

    static class TimerThread
    extends Thread {
        private Thread monitorThread;
        private boolean stop = false;
        private long timeout;
        private long lastTouched;

        TimerThread(Thread monitorThread, long timeout) {
            this.monitorThread = monitorThread;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            this.lastTouched = System.currentTimeMillis();
            while (!this.stop) {
                try {
                    Thread.sleep(200L);
                    if (System.currentTimeMillis() - this.lastTouched < this.timeout) continue;
                    this.monitorThread.interrupt();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void touch() {
            this.lastTouched = System.currentTimeMillis();
        }

        public void requestStop() {
            this.stop = true;
        }
    }

    public static class InterruptibleCharSequence
    implements CharSequence {
        CharSequence inner;

        public InterruptibleCharSequence(CharSequence inner) {
            this.inner = inner.toString();
        }

        @Override
        public char charAt(int index) {
            if (Thread.interrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new InterruptibleCharSequence(this.inner.subSequence(start, end));
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }
}

