/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScanOnDemandQueue {
    private static final Logger logger = LoggerFactory.getLogger(ScanOnDemandQueue.class);
    private static ScanOnDemandQueue instance;
    private ThreadPoolExecutor executor = null;

    private ScanOnDemandQueue() {
    }

    public static synchronized ScanOnDemandQueue getInstance() {
        if (instance == null) {
            instance = new ScanOnDemandQueue();
            instance.startQueue();
        }
        return instance;
    }

    public static int getQueueSize() {
        if (instance != null && ScanOnDemandQueue.instance.executor != null) {
            return ScanOnDemandQueue.instance.executor.getQueue().size();
        }
        return 0;
    }

    public static void queue(ScanOnDemandTask task) {
        ScanOnDemandQueue.getInstance().queueTask(task);
    }

    protected void startQueue() {
        if (this.executor == null) {
            logger.debug("Starting the sending thread pool.");
            this.executor = new ThreadPoolExecutor(PluginImpl.getInstance().getSodVariables().getMinimumSodWorkerThreads(), PluginImpl.getInstance().getSodVariables().getMinimumSodWorkerThreads(), PluginImpl.getInstance().getSodVariables().getSodThreadKeepAliveTime(), TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.executor.allowCoreThreadTimeOut(true);
            this.executor.prestartCoreThread();
            logger.info("SendQueue started! Current pool size: {}", (Object)this.executor.getPoolSize());
        }
        this.executor.setMaximumPoolSize(PluginImpl.getInstance().getSodVariables().getMaximumSodWorkerThreads());
        this.executor.setCorePoolSize(PluginImpl.getInstance().getSodVariables().getSodCorePoolNumberOfThreads());
        logger.debug("SendQueue running. Current pool size: {}. Current Queue size: {}", (Object)this.executor.getPoolSize(), (Object)ScanOnDemandQueue.getQueueSize());
        logger.debug("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
    }

    public void queueTask(ScanOnDemandTask task) {
        try {
            logger.debug("Queueing task {}", (Object)task);
            this.executor.submit(task);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unable to submit/queue a sod-task! ", (Object)task, (Object)e);
        }
    }

    public static void shutdown() {
        if (instance != null && ScanOnDemandQueue.instance.executor != null) {
            ThreadPoolExecutor pool = ScanOnDemandQueue.instance.executor;
            pool.shutdown();
            try {
                if (!pool.awaitTermination(PluginImpl.getInstance().getSodVariables().getSodWaitForJobShutdownTimeout(), TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(PluginImpl.getInstance().getSodVariables().getSodWaitForJobShutdownTimeout(), TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

