/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BFAGraph;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.graphs.StackedBarChart;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import hudson.model.Job;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jfree.data.category.DefaultCategoryDataset;

public class BuildNbrStackedBarChart
extends StackedBarChart {
    private static final String X_AXIS_TITLE = "Build number";
    private static final String Y_AXIS_TITLE = "Number of failures";
    private int nbrOfBuildsToShow;

    protected BuildNbrStackedBarChart(long timestamp, int defaultW, int defaultH, Job project, GraphFilterBuilder filter, int nbrOfBuildsToShow, String graphTitle) {
        super(timestamp, defaultW, defaultH, project, filter, graphTitle);
        this.nbrOfBuildsToShow = nbrOfBuildsToShow;
    }

    @Override
    protected DefaultCategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List<Integer> latestBuildNumbers = BFAGraph.getBuildNumbers(this.project);
        Collections.reverse(latestBuildNumbers);
        int nbrOfBuilds = latestBuildNumbers.size();
        if (nbrOfBuilds > this.nbrOfBuildsToShow) {
            latestBuildNumbers = latestBuildNumbers.subList(0, this.nbrOfBuildsToShow);
        }
        this.filter.setBuildNumbers(latestBuildNumbers);
        KnowledgeBase knowledgeBase = PluginImpl.getInstance().getKnowledgeBase();
        Map<Integer, List<FailureCause>> map = knowledgeBase.getFailureCausesPerBuild(this.filter);
        if (map != null) {
            for (int buildNumber : latestBuildNumbers) {
                String buildNumberString = "#" + buildNumber;
                List<FailureCause> failureCauses = map.get(buildNumber);
                if (failureCauses == null) {
                    dataset.addValue(0.0, (Comparable)((Object)"No failure for this build"), (Comparable)((Object)buildNumberString));
                    continue;
                }
                for (FailureCause cause : failureCauses) {
                    dataset.addValue(1.0, (Comparable)((Object)cause.getName()), (Comparable)((Object)buildNumberString));
                }
            }
        }
        return dataset;
    }

    @Override
    protected String getTitle() {
        return this.graphTitle;
    }

    @Override
    protected String getYAxisTitle() {
        return Y_AXIS_TITLE;
    }

    @Override
    protected String getXAxisTitle() {
        return X_AXIS_TITLE;
    }
}

