/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.FailureCauseMatrixAggregator;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.utils.OldDataConverter;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.model.TopLevelItem;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class FailureCauseMatrixBuildAction
implements BuildBadgeAction {
    private static final Logger logger = Logger.getLogger(FailureCauseMatrixBuildAction.class.getName());
    private transient List<MatrixRun> runs;
    private List<String> runIds;
    private MatrixBuild build;

    public FailureCauseMatrixBuildAction(MatrixBuild build, List<MatrixRun> runs) {
        this.build = build;
        this.runs = runs;
        this.makeIdList(runs);
    }

    private void makeIdList(List<MatrixRun> matrixRuns) {
        logger.finer("making runIds");
        this.runIds = new LinkedList<String>();
        for (MatrixRun run : matrixRuns) {
            MatrixConfiguration configuration = (MatrixConfiguration)run.getProject();
            this.runIds.add(configuration.getCombination().toString());
        }
        logger.log(Level.FINER, "runIds size: {0}", this.runIds.size());
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public FailureCauseBuildAction getActionForBuild(MatrixRun run) {
        return (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
    }

    public List<MatrixRun> getRunsWithAction() {
        LinkedList<MatrixRun> returnList = new LinkedList<MatrixRun>();
        for (MatrixRun run : this.getRuns()) {
            if (run.getAction(FailureCauseBuildAction.class) == null) continue;
            returnList.add(run);
        }
        return returnList;
    }

    private synchronized List<MatrixRun> getRuns() {
        if (this.runIds != null && this.build != null && this.runs == null) {
            this.runs = new LinkedList<MatrixRun>();
            for (String id : this.runIds) {
                MatrixRun run;
                Combination combination = Combination.fromString((String)id);
                if (combination == null || (run = this.build.getRun(combination)) == null) continue;
                this.runs.add(run);
            }
        }
        return this.runs;
    }

    public FoundFailureCause getFirstFailureCause() {
        for (MatrixRun run : this.getRuns()) {
            List<FoundFailureCause> foundFailureCauses;
            FailureCauseBuildAction action = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
            if (action == null || (foundFailureCauses = action.getFoundFailureCauses()) == null || foundFailureCauses.isEmpty()) continue;
            return foundFailureCauses.get(0);
        }
        return null;
    }

    public String getImageUrl() {
        return PluginImpl.getFullImageUrl("48x48", "information.png");
    }

    public String getBadgeImageUrl() {
        return PluginImpl.getFullImageUrl("16x16", "information.png");
    }

    public List<FoundFailureCause> getFoundFailureCauses(MatrixRun run) {
        FailureCauseBuildAction action = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
        if (action != null) {
            return action.getFoundFailureCauses();
        }
        return new LinkedList<FoundFailureCause>();
    }

    public static FailureCauseDisplayData getFailureCauseDisplayData(MatrixRun run) {
        FailureCauseBuildAction action = (FailureCauseBuildAction)run.getAction(FailureCauseBuildAction.class);
        if (action != null) {
            return action.getFailureCauseDisplayData();
        }
        return new FailureCauseDisplayData();
    }

    public Object readResolve() {
        if (this.needsConvertOld()) {
            String project = this.findUpStreamName();
            if (project != null) {
                logger.log(Level.FINE, "Scheduling a build in {0} for conversion.", project);
                OldDataConverter.getInstance().convertMatrixBuildAction(project, this);
            } else {
                logger.warning("A MatrixProject's failure cause action needs to be converted, but the project name could not be discovered.");
            }
        }
        return this;
    }

    public synchronized boolean needsConvertOld() {
        return this.runs != null && (this.runIds == null || this.runIds.isEmpty()) || this.build == null;
    }

    public synchronized void convertOldData() {
        List<MatrixRun> newRuns = null;
        if (this.runs != null && (this.runIds == null || this.runIds.isEmpty())) {
            logger.fine("Starting conversion");
            for (MatrixRun run : this.runs) {
                if (this.build == null) {
                    this.build = this.findUpStream(run);
                    logger.log(Level.FINEST, "Build is {0}", this.build);
                }
                if (this.build == null) continue;
                logger.finer("Found a build.");
                newRuns = FailureCauseMatrixAggregator.getRuns(this.build);
                this.makeIdList(newRuns);
                break;
            }
        }
        if (newRuns != null) {
            logger.finer("Setting runs");
            this.runs = newRuns;
        }
        logger.exiting("FailureCauseMatrixBuildAction", "convertOldData");
    }

    public synchronized String findUpStreamName() {
        if (this.runs != null) {
            for (MatrixRun run : this.runs) {
                Cause.UpstreamCause cause = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
                if (cause == null) continue;
                return cause.getUpstreamProject();
            }
        }
        return null;
    }

    private MatrixBuild findUpStream(MatrixRun run) {
        Cause.UpstreamCause cause = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        if (cause != null) {
            String project = cause.getUpstreamProject();
            TopLevelItem item = Jenkins.getInstance().getItem(project);
            logger.log(Level.FINE, "Project item for {0} is {1}", new Object[]{project, item});
            if (item != null && item instanceof MatrixProject) {
                logger.log(Level.FINEST, "It is a matrix project; searching for build {0}", cause.getUpstreamBuild());
                return (MatrixBuild)((MatrixProject)item).getBuildByNumber(cause.getUpstreamBuild());
            }
        }
        return null;
    }
}

