/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.graphs.TimeSeriesChart;
import hudson.model.Job;
import java.util.Calendar;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesUnkownFailuresChart
extends TimeSeriesChart {
    private static final String Y_AXIS_LABEL = "Percent unknown failure causes";
    private static final int HUNDRED_PERCENT = 100;

    public TimeSeriesUnkownFailuresChart(long timestamp, int defaultW, int defaultH, Job project, GraphFilterBuilder filter, int intervalSize, String graphTitle) {
        super(timestamp, defaultW, defaultH, project, filter, intervalSize, false, graphTitle);
    }

    @Override
    protected JFreeChart createGraph() {
        TimeTableXYDataset dataset = this.createDataset();
        DateAxis xAxis = new DateAxis();
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        Calendar lowerBound = this.getLowerGraphBound();
        xAxis.setRange((double)lowerBound.getTimeInMillis(), (double)Calendar.getInstance().getTimeInMillis());
        NumberAxis yAxis = new NumberAxis(Y_AXIS_LABEL);
        yAxis.setRange(0.0, 100.0);
        XYBarRenderer renderer = new XYBarRenderer();
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(this.graphTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.removeLegend();
        return chart;
    }

    private TimeTableXYDataset createDataset() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        KnowledgeBase knowledgeBase = PluginImpl.getInstance().getKnowledgeBase();
        Map<TimePeriod, Double> periodQuotas = knowledgeBase.getUnknownFailureCauseQuotaPerTime(this.intervalSize, this.filter);
        for (Map.Entry<TimePeriod, Double> entry : periodQuotas.entrySet()) {
            dataset.add(entry.getKey(), entry.getValue() * 100.0, "");
        }
        return dataset;
    }
}

