/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.utils;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public final class OldDataConverter
extends ItemListener {
    public static final int POOL_SIZE = 10;
    public static final int SCHEDULE_DELAY = 3;
    private static final Logger logger = Logger.getLogger(OldDataConverter.class.getName());
    private static OldDataConverter instance;
    private Set<AbstractBuild> performedBuilds = Collections.synchronizedSet(new HashSet());
    private Map<String, List<FailureCauseMatrixBuildAction>> actionsToConvert = Collections.synchronizedMap(new HashMap());
    private ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(10);
    private boolean itemsLoaded = false;

    public static synchronized OldDataConverter getInstance() {
        if (instance == null && (instance = (OldDataConverter)((Object)ItemListener.all().get(OldDataConverter.class))) == null) {
            throw new IllegalStateException("ItemListeners has not been loaded yet!");
        }
        return instance;
    }

    public void convertFoundIndications(AbstractBuild build) {
        if (!this.performedBuilds.contains(build)) {
            this.executor.schedule(new FoundIndicationWork(build, this.performedBuilds), 3L, TimeUnit.SECONDS);
        }
    }

    public synchronized void convertMatrixBuildAction(String matrixProjectName, FailureCauseMatrixBuildAction action) {
        if (this.itemsLoaded) {
            this.executor.schedule(new MatrixBuildActionWork(matrixProjectName, action), 3L, TimeUnit.SECONDS);
        } else {
            List<FailureCauseMatrixBuildAction> actions = this.actionsToConvert.get(matrixProjectName);
            if (actions == null) {
                actions = new LinkedList<FailureCauseMatrixBuildAction>();
                this.actionsToConvert.put(matrixProjectName, actions);
            }
            actions.add(action);
        }
    }

    public synchronized void onLoaded() {
        this.itemsLoaded = true;
        for (String project : this.actionsToConvert.keySet()) {
            List<FailureCauseMatrixBuildAction> actions = this.actionsToConvert.get(project);
            logger.log(Level.FINE, "Scheduling conversion of {1} build actions for project {2}.", new Object[]{actions.size(), project});
            for (FailureCauseMatrixBuildAction action : actions) {
                this.executor.schedule(new MatrixBuildActionWork(project, action), 3L, TimeUnit.SECONDS);
            }
        }
        this.actionsToConvert.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialCompletion() throws InterruptedException {
        boolean loaded = false;
        while (!loaded) {
            OldDataConverter oldDataConverter = this;
            synchronized (oldDataConverter) {
                loaded = this.itemsLoaded;
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        while (!this.executor.getQueue().isEmpty()) {
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    public static class FoundIndicationWork
    implements Runnable {
        private AbstractBuild build;
        private Set<AbstractBuild> performedBuilds;

        public FoundIndicationWork(AbstractBuild build, Set<AbstractBuild> performedBuilds) {
            this.build = build;
            this.performedBuilds = performedBuilds;
        }

        @Override
        public void run() {
            FailureCauseBuildAction action;
            if (this.performedBuilds.add(this.build) && (action = (FailureCauseBuildAction)this.build.getAction(FailureCauseBuildAction.class)) != null) {
                try {
                    List log = this.build.getLog(Integer.MAX_VALUE);
                    for (FoundFailureCause cause : action.getFoundFailureCauses()) {
                        for (FoundIndication indication : cause.getIndications()) {
                            indication.convertFromLineNumber(log);
                        }
                    }
                    this.build.save();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to convert FoundIndications in " + this.build.getFullDisplayName(), e);
                }
            }
        }
    }

    public static class MatrixBuildActionWork
    implements Runnable {
        String project;
        FailureCauseMatrixBuildAction action;

        public MatrixBuildActionWork(String project, FailureCauseMatrixBuildAction action) {
            this.project = project;
            this.action = action;
        }

        @Override
        public void run() {
            logger.log(Level.FINE, "Calling conversion of {0}", this.project);
            this.action.convertOldData();
        }
    }
}

