/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.graphs.BFAGraph;
import com.sonyericsson.jenkins.plugins.bfa.graphs.FailureCauseTimeInterval;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.utils.ObjectCountPair;
import hudson.model.AbstractProject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesChart
extends BFAGraph {
    private static final String Y_AXIS_LABEL = "Number";
    private static final int LIMIT_BEFORE_GROUPING = 8;
    protected int intervalSize;
    private boolean groupByCategories;
    private Map<TimePeriod, List<FailureCauseTimeInterval>> excludedDataForPeriod;

    public TimeSeriesChart(long timestamp, int defaultW, int defaultH, AbstractProject project, GraphFilterBuilder filter, int intervalSize, boolean groupByCategories, String graphTitle) {
        super(timestamp, defaultW, defaultH, project, filter, graphTitle);
        this.intervalSize = intervalSize;
        this.groupByCategories = groupByCategories;
    }

    protected JFreeChart createGraph() {
        TimeTableXYDataset dataset = this.createDataset();
        DateAxis xAxis = new DateAxis();
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        Calendar lowerBound = this.getLowerGraphBound();
        xAxis.setRange((double)lowerBound.getTimeInMillis(), (double)Calendar.getInstance().getTimeInMillis());
        NumberAxis yAxis = new NumberAxis(Y_AXIS_LABEL);
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedXYBarRenderer renderer = new StackedXYBarRenderer();
        renderer.setBaseToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset dataset, int series, int item) {
                String seriesKey = dataset.getSeriesKey(series).toString();
                StringBuilder sb = new StringBuilder();
                if (seriesKey.equals("Others")) {
                    long timeInMillis = dataset.getX(series, item).longValue();
                    Date time = new Date(timeInMillis);
                    Day period = null;
                    if (TimeSeriesChart.this.intervalSize == 5) {
                        period = new Day(time);
                    } else if (TimeSeriesChart.this.intervalSize == 11) {
                        period = new Hour(time);
                    } else if (TimeSeriesChart.this.intervalSize == 2) {
                        period = new Month(time);
                    }
                    List excludedDataList = (List)TimeSeriesChart.this.excludedDataForPeriod.get(period);
                    if (excludedDataList != null) {
                        Collections.sort(excludedDataList, new Comparator<FailureCauseTimeInterval>(){

                            @Override
                            public int compare(FailureCauseTimeInterval o1, FailureCauseTimeInterval o2) {
                                return o2.getNumber() - o1.getNumber();
                            }
                        });
                        for (FailureCauseTimeInterval excludedData : excludedDataList) {
                            sb.append(excludedData).append(" \n");
                        }
                    }
                } else {
                    int number = dataset.getY(series, item).intValue();
                    sb.append(seriesKey).append(": ").append(number);
                }
                return sb.toString();
            }
        });
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setRangeAxis((ValueAxis)yAxis);
        JFreeChart chart = new JFreeChart(this.graphTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        return chart;
    }

    protected Calendar getLowerGraphBound() {
        Calendar lowerBound = Calendar.getInstance();
        if (this.intervalSize == 5) {
            lowerBound.add(2, -1);
        } else if (this.intervalSize == 11) {
            lowerBound.add(5, -1);
        } else {
            lowerBound.add(1, -3);
        }
        return lowerBound;
    }

    private TimeTableXYDataset createDataset() {
        List<FailureCauseTimeInterval> intervals;
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        this.excludedDataForPeriod = new HashMap<TimePeriod, List<FailureCauseTimeInterval>>();
        HashSet<String> topItems = new HashSet<String>();
        KnowledgeBase knowledgeBase = PluginImpl.getInstance().getKnowledgeBase();
        List<ObjectCountPair<String>> topEntries = this.groupByCategories ? knowledgeBase.getNbrOfFailureCategoriesPerName(this.filter, 8) : knowledgeBase.getNbrOfFailureCausesPerId(this.filter, 8);
        if (topEntries != null) {
            for (ObjectCountPair<String> countPair : topEntries) {
                topItems.add(countPair.getObject());
            }
        }
        if ((intervals = knowledgeBase.getFailureCausesPerTime(this.intervalSize, this.filter, this.groupByCategories)) != null) {
            TimePeriod period;
            for (FailureCauseTimeInterval failureCauseTimeInterval : intervals) {
                period = failureCauseTimeInterval.getPeriod();
                String name = failureCauseTimeInterval.getName();
                int number = failureCauseTimeInterval.getNumber();
                if (topItems.contains(failureCauseTimeInterval.getId()) || topItems.contains(name)) {
                    dataset.add(period, (double)number, name);
                    continue;
                }
                List<FailureCauseTimeInterval> list = this.excludedDataForPeriod.get(period);
                if (list == null) {
                    list = new ArrayList<FailureCauseTimeInterval>();
                    this.excludedDataForPeriod.put(period, list);
                }
                list.add(new FailureCauseTimeInterval(period, name, number));
            }
            for (Map.Entry entry : this.excludedDataForPeriod.entrySet()) {
                period = (TimePeriod)entry.getKey();
                List list = (List)entry.getValue();
                int sum = 0;
                for (FailureCauseTimeInterval excludedData : list) {
                    sum += excludedData.getNumber();
                }
                dataset.add(period, (double)sum, "Others");
            }
        }
        return dataset;
    }
}

