/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.BuildLogIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import hudson.model.AbstractBuild;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildLogFailureReader
extends FailureReader {
    private static final Logger logger = Logger.getLogger(BuildLogFailureReader.class.getName());

    public BuildLogFailureReader(BuildLogIndication indication) {
        super(indication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FoundIndication scan(AbstractBuild build) throws IOException {
        String currentfile = build.getLogFile().getName();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(build.getLogReader());
            FoundIndication foundIndication = this.scanOneFile(build, reader, currentfile);
            return foundIndication;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public FoundIndication scan(AbstractBuild build, PrintStream buildLog) {
        FoundIndication foundIndication;
        block22: {
            long start;
            BufferedReader reader;
            block19: {
                foundIndication = null;
                String currentFile = build.getLogFile().getName();
                reader = null;
                start = System.currentTimeMillis();
                reader = new BufferedReader(build.getLogReader());
                foundIndication = this.scanOneFile(build, reader, currentFile);
                if (reader == null) break block19;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
            }
            break block22;
            catch (IOException ioe) {
                block20: {
                    logger.log(Level.SEVERE, "[BFA] I/O problems during indication analysis: ", ioe);
                    buildLog.println("[BFA] I/O problems during indication analysis.");
                    if (reader == null) break block20;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to close the reader. ", e);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                }
            }
            catch (Exception e) {
                block21: {
                    logger.log(Level.SEVERE, "[BFA] Could not open reader for indication: ", e);
                    buildLog.println("[BFA] Could not open reader for indication.");
                    if (reader == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e2) {
                                    logger.log(Level.WARNING, "Failed to close the reader. ", e2);
                                }
                            }
                            if (logger.isLoggable(Level.FINER)) {
                                logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                            }
                            throw throwable;
                        }
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        logger.log(Level.WARNING, "Failed to close the reader. ", e3);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                }
            }
        }
        return foundIndication;
    }
}

