/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.tokens;

import com.google.common.base.Splitter;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandTask;
import hudson.Extension;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension(optional=true)
public class Token
extends DataBoundTokenMacro {
    private static final int ITEM_INCREMENT = 0;
    private static final int LIST_INCREMENT = 1;
    private static final String LIST_BULLET = "* ";
    private static final String LIST_BULLET_SPACE = "  ";
    private static final Logger logger = Logger.getLogger((String)Token.class.getName());
    private boolean includeIndications = true;
    private boolean useHtmlFormat = false;
    private boolean includeTitle = true;
    private int wrapWidth = 0;
    private String noFailureText = "";

    @DataBoundTokenMacro.Parameter
    public void setIncludeIndications(boolean includeIndications) {
        this.includeIndications = includeIndications;
    }

    @DataBoundTokenMacro.Parameter
    public void setUseHtmlFormat(boolean useHtmlFormat) {
        this.useHtmlFormat = useHtmlFormat;
    }

    @DataBoundTokenMacro.Parameter
    public void setIncludeTitle(boolean includeTitle) {
        this.includeTitle = includeTitle;
    }

    @DataBoundTokenMacro.Parameter
    public void setWrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
    }

    @DataBoundTokenMacro.Parameter
    public void setNoFailureText(String noFailureText) {
        this.noFailureText = noFailureText;
    }

    public boolean acceptsMacroName(String macroName) {
        return "BUILD_FAILURE_ANALYZER".equals(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        new ScanOnDemandTask(build).run();
        FailureCauseBuildAction action = (FailureCauseBuildAction)build.getAction(FailureCauseBuildAction.class);
        if (action != null) {
            FailureCauseDisplayData data = action.getFailureCauseDisplayData();
            if (data.getFoundFailureCauses().isEmpty() && data.getDownstreamFailureCauses().isEmpty()) {
                logger.info((Object)"there were no causes");
                return this.noFailureText;
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.addTitle(stringBuilder);
            boolean indentLevel = false;
            this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, 0);
            return stringBuilder.toString();
        }
        FailureCauseMatrixBuildAction matrixAction = (FailureCauseMatrixBuildAction)build.getAction(FailureCauseMatrixBuildAction.class);
        if (matrixAction != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.addTitle(stringBuilder);
            boolean indentLevel = false;
            this.addFailureCauseMatrixRepresentation(stringBuilder, matrixAction, 0);
            return stringBuilder.toString();
        }
        return "";
    }

    private void addTitle(StringBuilder stringBuilder) {
        if (this.includeTitle) {
            String title = "Identified problems:";
            if (this.useHtmlFormat) {
                stringBuilder.append("<h2>");
                stringBuilder.append("Identified problems:");
                stringBuilder.append("</h2>");
            } else {
                stringBuilder.append("Identified problems:");
                stringBuilder.append("\n");
            }
        }
    }

    private void addFailureCauseMatrixRepresentation(StringBuilder stringBuilder, FailureCauseMatrixBuildAction matrixAction, int indentLevel) {
        List<MatrixRun> matrixRuns = matrixAction.getRunsWithAction();
        if (this.useHtmlFormat) {
            stringBuilder.append("<ul>");
        }
        for (MatrixRun matrixRun : matrixRuns) {
            this.addMatrixRunRepresentation(stringBuilder, matrixRun, indentLevel + 0);
        }
        if (this.useHtmlFormat) {
            stringBuilder.append("</ul>");
        }
    }

    private void addMatrixRunRepresentation(StringBuilder stringBuilder, MatrixRun matrixRun, int indentLevel) {
        FailureCauseDisplayData data = FailureCauseMatrixBuildAction.getFailureCauseDisplayData(matrixRun);
        if (data.getFoundFailureCauses().isEmpty() && data.getDownstreamFailureCauses().isEmpty()) {
            return;
        }
        int nextIndentLevel = indentLevel + 1;
        if (this.useHtmlFormat) {
            stringBuilder.append("<li>");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(matrixRun.getFullDisplayName()));
            }
            catch (IOException exception) {
                stringBuilder.append("matrix-full-display-name");
            }
            this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, nextIndentLevel);
            stringBuilder.append("</li>");
        } else {
            stringBuilder.append(Token.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET);
            stringBuilder.append(matrixRun.getFullDisplayName());
            stringBuilder.append("\n");
            this.addFailureCauseDisplayDataRepresentation(stringBuilder, data, nextIndentLevel);
        }
    }

    private void addFailureCauseDisplayDataRepresentation(StringBuilder stringBuilder, FailureCauseDisplayData data, int indentLevel) {
        IndicationUrlBuilder indicationUrlBuilder = new IndicationUrlBuilder();
        indicationUrlBuilder.setBuildUrl(data.getLinks().getBuildUrl());
        List<FoundFailureCause> causes = data.getFoundFailureCauses();
        int nextIndentLevel = indentLevel + 0;
        if (this.useHtmlFormat) {
            stringBuilder.append("<ul>");
            for (FoundFailureCause cause : causes) {
                indicationUrlBuilder.setCause(cause);
                this.addFailureCauseRepresentation(stringBuilder, indicationUrlBuilder, cause, nextIndentLevel);
            }
            stringBuilder.append("</ul>");
        } else {
            for (FoundFailureCause cause : causes) {
                indicationUrlBuilder.setCause(cause);
                this.addFailureCauseRepresentation(stringBuilder, indicationUrlBuilder, cause, nextIndentLevel);
            }
        }
    }

    private void addFailureCauseRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, FoundFailureCause cause, int indentLevel) {
        int nextIndentLevel = indentLevel + 1;
        if (this.useHtmlFormat) {
            stringBuilder.append("<li>");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(cause.getName()));
            }
            catch (IOException exception) {
                stringBuilder.append("cause-name");
            }
            stringBuilder.append(": ");
            try {
                stringBuilder.append(Jenkins.getInstance().getMarkupFormatter().translate(cause.getDescription()));
            }
            catch (IOException exception) {
                stringBuilder.append("cause-description");
            }
            if (this.includeIndications) {
                this.addIndicationsRepresentation(stringBuilder, indicationUrlBuilder, cause.getIndications(), nextIndentLevel);
            }
            stringBuilder.append("</li>");
        } else {
            List<String> lines = Token.wrap(cause.getName() + ": " + cause.getDescription(), this.wrapWidth - Token.indentForDepth(indentLevel).length() - LIST_BULLET.length());
            int lineCount = lines.size();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                if (lineIndex == 0) {
                    stringBuilder.append(LIST_BULLET);
                } else {
                    stringBuilder.append(LIST_BULLET_SPACE);
                }
                stringBuilder.append(lines.get(lineIndex));
                stringBuilder.append("\n");
            }
            if (this.includeIndications) {
                this.addIndicationsRepresentation(stringBuilder, indicationUrlBuilder, cause.getIndications(), nextIndentLevel);
            }
        }
    }

    private void addIndicationsRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, List<FoundIndication> indications, int indentLevel) {
        int nextIndentLevel = indentLevel + 0;
        if (this.useHtmlFormat) {
            stringBuilder.append("<ul>");
            int size = indications.size();
            for (int i = 0; i < size; ++i) {
                FoundIndication indication = indications.get(i);
                indicationUrlBuilder.setIndication(indication);
                int indicationNumber = i + 1;
                this.addIndicationRepresentation(stringBuilder, indicationUrlBuilder, indication, indicationNumber, nextIndentLevel);
            }
            stringBuilder.append("</ul>");
        } else {
            int size = indications.size();
            for (int i = 0; i < size; ++i) {
                FoundIndication indication = indications.get(i);
                indicationUrlBuilder.setIndication(indication);
                int indicationNumber = i + 1;
                this.addIndicationRepresentation(stringBuilder, indicationUrlBuilder, indication, indicationNumber, nextIndentLevel);
            }
        }
    }

    private void addIndicationRepresentation(StringBuilder stringBuilder, IndicationUrlBuilder indicationUrlBuilder, FoundIndication indication, int indicationNumber, int indentLevel) {
        if (this.useHtmlFormat) {
            stringBuilder.append("<li><a href=\"");
            stringBuilder.append(indicationUrlBuilder.getUrlString());
            stringBuilder.append("\">");
            stringBuilder.append("Indication ");
            stringBuilder.append(indicationNumber);
            stringBuilder.append("</a></li>");
        } else {
            stringBuilder.append(Token.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET);
            stringBuilder.append("Indication ");
            stringBuilder.append(indicationNumber);
            stringBuilder.append(":\n");
            stringBuilder.append(Token.indentForDepth(indentLevel));
            stringBuilder.append(LIST_BULLET_SPACE);
            stringBuilder.append("<");
            stringBuilder.append(indicationUrlBuilder.getUrlString());
            stringBuilder.append(">\n");
        }
    }

    private static String indentForDepth(int indentLevel) {
        return StringUtils.repeat((String)LIST_BULLET_SPACE, (int)indentLevel);
    }

    static List<String> wrap(String text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        Splitter lineSplitter = Splitter.on((Pattern)Pattern.compile("\\r?\\n"));
        for (String line : lineSplitter.split((CharSequence)text)) {
            if (width > 0) {
                Pattern firstNonwhitespacePattern = Pattern.compile("[^\\s]");
                Matcher firstNonwhiteSpaceMatcher = firstNonwhitespacePattern.matcher(line);
                String indent = "";
                if (firstNonwhiteSpaceMatcher.find()) {
                    indent = line.substring(0, firstNonwhiteSpaceMatcher.start());
                }
                String wrappedLines = WordUtils.wrap((String)line, (int)(width - indent.length()));
                for (String wrappedLine : lineSplitter.split((CharSequence)wrappedLines)) {
                    lines.add(indent + wrappedLine.trim());
                }
                continue;
            }
            lines.add(line);
        }
        return lines;
    }

    private static class IndicationUrlBuilder {
        private String buildUrl = "";
        private String causeId = "";
        private String indicationHash = "";

        private IndicationUrlBuilder() {
        }

        void setBuildUrl(String buildUrl) {
            this.buildUrl = buildUrl;
        }

        void setCause(FoundFailureCause cause) {
            this.causeId = cause.getId();
        }

        void setIndication(FoundIndication indication) {
            this.indicationHash = String.valueOf(indication.getMatchingHash());
        }

        String getUrlString() {
            StringBuilder builder = new StringBuilder();
            builder.append(Jenkins.getInstance().getRootUrl());
            builder.append("/");
            builder.append(this.buildUrl);
            builder.append("consoleFull#");
            builder.append(this.indicationHash);
            builder.append(this.causeId);
            return builder.toString();
        }

        public String toString() {
            return this.getUrlString();
        }
    }
}

