/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.LocalFileKnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandQueue;
import com.sonyericsson.jenkins.plugins.bfa.sod.ScanOnDemandVariables;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class PluginImpl
extends Plugin {
    private static final Logger logger = Logger.getLogger(PluginImpl.class.getName());
    public static final String DEFAULT_ICON_SIZE = "24x24";
    public static final String DEFAULT_ICON_NAME = "information.png";
    public static final int DEFAULT_NR_OF_SCAN_THREADS = 3;
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._PermissionGroup_Title());
    public static final Permission UPDATE_PERMISSION = new Permission(PERMISSION_GROUP, "UpdateCauses", Messages._PermissionUpdate_Description(), Hudson.ADMINISTER);
    public static final Permission VIEW_PERMISSION = new Permission(PERMISSION_GROUP, "ViewCauses", Messages._PermissionView_Description(), UPDATE_PERMISSION);
    public static final Permission REMOVE_PERMISSION = new Permission(PERMISSION_GROUP, "RemoveCause", Messages._PermissionRemove_Description(), Hudson.ADMINISTER);
    private static final String DEFAULT_NO_CAUSES_MESSAGE = "No problems were identified. If you know why this problem occurred, please add a suitable Cause for it.";
    private static String staticResourcesBase = null;
    protected static final int MINIMUM_NR_OF_SCAN_THREADS = 1;
    private String noCausesMessage;
    private Boolean globalEnabled;
    private Boolean gerritTriggerEnabled;
    private transient CopyOnWriteList<FailureCause> causes;
    private KnowledgeBase knowledgeBase;
    private int nrOfScanThreads;
    private Boolean graphsEnabled;
    private Boolean testResultParsingEnabled;
    private String testResultCategories;
    private ScanOnDemandVariables sodVariables;

    public void start() throws Exception {
        super.start();
        logger.finer("[BFA] Starting...");
        this.load();
        if (this.noCausesMessage == null) {
            this.noCausesMessage = DEFAULT_NO_CAUSES_MESSAGE;
        }
        if (this.testResultCategories == null) {
            this.testResultCategories = "";
        }
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        this.sodVariables = new ScanOnDemandVariables();
        if (this.sodVariables.getMinimumSodWorkerThreads() < 1) {
            this.sodVariables.setMinimumSodWorkerThreads(1);
        }
        if (this.sodVariables.getMaximumSodWorkerThreads() < 1) {
            this.sodVariables.setMaximumSodWorkerThreads(1);
        }
        if (this.sodVariables.getSodThreadKeepAliveTime() < 1) {
            this.sodVariables.setSodThreadKeepAliveTime(15);
        }
        if (this.sodVariables.getSodWaitForJobShutdownTimeout() < 1) {
            this.sodVariables.setSodWaitForJobShutdownTimeout(30);
        }
        if (this.sodVariables.getSodCorePoolNumberOfThreads() < 1) {
            this.sodVariables.setSodCorePoolNumberOfThreads(5);
        }
        if (this.knowledgeBase == null) {
            if (this.causes == null) {
                this.knowledgeBase = new LocalFileKnowledgeBase();
            } else {
                this.knowledgeBase = new LocalFileKnowledgeBase(this.causes);
                this.causes = null;
            }
        }
        try {
            this.knowledgeBase.start();
            logger.fine("[BFA] Started!");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not initialize the knowledge base: ", e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        ScanOnDemandQueue.shutdown();
        this.knowledgeBase.stop();
    }

    public static String getStaticResourcesBase() {
        if (staticResourcesBase == null) {
            PluginWrapper wrapper;
            PluginManager pluginManager = Hudson.getInstance().getPluginManager();
            if (pluginManager != null && (wrapper = pluginManager.getPlugin(PluginImpl.class)) != null) {
                staticResourcesBase = "/plugin/" + wrapper.getShortName();
            }
            if (staticResourcesBase == null) {
                return "/plugin/build-failure-analyzer";
            }
        }
        return staticResourcesBase;
    }

    public ScanOnDemandVariables getSodVariables() {
        return this.sodVariables;
    }

    public static String getStaticImagesBase() {
        return PluginImpl.getStaticResourcesBase() + "/images";
    }

    public static String getImageUrl(String size, String name) {
        return PluginImpl.getStaticImagesBase() + "/" + size + "/" + name;
    }

    public static String getFullImageUrl(String size, String name) {
        return Hudson.getInstance().getRootUrl() + PluginImpl.getImageUrl(size, name);
    }

    public static String getImageUrl(String name) {
        return PluginImpl.getImageUrl(DEFAULT_ICON_SIZE, name);
    }

    public static String getDefaultIcon() {
        return PluginImpl.getImageUrl(DEFAULT_ICON_NAME);
    }

    public static PluginImpl getInstance() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }

    public String getNoCausesMessage() {
        return this.noCausesMessage;
    }

    public boolean isGlobalEnabled() {
        if (this.globalEnabled == null) {
            return true;
        }
        return this.globalEnabled;
    }

    public boolean isGraphsEnabled() {
        if (this.graphsEnabled == null || this.knowledgeBase == null) {
            return false;
        }
        return this.knowledgeBase.isStatisticsEnabled() && this.graphsEnabled != false;
    }

    public boolean isTestResultParsingEnabled() {
        if (this.testResultParsingEnabled == null) {
            return false;
        }
        return this.testResultParsingEnabled;
    }

    public String getTestResultCategories() {
        return this.testResultCategories;
    }

    public void setGlobalEnabled(Boolean globalEnabled) {
        this.globalEnabled = globalEnabled;
    }

    public void setTestResultParsingEnabled(Boolean testResultParsingEnabled) {
        this.testResultParsingEnabled = testResultParsingEnabled;
    }

    public void setTestResultCategories(String testResultCategories) {
        this.testResultCategories = testResultCategories;
    }

    public boolean isGerritTriggerEnabled() {
        if (this.gerritTriggerEnabled == null) {
            return true;
        }
        return this.gerritTriggerEnabled;
    }

    public void setGerritTriggerEnabled(Boolean gerritTriggerEnabled) {
        this.gerritTriggerEnabled = gerritTriggerEnabled;
    }

    public int getNrOfScanThreads() {
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        return this.nrOfScanThreads;
    }

    public void setNrOfScanThreads(int nrOfScanThreads) {
        if (nrOfScanThreads < 1) {
            throw new IllegalArgumentException("Minimum nrOfScanThreads is 1");
        }
        this.nrOfScanThreads = nrOfScanThreads;
    }

    public static boolean shouldScan(AbstractBuild build) {
        return PluginImpl.shouldScan(build.getProject());
    }

    public static boolean shouldScan(AbstractProject project) {
        if (PluginImpl.getInstance().isGlobalEnabled()) {
            ScannerJobProperty property = (ScannerJobProperty)project.getProperty(ScannerJobProperty.class);
            if (property != null) {
                return !property.isDoNotScan();
            }
            return true;
        }
        return false;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public ExtensionList<KnowledgeBase.KnowledgeBaseDescriptor> getKnowledgeBaseDescriptors() {
        return KnowledgeBase.KnowledgeBaseDescriptor.all();
    }

    public KnowledgeBase.KnowledgeBaseDescriptor getKnowledgeBaseDescriptor(String descString) {
        for (KnowledgeBase.KnowledgeBaseDescriptor desc : this.getKnowledgeBaseDescriptors()) {
            if (!((Object)((Object)desc)).getClass().toString().contains(descString)) continue;
            return desc;
        }
        return null;
    }

    public void configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException, IOException {
        this.noCausesMessage = o.getString("noCausesMessage");
        this.globalEnabled = o.getBoolean("globalEnabled");
        this.gerritTriggerEnabled = o.getBoolean("gerritTriggerEnabled");
        this.graphsEnabled = o.getBoolean("graphsEnabled");
        this.testResultParsingEnabled = o.getBoolean("testResultParsingEnabled");
        this.testResultCategories = o.getString("testResultCategories");
        int scanThreads = o.getInt("nrOfScanThreads");
        int minSodWorkerThreads = o.getInt("minimumNumberOfWorkerThreads");
        int maxSodWorkerThreads = o.getInt("maximumNumberOfWorkerThreads");
        int thrkeepAliveTime = o.getInt("maximumNumberOfWorkerThreads");
        int jobShutdownTimeWait = o.getInt("waitForJobShutdownTime");
        int corePoolNumberOfThreads = o.getInt("corePoolNumberOfThreads");
        this.nrOfScanThreads = scanThreads < 1 ? 3 : scanThreads;
        if (corePoolNumberOfThreads < 5) {
            this.sodVariables.setSodCorePoolNumberOfThreads(5);
        } else {
            this.sodVariables.setSodCorePoolNumberOfThreads(corePoolNumberOfThreads);
        }
        if (jobShutdownTimeWait < 30) {
            this.sodVariables.setSodWaitForJobShutdownTimeout(30);
        } else {
            this.sodVariables.setSodWaitForJobShutdownTimeout(jobShutdownTimeWait);
        }
        if (thrkeepAliveTime < 15) {
            this.sodVariables.setSodThreadKeepAliveTime(15);
        } else {
            this.sodVariables.setSodThreadKeepAliveTime(thrkeepAliveTime);
        }
        if (minSodWorkerThreads < 1) {
            this.sodVariables.setMinimumSodWorkerThreads(1);
        } else {
            this.sodVariables.setMinimumSodWorkerThreads(minSodWorkerThreads);
        }
        if (maxSodWorkerThreads < 1) {
            this.sodVariables.setMaximumSodWorkerThreads(1);
        } else {
            this.sodVariables.setMaximumSodWorkerThreads(maxSodWorkerThreads);
        }
        if (maxSodWorkerThreads < 1) {
            this.sodVariables.setMaximumSodWorkerThreads(1);
        } else {
            this.sodVariables.setMaximumSodWorkerThreads(maxSodWorkerThreads);
        }
        KnowledgeBase base = (KnowledgeBase)req.bindJSON(KnowledgeBase.class, o.getJSONObject("knowledgeBase"));
        if (base != null && !this.knowledgeBase.equals(base)) {
            try {
                base.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not start new knowledge base, reverting ", e);
                this.save();
                return;
            }
            if (o.getBoolean("convertOldKb")) {
                try {
                    base.convertFrom(this.knowledgeBase);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not convert knowledge base ", e);
                }
            }
            this.knowledgeBase.stop();
            this.knowledgeBase = base;
        }
        this.save();
    }
}

