/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import com.sonyericsson.jenkins.plugins.bfa.BuildFailureScanner;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseMatrixBuildAction;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Result;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScanOnDemandTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(ScanOnDemandTask.class.getName());
    private AbstractBuild build;

    public ScanOnDemandTask(AbstractBuild build) {
        this.build = build;
    }

    @Override
    public void run() {
        try {
            if (this.build instanceof MatrixBuild) {
                List runs = ((MatrixBuild)this.build).getRuns();
                for (AbstractBuild run : runs) {
                    if (!run.getActions(FailureCauseBuildAction.class).isEmpty() || !run.getActions(FailureCauseMatrixBuildAction.class).isEmpty() || !run.getResult().isWorseThan(Result.SUCCESS) || run.getNumber() != this.build.getNumber()) continue;
                    this.scanBuild(run);
                }
                this.endMatrixBuildScan();
            } else {
                this.scanBuild(this.build);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to add a FailureScanner to " + this.build.getProject().getFullDisplayName(), e);
        }
    }

    public void endMatrixBuildScan() throws IOException {
        List runs = ((MatrixBuild)this.build).getRuns();
        LinkedList<MatrixRun> runsWithCorrectNumber = new LinkedList<MatrixRun>();
        boolean i = false;
        for (MatrixRun run : runs) {
            if (run.getNumber() != this.build.getNumber()) continue;
            runsWithCorrectNumber.add(run);
        }
        this.build.addAction((Action)new FailureCauseMatrixBuildAction((MatrixBuild)this.build, runsWithCorrectNumber));
        this.build.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanBuild(AbstractBuild abstractBuild) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(abstractBuild.getLogFile(), true);
            PrintStream buildLog = new PrintStream((OutputStream)fos, true, "UTF8");
            PluginImpl.getInstance().getKnowledgeBase().removeBuildfailurecause(abstractBuild);
            BuildFailureScanner.scanIfNotScanned(abstractBuild, buildLog);
            abstractBuild.save();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not get the causes from the knowledge base", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the build log file " + abstractBuild.getLogFile(), e);
                }
            }
        }
    }
}

